/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.math.colors;

import com.mojang.blaze3d.platform.NativeImage;
import javax.annotation.concurrent.Immutable;
import net.mehvahdjukaar.selene.math.colors.BaseColor;
import net.minecraft.util.Mth;

@Immutable
public class RGBColor
extends BaseColor<RGBColor> {
    public RGBColor(int value) {
        this((float)NativeImage.m_85085_((int)value) / 255.0f, (float)NativeImage.m_85103_((int)value) / 255.0f, (float)NativeImage.m_85119_((int)value) / 255.0f, (float)NativeImage.m_84983_((int)value) / 255.0f);
    }

    public RGBColor(float r, float g, float b, float a) {
        super(Mth.m_14036_((float)r, (float)0.0f, (float)1.0f), Mth.m_14036_((float)g, (float)0.0f, (float)1.0f), Mth.m_14036_((float)b, (float)0.0f, (float)1.0f), Mth.m_14036_((float)a, (float)0.0f, (float)1.0f));
    }

    public String toString() {
        return String.format("R: %s, G: %s, B %s", (int)(255.0f * this.red()), (int)(255.0f * this.green()), (int)(255.0f * this.blue()));
    }

    public float red() {
        return this.v0;
    }

    public float green() {
        return this.v1;
    }

    public float blue() {
        return this.v2;
    }

    public float alpha() {
        return this.v3;
    }

    public RGBColor withRed(float red) {
        return new RGBColor(red, this.green(), this.blue(), this.alpha());
    }

    public RGBColor withGreen(float green) {
        return new RGBColor(this.red(), green, this.blue(), this.alpha());
    }

    public RGBColor withBlue(float blue) {
        return new RGBColor(this.red(), this.green(), blue, this.alpha());
    }

    public RGBColor withAlpha(float alpha) {
        return new RGBColor(this.red(), this.green(), this.blue(), alpha);
    }

    @Override
    public RGBColor asRGB() {
        return this;
    }

    public static RGBColor averageColors(RGBColor ... colors) {
        float size = colors.length;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        float a = 0.0f;
        for (RGBColor c : colors) {
            r += c.red();
            g += c.green();
            b += c.blue();
            a += c.alpha();
        }
        return new RGBColor(r / size, g / size, b / size, a / size);
    }

    @Override
    public RGBColor mixWith(RGBColor color, float bias) {
        float i = 1.0f - bias;
        float r = this.red() * i + color.red() * bias;
        float g = this.green() * i + color.green() * bias;
        float b = this.blue() * i + color.blue() * bias;
        float a = this.alpha() * i + color.alpha() * bias;
        return new RGBColor(r, g, b, a);
    }

    @Override
    public RGBColor fromRGB(RGBColor rgb) {
        return this;
    }

    public int toInt() {
        return NativeImage.m_84992_((int)((int)(this.alpha() * 255.0f)), (int)((int)(this.blue() * 255.0f)), (int)((int)(this.green() * 255.0f)), (int)((int)(this.red() * 255.0f)));
    }
}

