/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.network;

import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.selene.Selene;
import net.mehvahdjukaar.selene.map.CustomDataHolder;
import net.mehvahdjukaar.selene.map.CustomDecoration;
import net.mehvahdjukaar.selene.map.CustomDecorationType;
import net.mehvahdjukaar.selene.map.ExpandedMapData;
import net.mehvahdjukaar.selene.map.MapDecorationHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class ClientBoundSyncCustomMapDecorationPacket {
    private final int mapId;
    private final byte scale;
    private final boolean locked;
    private final CustomDecoration[] customDecoration;
    private final CustomDataHolder.Instance<?>[] customData;

    public ClientBoundSyncCustomMapDecorationPacket(int mapId, byte pScale, boolean pLocked, CustomDecoration[] customDecoration, CustomDataHolder.Instance<?>[] customData) {
        this.mapId = mapId;
        this.scale = pScale;
        this.locked = pLocked;
        this.customData = customData;
        this.customDecoration = customDecoration;
    }

    public ClientBoundSyncCustomMapDecorationPacket(FriendlyByteBuf pBuffer) {
        Object type;
        int m;
        this.mapId = pBuffer.m_130242_();
        this.scale = pBuffer.readByte();
        this.locked = pBuffer.readBoolean();
        this.customDecoration = new CustomDecoration[pBuffer.m_130242_()];
        for (m = 0; m < this.customDecoration.length; ++m) {
            type = MapDecorationHandler.get(pBuffer.m_130281_());
            if (type == null) continue;
            this.customDecoration[m] = ((CustomDecorationType)type).loadDecorationFromBuffer(pBuffer);
        }
        this.customData = new CustomDataHolder.Instance[pBuffer.m_130242_()];
        for (m = 0; m < this.customData.length; ++m) {
            type = MapDecorationHandler.CUSTOM_MAP_DATA_TYPES.getOrDefault(pBuffer.m_130277_(), null);
            if (type == null) continue;
            this.customData[m] = ((CustomDataHolder)type).createFromBuffer(pBuffer);
        }
    }

    public static void buffer(ClientBoundSyncCustomMapDecorationPacket message, FriendlyByteBuf buffer) {
        buffer.m_130130_(message.mapId);
        buffer.writeByte((int)message.scale);
        buffer.writeBoolean(message.locked);
        buffer.m_130130_(message.customDecoration.length);
        for (CustomDecoration decoration : message.customDecoration) {
            buffer.m_130085_(decoration.getType().getId());
            decoration.saveToBuffer(buffer);
        }
        buffer.m_130130_(message.customData.length);
        for (CustomDataHolder.Instance<?> data : message.customData) {
            buffer.m_130070_(data.getType().id());
            data.saveToBuffer(buffer);
        }
    }

    public static void handler(ClientBoundSyncCustomMapDecorationPacket message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                MapRenderer mapRenderer = Minecraft.m_91087_().f_91063_.m_109151_();
                int i = message.getMapId();
                String s = MapItem.m_42848_((int)i);
                MapItemSavedData mapData = Minecraft.m_91087_().f_91073_.m_7489_(s);
                if (mapData != null) {
                    message.applyToMap(mapData);
                    mapRenderer.m_168765_(i, mapData);
                }
            }
        });
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getMapId() {
        return this.mapId;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void applyToMap(MapItemSavedData data) {
        if (data instanceof ExpandedMapData) {
            ExpandedMapData mapData = (ExpandedMapData)data;
            Map<String, CustomDecoration> decorations = mapData.getCustomDecorations();
            decorations.clear();
            for (int i = 0; i < this.customDecoration.length; ++i) {
                CustomDecoration customDecoration = this.customDecoration[i];
                if (customDecoration != null) {
                    decorations.put("icon-" + i, customDecoration);
                    continue;
                }
                Selene.LOGGER.warn("Failed to load custom map decoration, skipping");
            }
            Map<String, CustomDataHolder.Instance<?>> customData = mapData.getCustomData();
            customData.clear();
            for (CustomDataHolder.Instance<?> instance : this.customData) {
                if (instance != null) {
                    customData.put(instance.getType().id(), instance);
                    continue;
                }
                Selene.LOGGER.warn("Failed to load custom map data, skipping: " + instance.getType().id());
            }
        }
    }
}

