/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.resourcepack;

import com.google.common.base.Stopwatch;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.mehvahdjukaar.selene.resourcepack.DynamicResourcePack;
import net.mehvahdjukaar.selene.resourcepack.DynamicTexturePack;
import net.mehvahdjukaar.selene.resourcepack.ResType;
import net.mehvahdjukaar.selene.resourcepack.VanillaResourceManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.eventbus.api.IEventBus;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

abstract class RPAwareDynamicResourceProvider<T extends DynamicResourcePack>
implements PreparableReloadListener {
    public final T dynamicPack;
    private boolean hasBeenInitialized;

    protected RPAwareDynamicResourceProvider(T pack) {
        this.dynamicPack = pack;
    }

    public void register(IEventBus bus) {
        ((DynamicResourcePack)this.dynamicPack).registerPack(bus);
    }

    public abstract Logger getLogger();

    public T getPack() {
        return this.dynamicPack;
    }

    public abstract boolean dependsOnLoadedPacks();

    public abstract void regenerateDynamicAssets(ResourceManager var1);

    public void generateStaticAssetsOnStartup(ResourceManager manager) {
    }

    public final CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier stage, ResourceManager manager, ProfilerFiller workerProfiler, ProfilerFiller mainProfiler, Executor workerExecutor, Executor mainExecutor) {
        Stopwatch watch = Stopwatch.createStarted();
        boolean resourcePackSupport = this.dependsOnLoadedPacks();
        if (!this.hasBeenInitialized) {
            this.hasBeenInitialized = true;
            this.generateStaticAssetsOnStartup(manager);
            T t = this.dynamicPack;
            if (t instanceof DynamicTexturePack) {
                DynamicTexturePack tp = (DynamicTexturePack)t;
                tp.addPackLogo();
            }
            if (!resourcePackSupport) {
                PackRepository pack = this.getRepository();
                if (pack != null) {
                    VanillaResourceManager vanillaManager = new VanillaResourceManager(pack);
                    this.regenerateDynamicAssets(vanillaManager);
                    vanillaManager.close();
                } else {
                    this.regenerateDynamicAssets(manager);
                }
            }
        }
        if (resourcePackSupport) {
            this.regenerateDynamicAssets(manager);
        }
        this.getLogger().info("Generated runtime {} for pack {} in: {} ms", (Object)((DynamicResourcePack)this.dynamicPack).getPackType(), (Object)((DynamicResourcePack)this.dynamicPack).m_8017_(), (Object)watch.elapsed().toMillis());
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> null, workerExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenAcceptAsync(noResult -> {}, mainExecutor);
    }

    @Nullable
    protected abstract PackRepository getRepository();

    public boolean alreadyHasAssetAtLocation(ResourceManager manager, ResourceLocation res, ResType type) {
        ResourceLocation fullRes = type.getPath(res);
        if (manager.m_7165_(fullRes)) {
            boolean bl;
            block9: {
                Resource r = manager.m_142591_(fullRes);
                try {
                    boolean bl2 = bl = !r.m_7816_().equals(((DynamicResourcePack)this.dynamicPack).m_8017_());
                    if (r == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                r.close();
            }
            return bl;
        }
        return false;
    }
}

