/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.blocks;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.mehvahdjukaar.advframes.init.ModRegistry;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import org.jetbrains.annotations.Nullable;

public class AdvancementFrameBlockTile
extends class_2586 {
    private String advancementId = null;
    private class_185 advancement;
    private GameProfile owner;
    private static class_3312 profileCache;
    @Nullable
    private static MinecraftSessionService sessionService;
    @Nullable
    private static Executor mainThreadExecutor;

    public AdvancementFrameBlockTile(class_2591<?> blockEntityType, class_2338 blockPos, class_2680 blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public AdvancementFrameBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.ADVANCEMENT_FRAME_TILE, pos, state);
    }

    public void setAdvancement(class_161 advancement, class_3222 player) {
        this.advancement = advancement.method_686();
        this.advancementId = advancement.method_688().toString();
        this.setOwner(new GameProfile(player.method_5667(), null));
    }

    protected void method_11007(class_2487 cmp) {
        super.method_11007(cmp);
        if (this.advancement != null) {
            class_2561 title;
            class_1937 class_19372 = this.field_11863;
            if (class_19372 instanceof class_3218) {
                class_3218 server = (class_3218)class_19372;
                if (this.owner != null && this.advancementId != null && !this.advancementId.isEmpty()) {
                    class_3222 sp;
                    class_161 a = server.method_8503().method_3851().method_12896(new class_2960(this.advancementId));
                    class_1657 player = this.field_11863.method_18470(this.owner.getId());
                    if (a == null || player instanceof class_3222 && !(sp = (class_3222)player).method_14236().method_12882(a).method_740()) {
                        return;
                    }
                }
            }
            class_2487 tag = new class_2487();
            if (this.advancementId != null) {
                cmp.method_10582("ID", this.advancementId);
            }
            if ((title = this.advancement.method_811()) instanceof class_2588) {
                class_2588 translatableComponent = (class_2588)title;
                tag.method_10582("Title", translatableComponent.method_11022());
            } else {
                tag.method_10582("Title", title.getString());
            }
            class_2561 description = this.advancement.method_817();
            if (description instanceof class_2588) {
                class_2588 translatableComponent = (class_2588)description;
                tag.method_10582("Description", translatableComponent.method_11022());
            } else {
                tag.method_10582("Description", description.getString());
            }
            tag.method_10566("Icon", (class_2520)this.advancement.method_821().method_7953(new class_2487()));
            tag.method_10569("FrameType", this.advancement.method_815().ordinal());
            cmp.method_10566("Advancement", (class_2520)tag);
        }
        if (this.owner != null) {
            cmp.method_25927("PlayerID", this.owner.getId());
        }
    }

    public void method_11014(class_2487 cmp) {
        super.method_11014(cmp);
        this.advancementId = null;
        if (cmp.method_10545("PlayerID")) {
            UUID id = cmp.method_25926("PlayerID");
            this.setOwner(new GameProfile(id, null));
        }
        if (cmp.method_10545("Advancement")) {
            class_2487 tag = cmp.method_10562("Advancement");
            if (cmp.method_10545("ID")) {
                this.advancementId = tag.method_10558("ID");
            }
            class_2588 title = new class_2588(tag.method_10558("Title"));
            class_2588 description = new class_2588(tag.method_10558("Description"));
            class_1799 icon = class_1799.method_7915((class_2487)tag.method_10562("Icon"));
            class_189 type = class_189.values()[tag.method_10550("FrameType")];
            this.advancement = new class_185(icon, (class_2561)title, (class_2561)description, null, type, false, true, true);
        }
    }

    public class_124 getColor() {
        class_189 v = this.getAdvancement().method_815();
        if (v == class_189.field_1249) {
            return class_124.field_1075;
        }
        return v.method_830();
    }

    public class_185 getAdvancement() {
        return this.advancement;
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public class_2622 getUpdatePacket() {
        if (this.advancement != null) {
            return class_2622.method_38585((class_2586)this);
        }
        return null;
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(@Nullable GameProfile input) {
        if (!(this.owner != null || input != null && input.isComplete())) {
            AdvancementFrameBlockTile advancementFrameBlockTile = this;
            synchronized (advancementFrameBlockTile) {
                this.owner = input;
            }
            AdvancementFrameBlockTile.updateGameProfile(this.owner, gameProfile -> {
                this.owner = gameProfile;
            });
        }
    }

    public static void updateGameProfile(@Nullable GameProfile gameProfile, Consumer<GameProfile> consumer) {
        if (!(gameProfile == null || gameProfile.getId() == null || gameProfile.isComplete() && gameProfile.getName() != null || profileCache == null || sessionService == null)) {
            Optional profile = profileCache.method_14512(gameProfile.getId());
            class_156.method_18349().execute(() -> class_156.method_17974((Optional)profile, p -> {
                if (p.getName() == null) {
                    p = sessionService.fillProfileProperties(p, true);
                }
                GameProfile finalGp = p;
                mainThreadExecutor.execute(() -> {
                    profileCache.method_14508(finalGp);
                    consumer.accept(finalGp);
                });
            }, () -> mainThreadExecutor.execute(() -> consumer.accept(gameProfile))));
        } else {
            consumer.accept(gameProfile);
        }
    }

    public static void setup(class_3312 p_196701_, MinecraftSessionService p_196702_, Executor p_196703_) {
        profileCache = p_196701_;
        sessionService = p_196702_;
        mainThreadExecutor = p_196703_;
    }

    public static void clear() {
        profileCache = null;
        sessionService = null;
        mainThreadExecutor = null;
    }
}

