/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.texture_renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.IntBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import net.mehvahdjukaar.advframes.AdvFrames;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_6364;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class FrameBufferBackedDynamicTexture
extends class_1044 {
    boolean initialized = false;
    private class_276 frameBuffer;
    private final int width;
    private final int height;
    private final class_2960 resourceLocation;
    @Nullable
    private class_1011 cpuImage;

    public FrameBufferBackedDynamicTexture(class_2960 resourceLocation, int width, int height) {
        this.width = width;
        this.height = height;
        this.resourceLocation = resourceLocation;
        class_310.method_1551().method_1531().method_4616(resourceLocation, (class_1044)this);
    }

    public FrameBufferBackedDynamicTexture(class_2960 resourceLocation, int size) {
        this(resourceLocation, size, size);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void method_4625(class_3300 manager) {
    }

    public class_276 getFrameBuffer() {
        if (this.frameBuffer == null) {
            this.frameBuffer = new class_6364(this.width, this.height);
            this.field_5204 = this.frameBuffer.method_30277();
        }
        return this.frameBuffer;
    }

    public void bindWrite() {
        this.getFrameBuffer().method_1235(true);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public class_2960 getTextureLocation() {
        return this.resourceLocation;
    }

    public int method_4624() {
        return this.getFrameBuffer().method_30277();
    }

    public void method_4528() {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::clearGlId0);
        } else {
            this.clearGlId0();
        }
    }

    private void clearGlId0() {
        if (this.frameBuffer != null) {
            this.frameBuffer.method_1238();
            this.frameBuffer = null;
        }
        this.field_5204 = -1;
    }

    public void close() {
        this.method_4528();
        if (this.cpuImage != null) {
            this.cpuImage.close();
            this.cpuImage = null;
        }
        class_310.method_1551().method_1531().method_4615(this.resourceLocation);
    }

    public class_1011 getPixels() {
        if (this.cpuImage == null) {
            this.cpuImage = new class_1011(this.width, this.height, false);
        }
        return this.cpuImage;
    }

    public void download() {
        this.method_23207();
        this.getPixels().method_4327(0, false);
    }

    public void upload() {
        if (this.cpuImage != null) {
            this.method_23207();
            this.cpuImage.method_4301(0, 0, 0, false);
            this.cpuImage.close();
            this.cpuImage = null;
        } else {
            AdvFrames.LOGGER.warn("Trying to upload disposed texture {}", (Object)this.method_4624());
        }
    }

    public List<Path> saveTextureToFile(Path texturesDir) throws IOException {
        int height;
        int width;
        int size;
        this.method_23207();
        String name = this.resourceLocation.method_12832().replace("/", "_");
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        int parentTextureWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int parentTextureHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        int minimumSize = Math.min(parentTextureWidth, parentTextureHeight);
        int mipmapLevels = class_3532.method_15351((int)minimumSize);
        ArrayList<Path> textureFiles = new ArrayList<Path>();
        for (int level = 0; level < mipmapLevels && (size = (width = GL11.glGetTexLevelParameteri((int)3553, (int)level, (int)4096)) * (height = GL11.glGetTexLevelParameteri((int)3553, (int)level, (int)4097))) != 0; ++level) {
            BufferedImage bufferedimage = new BufferedImage(width, height, 2);
            Path output = texturesDir.resolve(name + "_mipmap_" + level + ".png");
            IntBuffer buffer = BufferUtils.createIntBuffer((int)size);
            int[] data = new int[size];
            GL11.glGetTexImage((int)3553, (int)level, (int)32993, (int)33639, (IntBuffer)buffer);
            buffer.get(data);
            bufferedimage.setRGB(0, 0, width, height, data, 0, width);
            ImageIO.write((RenderedImage)bufferedimage, "png", output.toFile());
            textureFiles.add(output);
        }
        return textureFiles;
    }
}

