/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.advframes.texture_renderer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.mehvahdjukaar.advframes.texture_renderer.FrameBufferBackedDynamicTexture;
import net.minecraft.class_1159;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_276;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_761;
import net.minecraft.class_918;

public class RenderedTexturesManager {
    private static final List<RenderingData> REQUESTED_FOR_RENDERING = new ArrayList<RenderingData>();
    private static final LoadingCache<class_2960, FrameBufferBackedDynamicTexture> TEXTURE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).removalListener(i -> {
        FrameBufferBackedDynamicTexture value = (FrameBufferBackedDynamicTexture)((Object)((Object)i.getValue()));
        if (value != null) {
            value.close();
        }
    }).build((CacheLoader)new CacheLoader<class_2960, FrameBufferBackedDynamicTexture>(){

        public FrameBufferBackedDynamicTexture load(class_2960 key) {
            return null;
        }
    });

    public static void clearCache() {
        TEXTURE_CACHE.invalidateAll();
    }

    public static FrameBufferBackedDynamicTexture getRenderedTexture(class_2960 res, int size, Consumer<FrameBufferBackedDynamicTexture> textureDrawingFunction, boolean updateEachFrame) {
        FrameBufferBackedDynamicTexture texture = (FrameBufferBackedDynamicTexture)((Object)TEXTURE_CACHE.getIfPresent((Object)res));
        if (texture == null) {
            texture = new FrameBufferBackedDynamicTexture(res, size);
            TEXTURE_CACHE.put((Object)res, (Object)texture);
            REQUESTED_FOR_RENDERING.add(new RenderingData(res, textureDrawingFunction, updateEachFrame));
        }
        return texture;
    }

    public static FrameBufferBackedDynamicTexture getFlatItemStackTexture(class_2960 res, class_1799 stack, int size) {
        return RenderedTexturesManager.getRenderedTexture(res, size, t -> RenderedTexturesManager.drawItem(t, stack), true);
    }

    public static void updateTextures() {
        ListIterator<RenderingData> iter = REQUESTED_FOR_RENDERING.listIterator();
        while (iter.hasNext()) {
            RenderingData data = iter.next();
            FrameBufferBackedDynamicTexture texture = (FrameBufferBackedDynamicTexture)((Object)TEXTURE_CACHE.getIfPresent((Object)data.id));
            if (texture != null) {
                data.textureDrawingFunction.accept(texture);
            }
            if (data.animated && texture != null) continue;
            iter.remove();
        }
    }

    public static void drawItem2(FrameBufferBackedDynamicTexture tex, class_2338 mirrorPos, class_2350 mirrorDir, float partialTicks) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        class_276 frameBuffer = tex.getFrameBuffer();
        frameBuffer.method_1230(class_310.field_1703);
        frameBuffer.method_1235(true);
        int size = tex.getWidth();
        class_757 gameRenderer = mc.field_1773;
        class_761 levelRenderer = mc.field_1769;
        class_4587 posestack = RenderSystem.getModelViewStack();
        posestack.method_22903();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.clear((int)16640, (boolean)class_310.field_1703);
        class_758.method_23792();
        RenderSystem.enableTexture();
        RenderSystem.enableCull();
        RenderSystem.viewport((int)0, (int)0, (int)size, (int)size);
        gameRenderer.method_35766(1.0f, 0.0f, 0.0f);
        levelRenderer.method_3254();
        posestack.method_22909();
        RenderSystem.applyModelViewMatrix();
        mc.method_1522().method_1235(true);
    }

    public static class_1159 getProjectionMatrix(double pFov, int size, int renderDistance) {
        class_4587 posestack = new class_4587();
        posestack.method_23760().method_23761().method_22668();
        float zoom = 1.0f;
        float zoomX = 1.0f;
        float zoomY = 1.0f;
        if (zoom != 1.0f) {
            posestack.method_22904((double)zoomX, (double)(-zoomY), 0.0);
            posestack.method_22905(zoom, zoom, 1.0f);
        }
        posestack.method_23760().method_23761().method_22672(class_1159.method_4929((double)pFov, (float)((float)size / (float)size), (float)0.05f, (float)((float)renderDistance * 4.0f)));
        return posestack.method_23760().method_23761();
    }

    public static void drawItem(FrameBufferBackedDynamicTexture tex, class_1799 stack) {
        class_310 mc = class_310.method_1551();
        class_276 frameBuffer = tex.getFrameBuffer();
        frameBuffer.method_1230(class_310.field_1703);
        frameBuffer.method_1235(true);
        int size = 16;
        class_1159 oldProjection = RenderSystem.getProjectionMatrix();
        class_1159 matrix4f = class_1159.method_34239((float)0.0f, (float)size, (float)0.0f, (float)size, (float)1000.0f, (float)3000.0f);
        RenderSystem.setProjectionMatrix((class_1159)matrix4f);
        class_4587 posestack = RenderSystem.getModelViewStack();
        posestack.method_22903();
        posestack.method_34426();
        posestack.method_22904(0.0, 0.0, -2000.0);
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
        class_918 itemRenderer = mc.method_1480();
        itemRenderer.method_4010(stack, 0, 0);
        posestack.method_22909();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setProjectionMatrix((class_1159)oldProjection);
        mc.method_1522().method_1235(true);
    }

    private record RenderingData(class_2960 id, Consumer<FrameBufferBackedDynamicTexture> textureDrawingFunction, boolean animated) {
    }
}

