/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb;

import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import uk.co.dotcode.asb.config.ArmorSet;
import uk.co.dotcode.asb.config.Bonus;
import uk.co.dotcode.asb.config.ConfigHandler;
import uk.co.dotcode.asb.config.CuriosSetPiece;
import uk.co.dotcode.asb.packet.PacketHandler;
import uk.co.dotcode.asb.packet.SendArmorSetsPacket;

public class EventHandler {
    private int toolTipTickTimer = 0;

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getSide() == LogicalSide.SERVER && event.getTarget() instanceof LivingEntity) {
            this.checkAndApplyBonusesTo(event.getPlayer(), (LivingEntity)event.getTarget(), "interact");
        }
    }

    @SubscribeEvent
    public void playerAttack(AttackEntityEvent event) {
        if (event.getTarget() instanceof LivingEntity) {
            this.checkAndApplyBonusesTo(event.getPlayer(), (LivingEntity)event.getTarget(), "attack");
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            this.checkAndApplyBonusesTo(event.player, (LivingEntity)event.player, "self");
            this.checkAndApplyImmunitiesTo(event.player, (LivingEntity)event.player);
        }
    }

    private void checkAndApplyBonusesTo(PlayerEntity player, LivingEntity target, String interactionType) {
        for (ArmorSet as : ConfigHandler.localConfigArmorSets) {
            if (as.armorSetMatch(player)) {
                for (Bonus b : as.fullSetBonuses) {
                    b.applyBonus(target, interactionType);
                }
            } else {
                for (Bonus b : as.fullSetBonuses) {
                    b.removeBonus(target, interactionType);
                }
            }
            if (as.partialBonusRequiredAmount == null) continue;
            if (as.armorSetCount(player) >= as.partialBonusRequiredAmount) {
                for (Bonus b : as.partialSetBonuses) {
                    b.applyBonus(target, interactionType);
                }
                continue;
            }
            for (Bonus b : as.partialSetBonuses) {
                b.removeBonus(target, interactionType);
            }
        }
    }

    private void checkAndApplyImmunitiesTo(PlayerEntity player, LivingEntity target) {
        for (ArmorSet as : ConfigHandler.localConfigArmorSets) {
            if (as.armorSetMatch(player)) {
                for (Bonus b : as.fullSetBonuses) {
                    b.applyImmunity(target);
                }
            }
            if (as.partialBonusRequiredAmount == null || as.armorSetCount(player) < as.partialBonusRequiredAmount) continue;
            for (Bonus b : as.partialSetBonuses) {
                b.applyImmunity(target);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void itemToolTip(ItemTooltipEvent event) {
        ++this.toolTipTickTimer;
        boolean nextStage = false;
        if (this.toolTipTickTimer > 100) {
            this.toolTipTickTimer = 0;
            nextStage = true;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        boolean shouldAddShiftTooltip = false;
        for (ArmorSet as : ConfigHandler.serverArmorSets) {
            if (!as.isPartOfSet(stack.func_77973_b().getRegistryName().toString())) continue;
            if (!as.hideGeneratedTooltip) {
                shouldAddShiftTooltip = true;
                event.getToolTip().add(new StringTextComponent(""));
                event.getToolTip().add(new StringTextComponent("Part of the " + as.armorSetName + " set").func_240699_a_(TextFormatting.AQUA));
                if (Screen.func_231173_s_()) {
                    IFormattableTextComponent description;
                    if (as.head != null && !as.head.itemKey.isEmpty()) {
                        event.getToolTip().add(as.head.toolTipText(player, 3, nextStage));
                    }
                    if (as.chest != null && !as.chest.itemKey.isEmpty()) {
                        event.getToolTip().add(as.chest.toolTipText(player, 2, nextStage));
                    }
                    if (as.legs != null && !as.legs.itemKey.isEmpty()) {
                        event.getToolTip().add(as.legs.toolTipText(player, 1, nextStage));
                    }
                    if (as.boots != null && !as.boots.itemKey.isEmpty()) {
                        event.getToolTip().add(as.boots.toolTipText(player, 0, nextStage));
                    }
                    if (as.mainHand != null && !as.mainHand.itemKey.isEmpty()) {
                        event.getToolTip().add(as.mainHand.toolTipText(player, -1, nextStage));
                    }
                    if (as.offHand != null && !as.offHand.itemKey.isEmpty()) {
                        event.getToolTip().add(as.offHand.toolTipText(player, -2, nextStage));
                    }
                    if (as.curios != null) {
                        for (CuriosSetPiece curiosSetPiece : as.curios) {
                            if (curiosSetPiece.itemKey.isEmpty()) continue;
                            event.getToolTip().add(curiosSetPiece.toolTipText(player, -3, nextStage));
                        }
                    }
                    if (as.partialSetBonuses != null) {
                        event.getToolTip().add(new StringTextComponent(""));
                        event.getToolTip().add(new StringTextComponent("Partial set bonuses (" + as.partialBonusRequiredAmount + "):").func_240699_a_(TextFormatting.GRAY));
                        for (Bonus bonus : as.partialSetBonuses) {
                            description = new StringTextComponent("INVALID DESCRIPTION! Contact mod author (ArmorSetBonuses).").func_240699_a_(TextFormatting.GRAY);
                            if (bonus.description != null) {
                                description = new StringTextComponent("(" + bonus.interactionType.toLowerCase() + ") " + bonus.description).func_240699_a_(TextFormatting.GRAY);
                            } else if (bonus.type.equalsIgnoreCase("effect")) {
                                description = new StringTextComponent("(" + bonus.interactionType.toLowerCase() + ") " + bonus.getBonusEffectInstance().func_188419_a().func_199286_c().getString() + " " + (bonus.getBonusEffectInstance().func_76458_c() + 1)).func_240699_a_(TextFormatting.GRAY);
                            } else if (bonus.type.equalsIgnoreCase("attribute")) {
                                description = new StringTextComponent("(" + bonus.interactionType.toLowerCase() + ") " + bonus.name + " " + bonus.value).func_240699_a_(TextFormatting.GRAY);
                            }
                            event.getToolTip().add(description);
                        }
                    }
                    event.getToolTip().add(new StringTextComponent(""));
                    event.getToolTip().add(new StringTextComponent("Full set bonuses:").func_240699_a_(TextFormatting.GRAY));
                    for (Bonus bonus : as.fullSetBonuses) {
                        if (bonus.hideBonusDescription) continue;
                        description = new StringTextComponent("INVALID DESCRIPTION! Contact mod author (ArmorSetBonuses).").func_240699_a_(TextFormatting.GRAY);
                        if (bonus.description != null) {
                            description = new StringTextComponent("(" + bonus.interactionType.toLowerCase() + ") " + bonus.description).func_240699_a_(TextFormatting.GRAY);
                        } else if (bonus.type.equalsIgnoreCase("effect")) {
                            description = new StringTextComponent("(" + bonus.interactionType.toLowerCase() + ") " + bonus.getBonusEffectInstance().func_188419_a().func_199286_c().getString() + " " + (bonus.getBonusEffectInstance().func_76458_c() + 1)).func_240699_a_(TextFormatting.GRAY);
                        } else if (bonus.type.equalsIgnoreCase("attribute")) {
                            description = new StringTextComponent("(" + bonus.interactionType.toLowerCase() + ") " + bonus.name + " " + bonus.value).func_240699_a_(TextFormatting.GRAY);
                        }
                        event.getToolTip().add(description);
                    }
                    event.getToolTip().add(new StringTextComponent(""));
                }
                if (shouldAddShiftTooltip && !Screen.func_231173_s_()) {
                    event.getToolTip().add(new StringTextComponent("Press SHIFT for more info").func_240699_a_(TextFormatting.GRAY));
                }
            }
            if (as.customTooltips == null || as.customTooltips.length <= 0) continue;
            event.getToolTip().add(new StringTextComponent(""));
            for (String string : as.customTooltips) {
                event.getToolTip().add(new StringTextComponent(string).func_240699_a_(TextFormatting.GRAY));
            }
        }
    }

    @SubscribeEvent
    public void onWorldLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            PacketHandler.sendToClient(new SendArmorSetsPacket(), (ServerPlayerEntity)event.getPlayer());
        } else {
            ConfigHandler.serverArmorSets = ConfigHandler.localConfigArmorSets;
        }
    }
}

