/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class Bonus {
    public String type;
    public String name;
    public float value;
    public String modifierUUID;
    public String description;
    public Integer attributeOperation;
    public String interactionType;
    public Integer interactionDuration;
    public boolean hideBonusDescription = false;

    public Bonus(String type, String name, int value) {
        this();
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public Bonus() {
        if (this.interactionType == null || this.interactionType == "") {
            this.interactionType = "self";
        }
        if (this.interactionDuration == null || this.interactionDuration <= 0) {
            this.interactionDuration = 300;
        }
    }

    public void applyBonus(LivingEntity entity, String targetInteractionType) {
        if (this.interactionType.equalsIgnoreCase(targetInteractionType)) {
            if (this.type.equalsIgnoreCase("effect")) {
                if (entity.func_70644_a(this.getBonusEffectInstance().func_188419_a())) {
                    if (entity.field_70173_aa % 90 == 0) {
                        entity.func_195064_c(this.getBonusEffectInstance());
                    }
                } else {
                    entity.func_195064_c(this.getBonusEffectInstance());
                }
            } else if (this.type.equalsIgnoreCase("attribute")) {
                Attribute a = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.func_208304_a((String)this.name));
                AttributeModifier.Operation amOperation = this.attributeOperation != null ? AttributeModifier.Operation.func_220372_a((int)this.attributeOperation) : AttributeModifier.Operation.ADDITION;
                AttributeModifier am = new AttributeModifier(UUID.fromString(this.modifierUUID), this.name, (double)this.value, amOperation);
                if (!entity.func_110148_a(a).func_180374_a(am)) {
                    entity.func_110148_a(a).func_233767_b_(am);
                }
            }
        }
    }

    public void applyImmunity(LivingEntity entity) {
        if (this.interactionType.equalsIgnoreCase("immunity")) {
            for (EffectInstance e : entity.func_70651_bq()) {
                if (e.func_188419_a().getRegistryName().compareTo(ResourceLocation.func_208304_a((String)this.name)) != 0) continue;
                entity.func_195063_d(e.func_188419_a());
            }
        }
    }

    public void removeBonus(LivingEntity entity, String targetInteractionType) {
        if (this.interactionType.equalsIgnoreCase(targetInteractionType) && this.type.equalsIgnoreCase("attribute")) {
            Attribute a = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.func_208304_a((String)this.name));
            AttributeModifier.Operation amOperation = this.attributeOperation != null ? AttributeModifier.Operation.func_220372_a((int)this.attributeOperation) : AttributeModifier.Operation.ADDITION;
            AttributeModifier am = new AttributeModifier(UUID.fromString(this.modifierUUID), this.name, (double)this.value, amOperation);
            if (entity.func_110148_a(a).func_180374_a(am)) {
                entity.func_110148_a(a).func_188479_b(UUID.fromString(this.modifierUUID));
            }
        }
    }

    public EffectInstance getBonusEffectInstance() {
        if (this.type.equalsIgnoreCase("effect")) {
            return new EffectInstance((Effect)ForgeRegistries.POTIONS.getValue(ResourceLocation.func_208304_a((String)this.name)), this.interactionDuration.intValue(), (int)this.value, false, false, true);
        }
        return null;
    }

    public String isValid() {
        if (this.type.equalsIgnoreCase("effect")) {
            Effect effect = (Effect)ForgeRegistries.POTIONS.getValue(ResourceLocation.func_208304_a((String)this.name));
            if (effect == null) {
                return "Invalid effect: " + this.name;
            }
        } else if (this.type.equalsIgnoreCase("attribute")) {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.func_208304_a((String)this.name));
            if (attribute == null) {
                return "Invalid bonus: " + this.type + " - the attribute is invalid";
            }
            try {
                UUID.fromString(this.modifierUUID);
            }
            catch (IllegalArgumentException e) {
                return "Invalid bonus: " + this.type + " - the modifierUUID is invalid - be sure to use the right formatting and that it is unique";
            }
        } else {
            return "Invalid bonus type: " + this.type;
        }
        if (!(this.interactionType.equalsIgnoreCase("self") || this.interactionType.equalsIgnoreCase("attack") || this.interactionType.equalsIgnoreCase("interact") || this.interactionType.equalsIgnoreCase("immunity") || this.interactionType.equalsIgnoreCase("aoe"))) {
            return "Invalid bonus: " + this.type + " - the interactionType is invalid - it can only be: 'self', 'attack', 'interact', 'immunity', 'aoe'.";
        }
        return null;
    }

    public Bonus setUUID(String uuid) {
        this.modifierUUID = uuid;
        return this;
    }
}

