/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import top.theillusivec4.curios.api.CuriosApi;
import uk.co.dotcode.asb.BaseClass;
import uk.co.dotcode.asb.config.SetPiece;

public class CuriosSetPiece
extends SetPiece {
    public CuriosSetPiece() {
    }

    public CuriosSetPiece(String itemKey) {
        super(itemKey);
    }

    @Override
    public boolean verify(String armorSetName, String slotType) {
        boolean valid = true;
        if (!BaseClass.isCuriosLoaded) {
            LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + armorSetName + ". Curios slots have been declared, but the Curios mod is not installed.");
            valid = false;
        }
        if (!CuriosSetPiece.checkItemKey(this.itemKey)) {
            LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + armorSetName + ". The " + slotType + " slot is invalid!");
            valid = false;
        }
        if (this.mixAndMatch != null && this.mixAndMatch.length > 0) {
            for (String s : this.mixAndMatch) {
                if (CuriosSetPiece.checkItemKey(s)) continue;
                LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + armorSetName + ". " + slotType + " MixAndMatch is invalid: " + s);
                valid = false;
            }
        }
        return valid;
    }

    @Override
    public IFormattableTextComponent toolTipText(PlayerEntity player, int armorSlot, boolean nextStage) {
        String extraText = "";
        ArrayList<Object> targets = new ArrayList<Object>();
        targets.add(this.itemKey);
        if (this.mixAndMatch != null && this.mixAndMatch.length > 0) {
            for (String s : this.mixAndMatch) {
                targets.add(s);
            }
        }
        if (nextStage) {
            String[] stringArray = this.toolTipTickStage;
            Integer n = this.toolTipTickStage = Integer.valueOf(this.toolTipTickStage + 1);
            if (this.toolTipTickStage >= targets.size()) {
                this.toolTipTickStage = 0;
            }
        }
        if (armorSlot == -1) {
            extraText = " (Main Hand)";
            for (String string : targets) {
                if (!player.func_184614_ca().func_77973_b().getRegistryName().toString().equals(string)) continue;
                ItemStack active = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)string)));
                return new StringTextComponent("- " + active.func_151000_E().getString() + " (Main Hand)").func_240699_a_(TextFormatting.GREEN);
            }
        } else if (armorSlot == -2) {
            extraText = " (Off Hand)";
            for (String string : targets) {
                if (!player.func_184592_cb().func_77973_b().getRegistryName().toString().equals(string)) continue;
                ItemStack active = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)string)));
                return new StringTextComponent("- " + active.func_151000_E().getString() + " (Off Hand)").func_240699_a_(TextFormatting.GREEN);
            }
        } else if (armorSlot == -3) {
            extraText = " (Curios)";
            for (String string : targets) {
                Optional optional = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)string)), (LivingEntity)player);
                if (!optional.isPresent()) continue;
                ItemStack active = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)string)));
                return new StringTextComponent("- " + active.func_151000_E().getString() + " (Curios)").func_240699_a_(TextFormatting.GREEN);
            }
        } else {
            for (String string : targets) {
                if (!player.field_71071_by.func_70440_f(armorSlot).func_77973_b().getRegistryName().toString().equalsIgnoreCase(string)) continue;
                ItemStack active = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)string)));
                return new StringTextComponent("- " + active.func_151000_E().getString()).func_240699_a_(TextFormatting.GREEN);
            }
        }
        String currentString = (String)targets.get(this.toolTipTickStage);
        ItemStack itemStack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)currentString)));
        return new StringTextComponent("- " + itemStack.func_151000_E().getString() + extraText).func_240699_a_(TextFormatting.GRAY);
    }

    protected static boolean checkItemKey(String itemKey) {
        String[] splitLocation = itemKey.split(":");
        if (splitLocation.length == 2) {
            ResourceLocation resourceLocation = new ResourceLocation(splitLocation[0], splitLocation[1]);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            return item != null && item != Items.field_190931_a;
        }
        return false;
    }

    public boolean curioMatches(PlayerEntity player) {
        Optional optional = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)this.itemKey)), (LivingEntity)player);
        if (optional.isPresent()) {
            return true;
        }
        if (this.mixAndMatch != null && this.mixAndMatch.length > 0) {
            for (String s : this.mixAndMatch) {
                Optional optionalMix = CuriosApi.getCuriosHelper().findEquippedCurio((Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)s)), (LivingEntity)player);
                if (!optionalMix.isPresent()) continue;
                return true;
            }
        }
        return false;
    }
}

