/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config;

import java.util.ArrayList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class SetPiece {
    public String itemKey;
    public String[] mixAndMatch;
    protected transient Integer toolTipTickStage = 0;

    public SetPiece() {
    }

    public SetPiece(String itemKey) {
        this();
        this.itemKey = itemKey;
    }

    public boolean verify(String armorSetName, String slotType) {
        boolean valid = true;
        if (!SetPiece.checkItemKey(this.itemKey)) {
            LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + armorSetName + ". The " + slotType + " slot is invalid!");
            valid = false;
        }
        if (this.mixAndMatch != null && this.mixAndMatch.length > 0) {
            for (String s : this.mixAndMatch) {
                if (SetPiece.checkItemKey(s)) continue;
                LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + armorSetName + ". " + slotType + " MixAndMatch is invalid: " + s);
                valid = false;
            }
        }
        return valid;
    }

    public IFormattableTextComponent toolTipText(PlayerEntity player, int armorSlot, boolean nextStage) {
        ArrayList<Object> targets = new ArrayList<Object>();
        targets.add(this.itemKey);
        if (this.mixAndMatch != null && this.mixAndMatch.length > 0) {
            for (String s : this.mixAndMatch) {
                targets.add(s);
            }
        }
        if (nextStage) {
            String[] stringArray = this.toolTipTickStage;
            Integer n = this.toolTipTickStage = Integer.valueOf(this.toolTipTickStage + 1);
            if (this.toolTipTickStage >= targets.size()) {
                this.toolTipTickStage = 0;
            }
        }
        if (armorSlot == -1) {
            for (String string : targets) {
                if (!player.func_184614_ca().func_77973_b().getRegistryName().toString().equals(string)) continue;
                ItemStack active = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)string)));
                return new StringTextComponent("- " + active.func_151000_E().getString() + " (Main Hand)").func_240699_a_(TextFormatting.GREEN);
            }
        } else if (armorSlot == -2) {
            for (String string : targets) {
                if (!player.func_184592_cb().func_77973_b().getRegistryName().toString().equals(string)) continue;
                ItemStack active = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)string)));
                return new StringTextComponent("- " + active.func_151000_E().getString() + " (Off Hand)").func_240699_a_(TextFormatting.GREEN);
            }
        } else {
            for (String string : targets) {
                if (!player.field_71071_by.func_70440_f(armorSlot).func_77973_b().getRegistryName().toString().equalsIgnoreCase(string)) continue;
                ItemStack active = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)string)));
                return new StringTextComponent("- " + active.func_151000_E().getString()).func_240699_a_(TextFormatting.GREEN);
            }
        }
        String currentString = (String)targets.get(this.toolTipTickStage);
        ItemStack itemStack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(ResourceLocation.func_208304_a((String)currentString)));
        return new StringTextComponent("- " + itemStack.func_151000_E().getString()).func_240699_a_(TextFormatting.GRAY);
    }

    public boolean matches(String item) {
        if (this.itemKey.equalsIgnoreCase(item)) {
            return true;
        }
        if (this.mixAndMatch != null && this.mixAndMatch.length > 0) {
            for (String s : this.mixAndMatch) {
                if (!s.equalsIgnoreCase(item)) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean checkItemKey(String itemKey) {
        String[] splitLocation = itemKey.split(":");
        if (splitLocation.length == 2) {
            ResourceLocation resourceLocation = new ResourceLocation(splitLocation[0], splitLocation[1]);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            return item != null && item != Items.field_190931_a;
        }
        return false;
    }
}

