/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import uk.co.dotcode.asb.config.ArmorSet;
import uk.co.dotcode.asb.config.Bonus;
import uk.co.dotcode.asb.config.ConfigHandler;
import uk.co.dotcode.asb.config.CuriosSetPiece;
import uk.co.dotcode.asb.packet.PacketHandler;
import uk.co.dotcode.asb.packet.SendArmorSetsPacket;

public class EventHandler {
    private int toolTipTickTimer = 0;

    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent.EntityInteract event) {
        if (event.getSide() == LogicalSide.SERVER && event.getTarget() instanceof LivingEntity) {
            this.checkAndApplyBonusesTo(event.getPlayer(), (LivingEntity)event.getTarget(), "interact");
        }
    }

    @SubscribeEvent
    public void playerAttack(AttackEntityEvent event) {
        if (event.getTarget() instanceof LivingEntity) {
            this.checkAndApplyBonusesTo(event.getPlayer(), (LivingEntity)event.getTarget(), "attack");
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER) {
            this.checkAndApplyBonusesTo(event.player, (LivingEntity)event.player, "self");
            this.checkAndApplyImmunitiesTo(event.player, (LivingEntity)event.player);
        }
    }

    private void checkAndApplyBonusesTo(Player player, LivingEntity target, String interactionType) {
        for (ArmorSet as : ConfigHandler.localConfigArmorSets) {
            if (as.armorSetMatch(player)) {
                for (Bonus b : as.fullSetBonuses) {
                    b.applyBonus(target, interactionType);
                }
            } else {
                for (Bonus b : as.fullSetBonuses) {
                    b.removeBonus(target, interactionType);
                }
            }
            if (as.partialBonusRequiredAmount == null) continue;
            if (as.armorSetCount(player) >= as.partialBonusRequiredAmount) {
                for (Bonus b : as.partialSetBonuses) {
                    b.applyBonus(target, interactionType);
                }
                continue;
            }
            for (Bonus b : as.partialSetBonuses) {
                b.removeBonus(target, interactionType);
            }
        }
    }

    private void checkAndApplyImmunitiesTo(Player player, LivingEntity target) {
        for (ArmorSet as : ConfigHandler.localConfigArmorSets) {
            if (as.armorSetMatch(player)) {
                for (Bonus b : as.fullSetBonuses) {
                    b.applyImmunity(target);
                }
            }
            if (as.partialBonusRequiredAmount == null || as.armorSetCount(player) < as.partialBonusRequiredAmount) continue;
            for (Bonus b : as.partialSetBonuses) {
                b.applyImmunity(target);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void itemToolTip(ItemTooltipEvent event) {
        ++this.toolTipTickTimer;
        boolean nextStage = false;
        if (this.toolTipTickTimer > 100) {
            this.toolTipTickTimer = 0;
            nextStage = true;
        }
        Player player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        boolean shouldAddShiftTooltip = false;
        for (ArmorSet as : ConfigHandler.serverArmorSets) {
            if (!as.isPartOfSet(stack.m_41720_().getRegistryName().toString())) continue;
            if (!as.hideGeneratedTooltip) {
                shouldAddShiftTooltip = true;
                event.getToolTip().add(new TextComponent(""));
                event.getToolTip().add(new TextComponent("Part of the " + as.armorSetName + " set").m_130940_(ChatFormatting.AQUA));
                if (Screen.m_96638_()) {
                    MutableComponent description;
                    if (as.head != null && !as.head.itemKey.isEmpty()) {
                        event.getToolTip().add(as.head.toolTipText(player, 3, nextStage));
                    }
                    if (as.chest != null && !as.chest.itemKey.isEmpty()) {
                        event.getToolTip().add(as.chest.toolTipText(player, 2, nextStage));
                    }
                    if (as.legs != null && !as.legs.itemKey.isEmpty()) {
                        event.getToolTip().add(as.legs.toolTipText(player, 1, nextStage));
                    }
                    if (as.boots != null && !as.boots.itemKey.isEmpty()) {
                        event.getToolTip().add(as.boots.toolTipText(player, 0, nextStage));
                    }
                    if (as.mainHand != null && !as.mainHand.itemKey.isEmpty()) {
                        event.getToolTip().add(as.mainHand.toolTipText(player, -1, nextStage));
                    }
                    if (as.offHand != null && !as.offHand.itemKey.isEmpty()) {
                        event.getToolTip().add(as.offHand.toolTipText(player, -2, nextStage));
                    }
                    if (as.curios != null) {
                        for (CuriosSetPiece curiosSetPiece : as.curios) {
                            if (curiosSetPiece.itemKey.isEmpty()) continue;
                            event.getToolTip().add(curiosSetPiece.toolTipText(player, -3, nextStage));
                        }
                    }
                    if (as.partialSetBonuses != null) {
                        event.getToolTip().add(new TextComponent(""));
                        event.getToolTip().add(new TextComponent("Partial set bonuses (" + as.partialBonusRequiredAmount + "):").m_130940_(ChatFormatting.GRAY));
                        for (Bonus bonus : as.partialSetBonuses) {
                            description = new TextComponent("INVALID DESCRIPTION! Contact mod author (ArmorSetBonuses).").m_130940_(ChatFormatting.GRAY);
                            if (bonus.description != null) {
                                description = new TextComponent("(" + bonus.interactionType.toLowerCase() + ") " + bonus.description).m_130940_(ChatFormatting.GRAY);
                            } else if (bonus.type.equalsIgnoreCase("effect")) {
                                description = new TextComponent("(" + bonus.interactionType.toLowerCase() + ") " + bonus.getBonusEffectInstance().m_19544_().m_19482_().getString() + " " + (bonus.getBonusEffectInstance().m_19564_() + 1)).m_130940_(ChatFormatting.GRAY);
                            } else if (bonus.type.equalsIgnoreCase("attribute")) {
                                description = new TextComponent("(" + bonus.interactionType.toLowerCase() + ") " + bonus.name + " " + bonus.value).m_130940_(ChatFormatting.GRAY);
                            }
                            event.getToolTip().add(description);
                        }
                    }
                    event.getToolTip().add(new TextComponent(""));
                    event.getToolTip().add(new TextComponent("Full set bonuses:").m_130940_(ChatFormatting.GRAY));
                    for (Bonus bonus : as.fullSetBonuses) {
                        if (bonus.hideBonusDescription) continue;
                        description = new TextComponent("INVALID DESCRIPTION! Contact mod author (ArmorSetBonuses).").m_130940_(ChatFormatting.GRAY);
                        if (bonus.description != null) {
                            description = new TextComponent("(" + bonus.interactionType.toLowerCase() + ") " + bonus.description).m_130940_(ChatFormatting.GRAY);
                        } else if (bonus.type.equalsIgnoreCase("effect")) {
                            description = new TextComponent("(" + bonus.interactionType.toLowerCase() + ") " + bonus.getBonusEffectInstance().m_19544_().m_19482_().getString() + " " + (bonus.getBonusEffectInstance().m_19564_() + 1)).m_130940_(ChatFormatting.GRAY);
                        } else if (bonus.type.equalsIgnoreCase("attribute")) {
                            description = new TextComponent("(" + bonus.interactionType.toLowerCase() + ") " + bonus.name + " " + bonus.value).m_130940_(ChatFormatting.GRAY);
                        }
                        event.getToolTip().add(description);
                    }
                    event.getToolTip().add(new TextComponent(""));
                }
                if (shouldAddShiftTooltip && !Screen.m_96638_()) {
                    event.getToolTip().add(new TextComponent("Press SHIFT for more info").m_130940_(ChatFormatting.GRAY));
                }
            }
            if (as.customTooltips == null || as.customTooltips.length <= 0) continue;
            event.getToolTip().add(new TextComponent(""));
            for (String string : as.customTooltips) {
                event.getToolTip().add(new TextComponent(string).m_130940_(ChatFormatting.GRAY));
            }
        }
    }

    @SubscribeEvent
    public void onWorldLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().f_19853_.f_46443_) {
            PacketHandler.sendToClient(new SendArmorSetsPacket(), (ServerPlayer)event.getPlayer());
        } else {
            ConfigHandler.serverArmorSets = ConfigHandler.localConfigArmorSets;
        }
    }
}

