/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config;

import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import uk.co.dotcode.asb.config.Bonus;
import uk.co.dotcode.asb.config.CuriosSetPiece;
import uk.co.dotcode.asb.config.SetPiece;

public class ArmorSet {
    public String armorSetName;
    public SetPiece head;
    public SetPiece chest;
    public SetPiece legs;
    public SetPiece boots;
    public SetPiece mainHand;
    public SetPiece offHand;
    public CuriosSetPiece[] curios;
    public Integer partialBonusRequiredAmount;
    public Bonus[] partialSetBonuses;
    public Bonus[] fullSetBonuses;
    public boolean hideGeneratedTooltip = false;
    public String[] customTooltips;

    public ArmorSet(String setName, String head, String chest, String legs, String boots) {
        this.armorSetName = setName;
        this.head = new SetPiece(head);
        this.chest = new SetPiece(chest);
        this.legs = new SetPiece(legs);
        this.boots = new SetPiece(boots);
    }

    public ArmorSet(String setName, SetPiece head, SetPiece chest, SetPiece legs, SetPiece boots) {
        this.armorSetName = setName;
        this.head = head;
        this.chest = chest;
        this.legs = legs;
        this.boots = boots;
    }

    public boolean armorSetMatch(Player player) {
        ItemStack head = (ItemStack)player.m_150109_().f_35975_.get(3);
        ItemStack chest = (ItemStack)player.m_150109_().f_35975_.get(2);
        ItemStack legs = (ItemStack)player.m_150109_().f_35975_.get(1);
        ItemStack feet = (ItemStack)player.m_150109_().f_35975_.get(0);
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        if (!(this.head != null && !this.head.matches(head.m_41720_().getRegistryName().toString()) || this.chest != null && !this.chest.matches(chest.m_41720_().getRegistryName().toString()) || this.legs != null && !this.legs.matches(legs.m_41720_().getRegistryName().toString()) || this.boots != null && !this.boots.matches(feet.m_41720_().getRegistryName().toString()) || this.mainHand != null && !this.mainHand.matches(mainHand.m_41720_().getRegistryName().toString()) || this.offHand != null && !this.offHand.matches(offHand.m_41720_().getRegistryName().toString()))) {
            if (this.curios != null) {
                boolean allCuriosMatch = true;
                for (CuriosSetPiece c : this.curios) {
                    if (c.curioMatches(player)) continue;
                    allCuriosMatch = false;
                }
                return allCuriosMatch;
            }
            return true;
        }
        return false;
    }

    public int armorSetCount(Player player) {
        ItemStack head = (ItemStack)player.m_150109_().f_35975_.get(3);
        ItemStack chest = (ItemStack)player.m_150109_().f_35975_.get(2);
        ItemStack legs = (ItemStack)player.m_150109_().f_35975_.get(1);
        ItemStack feet = (ItemStack)player.m_150109_().f_35975_.get(0);
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        int armorSetCount = 0;
        if (this.head != null && this.head.matches(head.m_41720_().getRegistryName().toString())) {
            ++armorSetCount;
        }
        if (this.chest != null && this.chest.matches(chest.m_41720_().getRegistryName().toString())) {
            ++armorSetCount;
        }
        if (this.legs != null && this.legs.matches(legs.m_41720_().getRegistryName().toString())) {
            ++armorSetCount;
        }
        if (this.boots != null && this.boots.matches(feet.m_41720_().getRegistryName().toString())) {
            ++armorSetCount;
        }
        if (this.mainHand != null && this.mainHand.matches(mainHand.m_41720_().getRegistryName().toString())) {
            ++armorSetCount;
        }
        if (this.offHand != null && this.offHand.matches(offHand.m_41720_().getRegistryName().toString())) {
            ++armorSetCount;
        }
        if (this.curios != null) {
            for (CuriosSetPiece c : this.curios) {
                if (!c.curioMatches(player)) continue;
                ++armorSetCount;
            }
        }
        return armorSetCount;
    }

    public boolean isPartOfSet(String item) {
        if (this.head != null && this.head.matches(item)) {
            return true;
        }
        if (this.chest != null && this.chest.matches(item)) {
            return true;
        }
        if (this.legs != null && this.legs.matches(item)) {
            return true;
        }
        if (this.boots != null && this.boots.matches(item)) {
            return true;
        }
        if (this.mainHand != null && this.mainHand.matches(item)) {
            return true;
        }
        if (this.offHand != null && this.offHand.matches(item)) {
            return true;
        }
        if (this.curios != null) {
            for (CuriosSetPiece c : this.curios) {
                if (!c.matches(item)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValid() {
        String isBonusValid;
        boolean valid = true;
        if (this.armorSetName == null || this.armorSetName.isEmpty()) {
            LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: It is unnamed!");
            valid = false;
        }
        if (this.head != null && this.head.itemKey.isEmpty()) {
            if (this.chest != null && this.chest.itemKey.isEmpty() && this.legs != null && this.legs.itemKey.isEmpty() && this.boots != null && this.boots.itemKey.isEmpty() && this.mainHand != null && this.mainHand.itemKey.isEmpty() && this.offHand != null && this.offHand.itemKey.isEmpty()) {
                if (this.curios != null) {
                    for (CuriosSetPiece curiosSetPiece : this.curios) {
                        if (!curiosSetPiece.itemKey.isEmpty()) continue;
                        valid = false;
                    }
                }
                valid = false;
            }
        } else {
            if (this.head != null && !this.head.itemKey.isEmpty() && !this.head.verify(this.armorSetName, "head")) {
                valid = false;
            }
            if (this.chest != null && !this.chest.itemKey.isEmpty() && !this.chest.verify(this.armorSetName, "chest")) {
                valid = false;
            }
            if (this.legs != null && !this.legs.itemKey.isEmpty() && !this.legs.verify(this.armorSetName, "legs")) {
                valid = false;
            }
            if (this.boots != null && !this.boots.itemKey.isEmpty() && !this.boots.verify(this.armorSetName, "boots")) {
                valid = false;
            }
            if (this.mainHand != null && !this.mainHand.itemKey.isEmpty() && !this.mainHand.verify(this.armorSetName, "mainHand")) {
                valid = false;
            }
            if (this.offHand != null && !this.offHand.itemKey.isEmpty() && !this.offHand.verify(this.armorSetName, "offHand")) {
                valid = false;
            }
            if (this.curios != null) {
                for (CuriosSetPiece curiosSetPiece : this.curios) {
                    if (curiosSetPiece.itemKey.isEmpty() || curiosSetPiece.verify(this.armorSetName, "curios-" + curiosSetPiece.itemKey)) continue;
                    valid = false;
                }
            }
        }
        if (this.partialSetBonuses != null && this.partialSetBonuses.length > 0) {
            if (this.partialBonusRequiredAmount != null) {
                if (this.partialBonusRequiredAmount < 1 || this.partialBonusRequiredAmount > 5) {
                    LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + this.armorSetName + ". 'partialBonusRequiredAmount' is limited to the values 2-5 (inclusive).");
                    valid = false;
                } else if (this.partialBonusRequiredAmount >= this.getPieceCount()) {
                    LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + this.armorSetName + ". 'partialBonusRequiredAmount' is equal to or higher than the total of " + this.getPieceCount() + " armor pieces. Make sure that it is less than this number.");
                    valid = false;
                }
            } else {
                LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + this.armorSetName + ". 'partialBonusRequiredAmount' must be defined because you have added partial bonuses.");
                valid = false;
            }
            for (Bonus bonus : this.partialSetBonuses) {
                isBonusValid = bonus.isValid();
                if (isBonusValid == null) continue;
                LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + this.armorSetName + ". " + isBonusValid);
                valid = false;
            }
        }
        if (this.fullSetBonuses != null) {
            if (this.fullSetBonuses.length <= 0) {
                LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + this.armorSetName + ". No bonuses defined.");
                valid = false;
            } else {
                for (Bonus bonus : this.fullSetBonuses) {
                    isBonusValid = bonus.isValid();
                    if (isBonusValid == null) continue;
                    LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + this.armorSetName + ". " + isBonusValid);
                    valid = false;
                }
            }
        } else {
            LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + this.armorSetName + ". No bonuses defined.");
            valid = false;
        }
        return valid;
    }

    public int getPieceCount() {
        int count = 0;
        if (this.head != null) {
            ++count;
        }
        if (this.chest != null) {
            ++count;
        }
        if (this.legs != null) {
            ++count;
        }
        if (this.boots != null) {
            ++count;
        }
        if (this.mainHand != null) {
            ++count;
        }
        if (this.offHand != null) {
            ++count;
        }
        if (this.curios != null) {
            count += this.curios.length;
        }
        return count;
    }
}

