/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config;

import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class Bonus {
    public String type;
    public String name;
    public float value;
    public String modifierUUID;
    public String description;
    public Integer attributeOperation;
    public String interactionType;
    public Integer interactionDuration;
    public boolean hideBonusDescription = false;

    public Bonus(String type, String name, int value) {
        this();
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public Bonus() {
        if (this.interactionType == null || this.interactionType == "") {
            this.interactionType = "self";
        }
        if (this.interactionDuration == null || this.interactionDuration <= 0) {
            this.interactionDuration = 300;
        }
    }

    public void applyBonus(LivingEntity entity, String targetInteractionType) {
        if (this.interactionType.equalsIgnoreCase(targetInteractionType)) {
            if (this.type.equalsIgnoreCase("effect")) {
                if (entity.m_21023_(this.getBonusEffectInstance().m_19544_())) {
                    if (entity.f_19797_ % 90 == 0) {
                        entity.m_7292_(this.getBonusEffectInstance());
                    }
                } else {
                    entity.m_7292_(this.getBonusEffectInstance());
                }
            } else if (this.type.equalsIgnoreCase("attribute")) {
                Attribute a = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.m_135820_((String)this.name));
                AttributeModifier.Operation amOperation = this.attributeOperation != null ? AttributeModifier.Operation.m_22236_((int)this.attributeOperation) : AttributeModifier.Operation.ADDITION;
                AttributeModifier am = new AttributeModifier(UUID.fromString(this.modifierUUID), this.name, (double)this.value, amOperation);
                if (!entity.m_21051_(a).m_22109_(am)) {
                    entity.m_21051_(a).m_22118_(am);
                }
            }
        }
    }

    public void applyImmunity(LivingEntity entity) {
        if (this.interactionType.equalsIgnoreCase("immunity")) {
            for (MobEffectInstance e : entity.m_21220_()) {
                if (e.m_19544_().getRegistryName().compareTo(ResourceLocation.m_135820_((String)this.name)) != 0) continue;
                entity.m_21195_(e.m_19544_());
            }
        }
    }

    public void removeBonus(LivingEntity entity, String targetInteractionType) {
        if (this.interactionType.equalsIgnoreCase(targetInteractionType) && this.type.equalsIgnoreCase("attribute")) {
            Attribute a = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.m_135820_((String)this.name));
            AttributeModifier.Operation amOperation = this.attributeOperation != null ? AttributeModifier.Operation.m_22236_((int)this.attributeOperation) : AttributeModifier.Operation.ADDITION;
            AttributeModifier am = new AttributeModifier(UUID.fromString(this.modifierUUID), this.name, (double)this.value, amOperation);
            if (entity.m_21051_(a).m_22109_(am)) {
                entity.m_21051_(a).m_22120_(UUID.fromString(this.modifierUUID));
            }
        }
    }

    public MobEffectInstance getBonusEffectInstance() {
        if (this.type.equalsIgnoreCase("effect")) {
            return new MobEffectInstance((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ResourceLocation.m_135820_((String)this.name)), this.interactionDuration.intValue(), (int)this.value, false, false, true);
        }
        return null;
    }

    public String isValid() {
        if (this.type.equalsIgnoreCase("effect")) {
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ResourceLocation.m_135820_((String)this.name));
            if (effect == null) {
                return "Invalid effect: " + this.name;
            }
        } else if (this.type.equalsIgnoreCase("attribute")) {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.m_135820_((String)this.name));
            if (attribute == null) {
                return "Invalid bonus: " + this.type + " - the attribute is invalid";
            }
            try {
                UUID.fromString(this.modifierUUID);
            }
            catch (IllegalArgumentException e) {
                return "Invalid bonus: " + this.type + " - the modifierUUID is invalid - be sure to use the right formatting and that it is unique";
            }
        } else {
            return "Invalid bonus type: " + this.type;
        }
        if (!(this.interactionType.equalsIgnoreCase("self") || this.interactionType.equalsIgnoreCase("attack") || this.interactionType.equalsIgnoreCase("interact") || this.interactionType.equalsIgnoreCase("immunity") || this.interactionType.equalsIgnoreCase("aoe"))) {
            return "Invalid bonus: " + this.type + " - the interactionType is invalid - it can only be: 'self', 'attack', 'interact', 'immunity', 'aoe'.";
        }
        return null;
    }

    public Bonus setUUID(String uuid) {
        this.modifierUUID = uuid;
        return this;
    }
}

