/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import top.theillusivec4.curios.api.CuriosApi;
import uk.co.dotcode.asb.BaseClass;
import uk.co.dotcode.asb.config.SetPiece;

public class CuriosSetPiece
extends SetPiece {
    public CuriosSetPiece() {
    }

    public CuriosSetPiece(String itemKey) {
        super(itemKey);
    }

    @Override
    public boolean verify(String armorSetName, String slotType) {
        boolean valid = true;
        if (!BaseClass.isCuriosLoaded) {
            LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + armorSetName + ". Curios slots have been declared, but the Curios mod is not installed.");
            valid = false;
        }
        if (!CuriosSetPiece.checkItemKey(this.itemKey)) {
            LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + armorSetName + ". The " + slotType + " slot is invalid!");
            valid = false;
        }
        if (this.mixAndMatch != null && this.mixAndMatch.length > 0) {
            for (String s : this.mixAndMatch) {
                if (CuriosSetPiece.checkItemKey(s)) continue;
                LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + armorSetName + ". " + slotType + " MixAndMatch is invalid: " + s);
                valid = false;
            }
        }
        return valid;
    }

    @Override
    public Component toolTipText(Player player, int armorSlot, boolean nextStage) {
        String extraText = "";
        ArrayList<Object> targets = new ArrayList<Object>();
        targets.add(this.itemKey);
        if (this.mixAndMatch != null && this.mixAndMatch.length > 0) {
            for (String s : this.mixAndMatch) {
                targets.add(s);
            }
        }
        if (nextStage) {
            String[] stringArray = this.toolTipTickStage;
            this.toolTipTickStage = this.toolTipTickStage + 1;
            if (this.toolTipTickStage >= targets.size()) {
                this.toolTipTickStage = 0;
            }
        }
        if (armorSlot == -1) {
            extraText = " (Main Hand)";
            for (String string : targets) {
                if (!player.m_21205_().m_41720_().getRegistryName().toString().equals(string)) continue;
                ItemStack active = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)string)));
                return new TextComponent("- " + active.m_41611_().getString() + " (Main Hand)").m_130940_(ChatFormatting.GREEN);
            }
        } else if (armorSlot == -2) {
            extraText = " (Off Hand)";
            for (String string : targets) {
                if (!player.m_21206_().m_41720_().getRegistryName().toString().equals(string)) continue;
                ItemStack active = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)string)));
                return new TextComponent("- " + active.m_41611_().getString() + " (Off Hand)").m_130940_(ChatFormatting.GREEN);
            }
        } else if (armorSlot == -3) {
            extraText = " (Curios)";
            for (String string : targets) {
                Optional optional = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)string)));
                if (!optional.isPresent()) continue;
                ItemStack active = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)string)));
                return new TextComponent("- " + active.m_41611_().getString() + " (Curios)").m_130940_(ChatFormatting.GREEN);
            }
        } else {
            for (String string : targets) {
                if (!player.m_150109_().m_36052_(armorSlot).m_41720_().getRegistryName().toString().equalsIgnoreCase(string)) continue;
                ItemStack active = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)string)));
                return new TextComponent("- " + active.m_41611_().getString()).m_130940_(ChatFormatting.GREEN);
            }
        }
        String currentString = (String)targets.get(this.toolTipTickStage);
        ItemStack itemStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)currentString)));
        return new TextComponent("- " + itemStack.m_41611_().getString() + extraText).m_130940_(ChatFormatting.GRAY);
    }

    protected static boolean checkItemKey(String itemKey) {
        String[] splitLocation = itemKey.split(":");
        if (splitLocation.length == 2) {
            ResourceLocation resourceLocation = new ResourceLocation(splitLocation[0], splitLocation[1]);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            return item != null && item != Items.f_41852_;
        }
        return false;
    }

    public boolean curioMatches(Player player) {
        Optional optional = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)this.itemKey)));
        if (optional.isPresent()) {
            return true;
        }
        if (this.mixAndMatch != null && this.mixAndMatch.length > 0) {
            for (String s : this.mixAndMatch) {
                Optional optionalMix = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)s)));
                if (!optionalMix.isPresent()) continue;
                return true;
            }
        }
        return false;
    }
}

