/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb;

import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import uk.co.dotcode.asb.config.ArmorSet;
import uk.co.dotcode.asb.config.Bonus;
import uk.co.dotcode.asb.config.ConfigHandler;

public class EventHandler {
    private int toolTipTickTimer = 0;

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        ItemStack head = player.m_150109_().m_36052_(3);
        ItemStack chest = player.m_150109_().m_36052_(2);
        ItemStack legs = player.m_150109_().m_36052_(1);
        ItemStack feet = player.m_150109_().m_36052_(0);
        for (ArmorSet as : ConfigHandler.configArmorSets) {
            int asMatchAmount = as.armorSetMatch(head.m_41720_().getRegistryName().toString(), chest.m_41720_().getRegistryName().toString(), legs.m_41720_().getRegistryName().toString(), feet.m_41720_().getRegistryName().toString());
            if (as.partialBonusRequiredAmount != null) {
                if (asMatchAmount >= as.partialBonusRequiredAmount) {
                    for (Bonus b : as.partialSetBonuses) {
                        b.applyBonus(player);
                    }
                } else {
                    for (Bonus b : as.partialSetBonuses) {
                        b.removeBonus(player);
                    }
                }
            }
            if (asMatchAmount == 4) {
                for (Bonus b : as.fullSetBonuses) {
                    b.applyBonus(player);
                }
                continue;
            }
            for (Bonus b : as.fullSetBonuses) {
                b.removeBonus(player);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void itemToolTip(ItemTooltipEvent event) {
        ++this.toolTipTickTimer;
        boolean nextStage = false;
        if (this.toolTipTickTimer > 60) {
            this.toolTipTickTimer = 0;
            nextStage = true;
        }
        Player player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        boolean shouldAddShiftTooltip = false;
        for (ArmorSet as : ConfigHandler.configArmorSets) {
            MutableComponent description;
            if (!as.isPartOfSet(stack.m_41720_().getRegistryName().toString())) continue;
            shouldAddShiftTooltip = true;
            event.getToolTip().add(new TextComponent(""));
            event.getToolTip().add(new TextComponent("Part of the " + as.armorSetName + " set").m_130940_(ChatFormatting.AQUA));
            if (!Screen.m_96638_()) continue;
            if (as.head != null && !as.head.itemKey.isEmpty()) {
                event.getToolTip().add(as.head.toolTipText(player, 3, nextStage));
            }
            if (as.chest != null && !as.chest.itemKey.isEmpty()) {
                event.getToolTip().add(as.chest.toolTipText(player, 2, nextStage));
            }
            if (as.legs != null && !as.legs.itemKey.isEmpty()) {
                event.getToolTip().add(as.legs.toolTipText(player, 1, nextStage));
            }
            if (as.boots != null && !as.boots.itemKey.isEmpty()) {
                event.getToolTip().add(as.boots.toolTipText(player, 0, nextStage));
            }
            if (as.partialSetBonuses != null) {
                event.getToolTip().add(new TextComponent(""));
                event.getToolTip().add(new TextComponent("Partial set bonuses (" + as.partialBonusRequiredAmount + "):").m_130940_(ChatFormatting.GRAY));
                for (Bonus b : as.partialSetBonuses) {
                    description = new TextComponent("INVALID DESCRIPTION! Contact mod author (ArmorSetBonuses).").m_130940_(ChatFormatting.GRAY);
                    if (b.description != null) {
                        description = new TextComponent(b.description).m_130940_(ChatFormatting.GRAY);
                    } else if (b.type.equalsIgnoreCase("effect")) {
                        description = new TextComponent(b.getBonusEffectInstance().m_19544_().m_19482_().getString() + " " + (b.getBonusEffectInstance().m_19564_() + 1)).m_130940_(ChatFormatting.GRAY);
                    } else if (b.type.equalsIgnoreCase("attribute")) {
                        description = new TextComponent(b.name + " " + b.value).m_130940_(ChatFormatting.GRAY);
                    }
                    event.getToolTip().add(description);
                }
            }
            event.getToolTip().add(new TextComponent(""));
            event.getToolTip().add(new TextComponent("Full set bonuses:").m_130940_(ChatFormatting.GRAY));
            for (Bonus b : as.fullSetBonuses) {
                description = new TextComponent("INVALID DESCRIPTION! Contact mod author (ArmorSetBonuses).").m_130940_(ChatFormatting.GRAY);
                if (b.description != null) {
                    description = new TextComponent(b.description).m_130940_(ChatFormatting.GRAY);
                } else if (b.type.equalsIgnoreCase("effect")) {
                    description = new TextComponent(b.getBonusEffectInstance().m_19544_().m_19482_().getString() + " " + (b.getBonusEffectInstance().m_19564_() + 1)).m_130940_(ChatFormatting.GRAY);
                } else if (b.type.equalsIgnoreCase("attribute")) {
                    description = new TextComponent(b.name + " " + b.value).m_130940_(ChatFormatting.GRAY);
                }
                event.getToolTip().add(description);
            }
            event.getToolTip().add(new TextComponent(""));
        }
        if (shouldAddShiftTooltip && !Screen.m_96638_()) {
            event.getToolTip().add(new TextComponent("Press SHIFT for more info").m_130940_(ChatFormatting.GRAY));
        }
    }
}

