/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import uk.co.dotcode.asb.config.Bonus;
import uk.co.dotcode.asb.config.SetPiece;

public class ArmorSet {
    public String armorSetName;
    public SetPiece head;
    public SetPiece chest;
    public SetPiece legs;
    public SetPiece boots;
    public Integer partialBonusRequiredAmount;
    public Bonus[] partialSetBonuses;
    public Bonus[] fullSetBonuses;

    public ArmorSet(String setName, String head, String chest, String legs, String boots) {
        this.armorSetName = setName;
        this.head = new SetPiece(head);
        this.chest = new SetPiece(chest);
        this.legs = new SetPiece(legs);
        this.boots = new SetPiece(boots);
    }

    public ArmorSet(String setName, SetPiece head, SetPiece chest, SetPiece legs, SetPiece boots) {
        this.armorSetName = setName;
        this.head = head;
        this.chest = chest;
        this.legs = legs;
        this.boots = boots;
    }

    public int armorSetMatch(String head, String chest, String legs, String boots) {
        int matchCount = 0;
        if (this.head.matches(head)) {
            ++matchCount;
        }
        if (this.chest.matches(chest)) {
            ++matchCount;
        }
        if (this.legs.matches(legs)) {
            ++matchCount;
        }
        if (this.boots.matches(boots)) {
            ++matchCount;
        }
        return matchCount;
    }

    public boolean isPartOfSet(String item) {
        return this.head.matches(item) || this.chest.matches(item) || this.legs.matches(item) || this.boots.matches(item);
    }

    public boolean isValid() {
        String isBonusValid;
        boolean valid = true;
        if (this.armorSetName == null || this.armorSetName.isEmpty()) {
            LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: It is unnamed!");
            valid = false;
        }
        if (this.head == null && this.chest == null && this.legs == null && this.boots == null) {
            LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + this.armorSetName + ". No armor has been declared!");
            valid = false;
        } else if (this.head.itemKey.isEmpty() && this.chest.itemKey.isEmpty() && this.legs.itemKey.isEmpty() && this.boots.itemKey.isEmpty()) {
            LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + this.armorSetName + ". No armor has been declared! Make sure you have declared the 'itemKey'.");
            valid = false;
        } else {
            if (!this.head.itemKey.isEmpty() && !this.head.verify(this.armorSetName, "head")) {
                valid = false;
            }
            if (!this.chest.itemKey.isEmpty() && !this.chest.verify(this.armorSetName, "chest")) {
                valid = false;
            }
            if (!this.legs.itemKey.isEmpty() && !this.legs.verify(this.armorSetName, "legs")) {
                valid = false;
            }
            if (!this.boots.itemKey.isEmpty() && !this.boots.verify(this.armorSetName, "boots")) {
                valid = false;
            }
        }
        if (this.partialSetBonuses != null && this.partialSetBonuses.length > 0) {
            if (this.partialBonusRequiredAmount != null) {
                if (this.partialBonusRequiredAmount < 2 || this.partialBonusRequiredAmount > 3) {
                    LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + this.armorSetName + ". 'partialBonusRequiredAmount' can only equal 2 or 3.");
                    valid = false;
                }
            } else {
                LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + this.armorSetName + ". 'partialBonusRequiredAmount' must be defined because you have added partial bonuses.");
                valid = false;
            }
            for (Bonus b : this.partialSetBonuses) {
                isBonusValid = b.isValid();
                if (isBonusValid == null) continue;
                LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + this.armorSetName + ". " + isBonusValid);
                valid = false;
            }
        }
        if (this.fullSetBonuses != null) {
            if (this.fullSetBonuses.length <= 0) {
                LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + this.armorSetName + ". No bonuses defined.");
                valid = false;
            } else {
                for (Bonus b : this.fullSetBonuses) {
                    isBonusValid = b.isValid();
                    if (isBonusValid == null) continue;
                    LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + this.armorSetName + ". " + isBonusValid);
                    valid = false;
                }
            }
        } else {
            LogManager.getLogger((String)"spacecatasb").log(Level.WARN, "Failed to add custom armorset: " + this.armorSetName + ". No bonuses defined.");
            valid = false;
        }
        return valid;
    }
}

