/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config;

import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class Bonus {
    public String type;
    public String name;
    public float value;
    public String modifierUUID;
    public String description;

    public Bonus(String type, String name, int value) {
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public void applyBonus(Player player) {
        if (this.type.equalsIgnoreCase("effect")) {
            player.m_7292_(this.getBonusEffectInstance());
        } else if (this.type.equalsIgnoreCase("attribute")) {
            Attribute a = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.m_135820_((String)this.name));
            AttributeModifier am = new AttributeModifier(UUID.fromString(this.modifierUUID), this.name, (double)this.value, AttributeModifier.Operation.ADDITION);
            if (!player.m_21051_(a).m_22109_(am)) {
                player.m_21051_(a).m_22118_(am);
            }
        }
    }

    public void removeBonus(Player player) {
        if (this.type.equalsIgnoreCase("attribute")) {
            Attribute a = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.m_135820_((String)this.name));
            AttributeModifier am = new AttributeModifier(UUID.fromString(this.modifierUUID), this.name, (double)this.value, AttributeModifier.Operation.ADDITION);
            if (player.m_21051_(a).m_22109_(am)) {
                player.m_21051_(a).m_22120_(UUID.fromString(this.modifierUUID));
            }
        }
    }

    public MobEffectInstance getBonusEffectInstance() {
        if (this.type.equalsIgnoreCase("effect")) {
            return new MobEffectInstance((MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ResourceLocation.m_135820_((String)this.name)), 30, (int)this.value, false, false, true);
        }
        return null;
    }

    public String isValid() {
        if (this.type.equalsIgnoreCase("effect")) {
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(ResourceLocation.m_135820_((String)this.name));
            if (effect == null) {
                return "Invalid effect: " + this.name;
            }
        } else if (this.type.equalsIgnoreCase("attribute")) {
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(ResourceLocation.m_135820_((String)this.name));
            if (attribute == null) {
                return "Invalid bonus: " + this.type + " - the attribute is invalid";
            }
            try {
                UUID.fromString(this.modifierUUID);
            }
            catch (IllegalArgumentException e) {
                return "Invalid bonus: " + this.type + " - the modifierUUID is invalid - be sure to use the right formatting and that it is unique";
            }
        } else {
            return "Invalid bonus type: " + this.type;
        }
        return null;
    }

    public Bonus setUUID(String uuid) {
        this.modifierUUID = uuid;
        return this;
    }
}

