/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.asb.config;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import uk.co.dotcode.asb.config.ArmorSet;
import uk.co.dotcode.asb.config.DefaultArmorSets;

public class ConfigHandler {
    private static File folder = FMLPaths.CONFIGDIR.get().resolve("armorsets").toFile();
    public static ArrayList<ArmorSet> configArmorSets = new ArrayList();

    public static void load() {
        File[] fileArray;
        if (!folder.exists()) {
            LogManager.getLogger((String)"spacecatasb").log(Level.INFO, "No configs found, creating defaults");
            folder.mkdirs();
            DefaultArmorSets.generateDefaultConfigs(folder);
        }
        if ((fileArray = folder.listFiles()) != null && fileArray.length > 0) {
            Gson gson = new Gson();
            LogManager.getLogger((String)"spacecatasb").log(Level.INFO, "Loading armor sets and bonuses");
            for (File f : fileArray) {
                if (f.isDirectory() || !ConfigHandler.isJsonFile(f)) continue;
                ConfigHandler.loadFile(gson, f);
            }
        }
    }

    private static void loadFile(Gson gson, File file) {
        try (FileReader reader = new FileReader(file);){
            ArmorSet as = (ArmorSet)gson.fromJson((Reader)reader, ArmorSet.class);
            LogManager.getLogger((String)"spacecatasb").log(Level.INFO, "Loading armor set: " + as.armorSetName);
            if (as.isValid()) {
                configArmorSets.add(as);
            }
        }
        catch (FileNotFoundException e) {
            LogManager.getLogger((String)"spacecatasb").log(Level.ERROR, "Failed to load armor set (file not found): " + file.getPath());
            e.printStackTrace();
        }
        catch (IOException e) {
            LogManager.getLogger((String)"spacecatasb").log(Level.ERROR, "Failed to load armor set (IOException): " + file.getPath());
            e.printStackTrace();
        }
    }

    private static boolean isJsonFile(File f) {
        String extension = f.getPath().substring(f.getPath().lastIndexOf("."));
        return extension.equalsIgnoreCase(".json");
    }
}

