/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.client.render.entity.piece;

import com.google.common.collect.Maps;
import immersive_armors.item.ExtendedArmorItem;
import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_918;

public abstract class Piece {
    private static final Map<String, class_2960> ARMOR_TEXTURE_CACHE = Maps.newHashMap();
    private boolean translucent;
    private boolean glint;
    private boolean colored;
    private boolean glowing;
    private String texture;

    protected void setVisible(class_572 bipedModel, class_1304 slot) {
        bipedModel.method_2805(false);
        switch (slot) {
            case field_6169: {
                bipedModel.field_3398.field_3665 = true;
                bipedModel.field_3394.field_3665 = true;
                break;
            }
            case field_6174: {
                bipedModel.field_3391.field_3665 = true;
                bipedModel.field_3401.field_3665 = true;
                bipedModel.field_27433.field_3665 = true;
                break;
            }
            case field_6172: {
                bipedModel.field_3391.field_3665 = true;
                bipedModel.field_3392.field_3665 = true;
                bipedModel.field_3397.field_3665 = true;
                break;
            }
            case field_6166: {
                bipedModel.field_3392.field_3665 = true;
                bipedModel.field_3397.field_3665 = true;
            }
        }
    }

    private class_2960 getTexture(ExtendedArmorItem item, boolean overlay) {
        String string = "immersive_armors:textures/models/armor/" + item.getMaterial().method_7694() + "/" + this.getTexture() + (overlay ? "_overlay" : "") + ".png";
        return ARMOR_TEXTURE_CACHE.computeIfAbsent(string, class_2960::new);
    }

    protected void renderParts(class_4587 matrices, class_4597 vertexConsumers, int light, class_1799 itemStack, ExtendedArmorItem item, class_583 model, float red, float green, float blue, boolean overlay) {
        class_1921 renderLayer = this.isTranslucent() ? class_1921.method_23580((class_2960)this.getTexture(item, overlay)) : (this.isGlowing() ? class_1921.method_23592((class_2960)this.getTexture(item, overlay), (boolean)false) : class_1921.method_25448((class_2960)this.getTexture(item, overlay)));
        class_4588 vertexConsumer = class_918.method_27952((class_4597)vertexConsumers, (class_1921)renderLayer, (boolean)false, (boolean)(this.hasGlint() | itemStack.method_7958()));
        model.method_2828(matrices, vertexConsumer, light, class_4608.field_21444, red, green, blue, 1.0f);
    }

    public abstract void render(class_4587 var1, class_4597 var2, int var3, class_1309 var4, class_1799 var5, float var6, class_1304 var7, class_572<class_1309> var8);

    public Piece translucent() {
        this.translucent = true;
        return this;
    }

    public Piece glint() {
        this.glint = true;
        return this;
    }

    public Piece colored() {
        this.colored = true;
        return this;
    }

    public Piece glowing() {
        this.glowing = true;
        return this;
    }

    public Piece texture(String texture) {
        this.texture = texture;
        return this;
    }

    public boolean isTranslucent() {
        return this.translucent;
    }

    public boolean hasGlint() {
        return this.glint;
    }

    public boolean isColored() {
        return this.colored;
    }

    public boolean isGlowing() {
        return this.glowing;
    }

    public String getTexture() {
        return this.texture;
    }
}

