/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.armorEffects;

import immersive_armors.armorEffects.ArmorEffect;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class WeaponEfficiency
extends ArmorEffect {
    private final float damage;
    private final Class weapon;

    public WeaponEfficiency(float damage, Class items) {
        this.damage = damage;
        this.weapon = items;
    }

    @Override
    public void appendTooltip(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.appendTooltip(stack, world, tooltip, context);
        TranslatableComponent weaponText = new TranslatableComponent("armorEffect.weaponEfficiency." + this.weapon.getSimpleName());
        tooltip.add((Component)new TranslatableComponent("armorEffect.weaponEfficiency", new Object[]{(int)(this.damage * 100.0f), weaponText}).m_130940_(ChatFormatting.GOLD));
    }

    @Override
    public float applyArmorToAttack(LivingEntity target, DamageSource source, float amount, ItemStack armor) {
        boolean hasAxe;
        LivingEntity attacker;
        Entity entity;
        if (!source.m_19360_() && (entity = source.m_7639_()) instanceof LivingEntity && this.isPrimaryArmor(armor, attacker = (LivingEntity)entity) && (hasAxe = Stream.of(attacker.m_6844_(EquipmentSlot.MAINHAND), attacker.m_6844_(EquipmentSlot.OFFHAND)).filter(Objects::nonNull).anyMatch(v -> this.weapon.isInstance(v.m_41720_())))) {
            amount *= 1.0f + (float)this.getSetCount(armor, attacker) * this.damage;
        }
        return amount;
    }
}

