/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import immersive_armors.item.ExtendedArmorItem;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidArmorLayer.class})
public abstract class MixinArmorFeatureRenderer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    public MixinArmorFeatureRenderer(RenderLayerParent<T, M> context) {
        super(context);
    }

    @Inject(method={"renderArmor"}, at={@At(value="HEAD")}, cancellable=true)
    void renderArmor(PoseStack matrices, MultiBufferSource vertexConsumers, T entity, EquipmentSlot armorSlot, int light, A model, CallbackInfo ci) {
        ItemStack itemStack = entity.m_6844_(armorSlot);
        if (itemStack.m_41720_() instanceof ExtendedArmorItem) {
            ci.cancel();
        }
    }

    private void renderPieces(PoseStack matrices, MultiBufferSource vertexConsumers, T entity, EquipmentSlot armorSlot, int light, float tickDelta) {
        ExtendedArmorItem armorItem;
        ItemStack itemStack = entity.m_6844_(armorSlot);
        Item item = itemStack.m_41720_();
        if (item instanceof ExtendedArmorItem && (armorItem = (ExtendedArmorItem)item).m_40402_() == armorSlot) {
            armorItem.getMaterial().getPieces(armorSlot).forEach(piece -> piece.render(matrices, vertexConsumers, light, (LivingEntity)entity, itemStack, tickDelta, armorSlot, (HumanoidModel<LivingEntity>)((HumanoidModel)this.m_117386_())));
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/LivingEntity;FFFFFF)V"}, at={@At(value="HEAD")})
    public void render(PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, T entity, float f, float g, float tickDelta, float j, float k, float l, CallbackInfo ci) {
        this.renderPieces(matrixStack, vertexConsumerProvider, entity, EquipmentSlot.HEAD, i, tickDelta);
        this.renderPieces(matrixStack, vertexConsumerProvider, entity, EquipmentSlot.CHEST, i, tickDelta);
        this.renderPieces(matrixStack, vertexConsumerProvider, entity, EquipmentSlot.LEGS, i, tickDelta);
        this.renderPieces(matrixStack, vertexConsumerProvider, entity, EquipmentSlot.FEET, i, tickDelta);
    }
}

