/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.forge.cobalt.registration;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import immersive_armors.cobalt.registration.Registration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class RegistrationImpl
extends Registration.Impl {
    public static final RegistrationImpl IMPL = new RegistrationImpl();
    public static final Map<EntityType<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>> ENTITY_ATTRIBUTES = new HashMap<EntityType<? extends LivingEntity>, Supplier<AttributeSupplier.Builder>>();
    private final Map<String, RegistryRepo> repos = new HashMap<String, RegistryRepo>();

    public static void bootstrap() {
    }

    private RegistryRepo getRepo(String namespace) {
        return this.repos.computeIfAbsent(namespace, RegistryRepo::new);
    }

    @Override
    public <T> T register(Registry<? super T> registry, ResourceLocation id, T obj) {
        DeferredRegister reg = this.getRepo(id.m_135827_()).get(registry);
        if (reg != null) {
            reg.register(id.m_135815_(), () -> obj);
        } else {
            if (obj instanceof IForgeRegistryEntry) {
                ((IForgeRegistryEntry)obj).setRegistryName(id);
            }
            Registry.m_122965_(registry, (ResourceLocation)id, obj);
        }
        return obj;
    }

    @Override
    public Supplier<SimpleParticleType> simpleParticle() {
        return () -> new SimpleParticleType(false);
    }

    @Override
    public CreativeModeTab itemGroup(ResourceLocation id, final Supplier<ItemStack> icon) {
        return new CreativeModeTab(CreativeModeTab.getGroupCountSafe(), String.format("%s.%s", id.m_135827_(), id.m_135815_())){

            public ItemStack m_6976_() {
                return (ItemStack)icon.get();
            }
        };
    }

    @Override
    public Function<ResourceLocation, Activity> activity() {
        return id -> this.register((Registry)Registry.f_122874_, (ResourceLocation)id, (Object)new Activity(id.toString()));
    }

    @Override
    public <T extends Sensor<?>> BiFunction<ResourceLocation, Supplier<T>, SensorType<T>> sensor() {
        return (id, factory) -> this.register((Registry)Registry.f_122872_, (ResourceLocation)id, (Object)new SensorType(factory));
    }

    @Override
    public <U> BiFunction<ResourceLocation, Optional<Codec<U>>, MemoryModuleType<U>> memoryModule() {
        return (id, codec) -> this.register((Registry)Registry.f_122871_, (ResourceLocation)id, (Object)new MemoryModuleType(codec));
    }

    @Override
    public <T extends LivingEntity> BiFunction<EntityType<T>, Supplier<AttributeSupplier.Builder>, EntityType<T>> defaultEntityAttributes() {
        return (type, attributes) -> {
            ENTITY_ATTRIBUTES.put((EntityType<? extends LivingEntity>)type, (Supplier<AttributeSupplier.Builder>)attributes);
            return type;
        };
    }

    @Override
    public Registration.ProfessionFactory<VillagerProfession> profession() {
        return (id, poi, sound, items, sites) -> this.register((Registry)Registry.f_122869_, id, (Object)new VillagerProfession(id.toString().replace(':', '.'), poi, ImmutableSet.copyOf((Iterable)items), ImmutableSet.copyOf((Iterable)sites), sound));
    }

    static class RegistryRepo {
        private final Set<ResourceLocation> skipped = new HashSet<ResourceLocation>();
        private final Map<ResourceLocation, DeferredRegister<?>> registries = new HashMap();
        private final String namespace;

        public RegistryRepo(String namespace) {
            this.namespace = namespace;
        }

        public <T> DeferredRegister get(Registry<? super T> registry) {
            ResourceLocation id = registry.m_123023_().m_135782_();
            if (!this.registries.containsKey(id) && !this.skipped.contains(id)) {
                ForgeRegistry reg = RegistryManager.ACTIVE.getRegistry(id);
                if (reg == null) {
                    this.skipped.add(id);
                    return null;
                }
                DeferredRegister def = DeferredRegister.create((IForgeRegistry)((IForgeRegistry)Objects.requireNonNull(reg, "Registry=" + id)), (String)this.namespace);
                def.register(FMLJavaModLoadingContext.get().getModEventBus());
                this.registries.put(id, def);
            }
            return this.registries.get(id);
        }

        void apply(IEventBus bus) {
            this.registries.values().forEach(arg_0 -> ((IEventBus)bus).register(arg_0));
        }
    }
}

