/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors;

import immersive_armors.Config;
import immersive_armors.ItemGroups;
import immersive_armors.armorEffects.ArrowBlockArmorEffect;
import immersive_armors.armorEffects.BerserkArmorEffect;
import immersive_armors.armorEffects.BouncingArmorEffect;
import immersive_armors.armorEffects.DivineArmorEffect;
import immersive_armors.armorEffects.ExplosionProtectionArmorEffect;
import immersive_armors.armorEffects.FireInflictingArmorEffect;
import immersive_armors.armorEffects.FireResistanceArmorEffect;
import immersive_armors.armorEffects.MagicProtectionArmorEffect;
import immersive_armors.armorEffects.SpikesArmorEffect;
import immersive_armors.armorEffects.SteamTechArmorEffect;
import immersive_armors.armorEffects.WeaponEfficiency;
import immersive_armors.armorEffects.WitherArmorEffect;
import immersive_armors.cobalt.registration.Registration;
import immersive_armors.item.DyeableExtendedArmorItem;
import immersive_armors.item.ExtendedArmorItem;
import immersive_armors.item.ExtendedArmorMaterial;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;

public interface Items {
    public static final List<Item> coloredItems = new LinkedList<Item>();
    public static final List<Item> items = new LinkedList<Item>();
    public static final ExtendedArmorMaterial BONE_ARMOR = Items.registerSet(new ExtendedArmorMaterial("bone").durabilityMultiplier(8).repairIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_42500_})).protectionAmount(1, 3, 2, 1).enchantability(15).equipSound(SoundEvents.f_12423_).weight(-0.02f));
    public static final ExtendedArmorMaterial WITHER_ARMOR = Items.registerSet(new ExtendedArmorMaterial("wither").durabilityMultiplier(12).repairIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_42500_})).protectionAmount(2, 6, 5, 2).enchantability(0).effect(new WitherArmorEffect(1.0f, 10)).hideCape().equipSound(SoundEvents.f_12559_).weight(-0.01f));
    public static final ExtendedArmorMaterial WARRIOR_ARMOR = Items.registerSet(new ExtendedArmorMaterial("warrior").protectionAmount(2, 5, 6, 2).durabilityMultiplier(15).repairIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_42416_})).toughness(1.0f).enchantability(5).hideCape().effect(new BerserkArmorEffect(0.2f)).effect(new WeaponEfficiency(0.05f, AxeItem.class, "axe")).equipSound(SoundEvents.f_11677_));
    public static final ExtendedArmorMaterial HEAVY_ARMOR = Items.registerSet(new ExtendedArmorMaterial("heavy").protectionAmount(4, 6, 5, 3).durabilityMultiplier(20).repairIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_42416_})).toughness(4.0f).knockbackReduction(0.5f).weight(0.05f).enchantability(6).equipSound(SoundEvents.f_11677_));
    public static final ExtendedArmorMaterial ROBE_ARMOR = Items.registerDyeableSet(new ExtendedArmorMaterial("robe").protectionAmount(2, 3, 2, 1).enchantability(50).durabilityMultiplier(14).repairIngredient(() -> Ingredient.m_204132_((TagKey)ItemTags.f_13167_)).color(11546150).effect(new FireResistanceArmorEffect(0.25f)).effect(new FireInflictingArmorEffect(10)).effect(new MagicProtectionArmorEffect(0.2f)).equipSound(SoundEvents.f_12642_));
    public static final ExtendedArmorMaterial SLIME_ARMOR = Items.registerSet(new ExtendedArmorMaterial("slime").protectionAmount(3, 5, 4, 2).enchantability(10).durabilityMultiplier(20).repairIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_42518_})).knockbackReduction(0.25f).effect(new BouncingArmorEffect(0.25f)).effect(new ExplosionProtectionArmorEffect(0.2f)).equipSound(SoundEvents.f_12388_));
    public static final ExtendedArmorMaterial DIVINE_ARMOR = Items.registerDyeableSet(new ExtendedArmorMaterial("divine").protectionAmount(3, 7, 5, 3).durabilityMultiplier(18).repairIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_42417_})).enchantability(30).effect(new DivineArmorEffect(1200L)).color(11546150).hideCape().equipSound(SoundEvents.f_11677_));
    public static final ExtendedArmorMaterial PRISMARINE_ARMOR = Items.registerSet(new ExtendedArmorMaterial("prismarine").protectionAmount(3, 8, 6, 3).enchantability(8).durabilityMultiplier(18).repairIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_42696_})).weight(0.02f).effect(new SpikesArmorEffect(1)).enchantment(Enchantments.f_44973_, 1).equipSound(SoundEvents.f_11677_));
    public static final ExtendedArmorMaterial WOODEN_ARMOR = Items.registerSet(new ExtendedArmorMaterial("wooden").protectionAmount(1, 3, 2, 1).durabilityMultiplier(8).repairIngredient(() -> Ingredient.m_204132_((TagKey)ItemTags.f_13182_)).enchantability(4).effect(new ArrowBlockArmorEffect(0.15f)).effect(new ExplosionProtectionArmorEffect(0.1f)).equipSound(SoundEvents.f_11678_));
    public static final ExtendedArmorMaterial STEAMPUNK_ARMOR = Items.registerSet(new ExtendedArmorMaterial("steampunk").protectionAmount(3, 6, 4, 2).durabilityMultiplier(11).repairIngredient(() -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{net.minecraft.world.item.Items.f_42417_})).enchantability(4).hideCape().effect(new ExplosionProtectionArmorEffect(0.2f)).effect(new SteamTechArmorEffect()).equipSound(SoundEvents.f_12374_));

    public static void bootstrap() {
    }

    public static ExtendedArmorMaterial registerSet(ExtendedArmorMaterial material) {
        if (Config.getInstance().enabledArmors.get(material.m_6082_()).booleanValue()) {
            Item[] items = new Item[]{Items.register(material.m_6082_() + "_helmet", (Item)new ExtendedArmorItem(Items.baseProps(), EquipmentSlot.HEAD, material)), Items.register(material.m_6082_() + "_chestplate", (Item)new ExtendedArmorItem(Items.baseProps(), EquipmentSlot.CHEST, material)), Items.register(material.m_6082_() + "_leggings", (Item)new ExtendedArmorItem(Items.baseProps(), EquipmentSlot.LEGS, material)), Items.register(material.m_6082_() + "_boots", (Item)new ExtendedArmorItem(Items.baseProps(), EquipmentSlot.FEET, material))};
            Items.items.addAll(Arrays.asList(items));
        }
        return material;
    }

    public static ExtendedArmorMaterial registerDyeableSet(ExtendedArmorMaterial material) {
        if (Config.getInstance().enabledArmors.get(material.m_6082_()).booleanValue()) {
            Item[] items = new Item[]{Items.register(material.m_6082_() + "_helmet", (Item)new DyeableExtendedArmorItem(Items.baseProps(), EquipmentSlot.HEAD, material)), Items.register(material.m_6082_() + "_chestplate", (Item)new DyeableExtendedArmorItem(Items.baseProps(), EquipmentSlot.CHEST, material)), Items.register(material.m_6082_() + "_leggings", (Item)new DyeableExtendedArmorItem(Items.baseProps(), EquipmentSlot.LEGS, material)), Items.register(material.m_6082_() + "_boots", (Item)new DyeableExtendedArmorItem(Items.baseProps(), EquipmentSlot.FEET, material))};
            Items.items.addAll(Arrays.asList(items));
            coloredItems.addAll(Arrays.asList(items));
        }
        return material;
    }

    public static Item register(String name, Item item) {
        return Registration.register(Registry.f_122827_, new ResourceLocation("immersive_armors", name), item);
    }

    public static Item.Properties baseProps() {
        return new Item.Properties().m_41491_(ItemGroups.ARMOR);
    }
}

