/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.armorEffects;

import immersive_armors.armorEffects.ArmorEffect;
import immersive_armors.util.FlowingText;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SteamTechArmorEffect
extends ArmorEffect {
    @Override
    public void appendTooltip(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        super.appendTooltip(stack, world, tooltip, context);
        MutableComponent text = new TranslatableComponent("armorEffect.steamTech." + this.getEquipmentSlot(stack).name().toLowerCase(Locale.ROOT)).m_130940_(ChatFormatting.GRAY);
        tooltip.addAll(FlowingText.wrap((Component)text, 140));
    }

    @Override
    public void equippedTick(ItemStack armor, Level world, LivingEntity entity, int slot) {
        super.equippedTick(armor, world, entity, slot);
        if (this.getEquipmentSlot(armor) == EquipmentSlot.FEET) {
            Vec3 velocity;
            if (entity.m_21187_().nextInt(10) == 0) {
                double x = Math.cos((double)(entity.f_20883_ / 180.0f) * Math.PI - 1.5707963267948966) * 0.25;
                double z = Math.sin((double)(entity.f_20883_ / 180.0f) * Math.PI - 1.5707963267948966) * 0.25;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, entity.m_20185_() + x, entity.m_20186_() + (double)1.2f, entity.m_20189_() + z, x * (double)0.2f, (double)-0.025f, z * (double)0.2f);
            }
            if ((velocity = entity.m_20184_()).m_7098_() < -0.75) {
                entity.m_20334_(velocity.f_82479_, -0.75, velocity.f_82481_);
                entity.f_19789_ = 0.0f;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123777_, entity.m_20208_(0.5), entity.m_20186_(), entity.m_20262_(0.5), 0.0, -0.5, 0.0);
                if (entity.f_19797_ % 4 == 0) {
                    entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12374_, entity.m_5720_(), 0.1f, 1.0f);
                }
            }
        }
        if (!world.m_5776_() && entity.m_6144_() && this.getEquipmentSlot(armor) == EquipmentSlot.HEAD && entity.f_19797_ % 20 == 0) {
            boolean[] sound = new boolean[]{false};
            world.m_45933_((Entity)entity, new AABB(entity.m_20182_(), entity.m_20182_()).m_82400_(16.0)).forEach(e -> {
                if (e instanceof Monster) {
                    LivingEntity le = (LivingEntity)e;
                    le.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 5));
                    if (!sound[0]) {
                        sound[0] = true;
                        entity.f_19853_.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12444_, entity.m_5720_(), 0.25f, 3.0f);
                    }
                }
            });
        }
    }

    @Override
    public float applyArmorToAttack(LivingEntity target, DamageSource source, float amount, ItemStack armor) {
        LivingEntity attacker;
        ItemStack hand;
        Entity entity;
        if (this.getEquipmentSlot(armor) == EquipmentSlot.CHEST && (entity = source.m_7639_()) instanceof LivingEntity && (hand = (attacker = (LivingEntity)entity).m_21120_(attacker.m_7655_())).m_41619_()) {
            amount *= 4.0f;
        }
        if (!source.m_19360_() && this.getEquipmentSlot(armor) == EquipmentSlot.LEGS) {
            amount *= 1.1f;
        }
        return amount;
    }

    private EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return ((ArmorItem)stack.m_41720_()).m_40402_();
    }
}

