/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.client.render.entity.piece;

import com.mojang.blaze3d.vertex.PoseStack;
import immersive_armors.client.render.entity.piece.Piece;
import immersive_armors.item.ExtendedArmorItem;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class LayerPiece
extends Piece {
    protected abstract HumanoidModel<LivingEntity> getModel();

    protected static HumanoidModel<LivingEntity> buildDilatedModel(float dilation) {
        return new HumanoidModel(LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(dilation), (float)0.0f), (int)64, (int)32).m_171564_());
    }

    @Override
    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, LivingEntity entity, ItemStack itemStack, float tickDelta, EquipmentSlot armorSlot, HumanoidModel<LivingEntity> contextModel) {
        Item item = itemStack.m_41720_();
        if (item instanceof ExtendedArmorItem) {
            ExtendedArmorItem armorItem = (ExtendedArmorItem)item;
            contextModel.m_102872_(this.getModel());
            this.setVisible(this.getModel(), armorSlot);
            if (this.isColored()) {
                int i = ((DyeableLeatherItem)armorItem).m_41121_(itemStack);
                float red = (float)(i >> 16 & 0xFF) / 255.0f;
                float green = (float)(i >> 8 & 0xFF) / 255.0f;
                float blue = (float)(i & 0xFF) / 255.0f;
                this.renderParts(matrices, vertexConsumers, light, itemStack, armorItem, (EntityModel)this.getModel(), red, green, blue, false);
                this.renderParts(matrices, vertexConsumers, light, itemStack, armorItem, (EntityModel)this.getModel(), 1.0f, 1.0f, 1.0f, true);
            } else {
                this.renderParts(matrices, vertexConsumers, light, itemStack, armorItem, (EntityModel)this.getModel(), 1.0f, 1.0f, 1.0f, false);
            }
        }
    }
}

