/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.mixin;

import immersive_armors.item.ExtendedArmorItem;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={LivingEntity.class})
public abstract class MixinLivingEntity
extends Entity {
    protected MixinLivingEntity(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Invoker(value="applyDamage")
    protected abstract void invokeApplyDamage(DamageSource var1, float var2);

    @Shadow
    public abstract ItemStack m_6844_(EquipmentSlot var1);

    private float apply(EquipmentSlot slot, DamageSource source, float amount) {
        Item item;
        ItemStack stack = this.m_6844_(slot);
        if (stack != null && (item = stack.m_41720_()) instanceof ExtendedArmorItem) {
            ExtendedArmorItem armor = (ExtendedArmorItem)item;
            if (this instanceof LivingEntity) {
                amount = armor.applyArmorToDamage((LivingEntity)this, source, amount, stack);
            }
        }
        return amount;
    }

    private float applyToAttacker(LivingEntity attacker, EquipmentSlot slot, DamageSource source, float amount) {
        Item item;
        ItemStack stack = attacker.m_6844_(slot);
        if (stack != null && (item = stack.m_41720_()) instanceof ExtendedArmorItem) {
            ExtendedArmorItem armor = (ExtendedArmorItem)item;
            if (this instanceof LivingEntity) {
                amount = armor.applyArmorToAttack((LivingEntity)this, source, amount, stack);
            }
        }
        return amount;
    }

    @Redirect(method={"damage(Lnet/minecraft/entity/damage/DamageSource;F)Z"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V"))
    public void redirectApplyDamage(LivingEntity instance, DamageSource source, float amount) {
        amount = this.apply(EquipmentSlot.HEAD, source, amount);
        amount = this.apply(EquipmentSlot.CHEST, source, amount);
        amount = this.apply(EquipmentSlot.LEGS, source, amount);
        amount = this.apply(EquipmentSlot.FEET, source, amount);
        Entity attacker = source.m_7639_();
        if (attacker instanceof LivingEntity) {
            amount = this.applyToAttacker((LivingEntity)attacker, EquipmentSlot.HEAD, source, amount);
            amount = this.applyToAttacker((LivingEntity)attacker, EquipmentSlot.CHEST, source, amount);
            amount = this.applyToAttacker((LivingEntity)attacker, EquipmentSlot.LEGS, source, amount);
            amount = this.applyToAttacker((LivingEntity)attacker, EquipmentSlot.FEET, source, amount);
        }
        this.invokeApplyDamage(source, amount);
    }
}

