/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.client.render.entity.animation;

import com.faboslav.friendsandfoes.client.render.entity.animation.ModelPartAnimationContext;
import com.faboslav.friendsandfoes.client.render.entity.animation.ModelPartAnimationType;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public final class AnimationContextTracker {
    private final Map<String, ModelPartAnimationContext> animationPositionContext = new HashMap<String, ModelPartAnimationContext>();
    private final Map<String, ModelPartAnimationContext> animationRotationContext = new HashMap<String, ModelPartAnimationContext>();

    public boolean contains(String modelPartName, ModelPartAnimationType type) {
        if (type == ModelPartAnimationType.POSITION) {
            return this.animationPositionContext.containsKey(modelPartName);
        }
        if (type == ModelPartAnimationType.ROTATION) {
            return this.animationRotationContext.containsKey(modelPartName);
        }
        throw new RuntimeException(String.format("Invalid animation type '%s.'", new Object[]{type}));
    }

    public ModelPartAnimationContext get(String modelPartName, ModelPartAnimationType type) {
        if (type == ModelPartAnimationType.POSITION) {
            return this.animationPositionContext.get(modelPartName);
        }
        if (type == ModelPartAnimationType.ROTATION) {
            return this.animationRotationContext.get(modelPartName);
        }
        throw new RuntimeException(String.format("Invalid animation type '%s.'", new Object[]{type}));
    }

    public void add(String modelPartName, ModelPartAnimationType type, ModelPartAnimationContext animationContext) {
        if (type == ModelPartAnimationType.POSITION) {
            this.animationPositionContext.put(modelPartName, animationContext);
        } else if (type == ModelPartAnimationType.ROTATION) {
            this.animationRotationContext.put(modelPartName, animationContext);
        } else {
            throw new RuntimeException(String.format("Invalid animation type '%s.'", new Object[]{type}));
        }
    }

    public void remove(String modelPartName, ModelPartAnimationType type) {
        if (type == ModelPartAnimationType.POSITION) {
            this.animationPositionContext.remove(modelPartName);
        } else if (type == ModelPartAnimationType.ROTATION) {
            this.animationRotationContext.remove(modelPartName);
        } else {
            throw new RuntimeException(String.format("Invalid animation type '%s.'", new Object[]{type}));
        }
    }
}

