/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.client.render.entity.animation;

import com.faboslav.friendsandfoes.client.render.entity.animation.AnimationContextTracker;
import com.faboslav.friendsandfoes.client.render.entity.animation.ModelPartAnimationContext;
import com.faboslav.friendsandfoes.client.render.entity.animation.ModelPartAnimationType;
import com.faboslav.friendsandfoes.client.render.entity.animation.ModelPartAnimator;
import com.faboslav.friendsandfoes.entity.AnimatedEntity;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public final class ModelAnimator {
    AnimatedEntity entity;

    public void setEntity(AnimatedEntity entity) {
        this.entity = entity;
    }

    public void animateXPositionWithProgress(class_630 modelPart, float targetX, float progress) {
        this.animatePositionWithProgress(modelPart, targetX, modelPart.field_3656, modelPart.field_3655, progress);
    }

    public void animateYPositionWithProgress(class_630 modelPart, float targetY, float progress) {
        this.animatePositionWithProgress(modelPart, modelPart.field_3657, targetY, modelPart.field_3655, progress);
    }

    public void animateZPositionWithProgress(class_630 modelPart, float targetZ, float progress) {
        this.animatePositionWithProgress(modelPart, modelPart.field_3657, modelPart.field_3656, targetZ, progress);
    }

    public void animatePositionWithProgress(class_630 modelPart, float targetX, float targetY, float targetZ, float progress) {
        class_1160 targetVector = new class_1160(targetX, targetY, targetZ);
        this.animateWithProgress(modelPart, ModelPartAnimationType.POSITION, targetVector, progress);
    }

    public void animateXRotationWithProgress(class_630 modelPart, float targetX, float progress) {
        this.animateRotationWithProgress(modelPart, targetX, modelPart.field_3675, modelPart.field_3674, progress);
    }

    public void animateYRotationWithProgress(class_630 modelPart, float targetY, float progress) {
        this.animateRotationWithProgress(modelPart, modelPart.field_3654, targetY, modelPart.field_3674, progress);
    }

    public void animateZRotationWithProgress(class_630 modelPart, float targetX, float progress) {
        this.animateRotationWithProgress(modelPart, targetX, modelPart.field_3675, modelPart.field_3674, progress);
    }

    public void animateRotationWithProgress(class_630 modelPart, float targetX, float targetY, float targetZ, float progress) {
        class_1160 targetVector = new class_1160(targetX, targetY, targetZ);
        this.animateWithProgress(modelPart, ModelPartAnimationType.ROTATION, targetVector, progress);
    }

    private void animateWithProgress(class_630 modelPart, ModelPartAnimationType animationType, class_1160 targetVector, float progress) {
        class_1160 animationCurrentVector;
        ModelPartAnimationContext animationContext;
        String modelPartName = modelPart.toString();
        if (this.getAnimationContextTracker().contains(modelPartName, animationType)) {
            animationContext = this.getAnimationContextTracker().get(modelPartName, animationType);
            animationCurrentVector = animationContext.getCurrentVector();
            class_1160 animationTargetVector = animationContext.getTargetVector();
            if (!animationTargetVector.equals((Object)targetVector)) {
                this.getAnimationContextTracker().remove(modelPartName, animationType);
                animationContext = ModelPartAnimationContext.createWithProgress(progress, targetVector, animationCurrentVector);
                this.getAnimationContextTracker().add(modelPartName, animationType, animationContext);
            }
        } else {
            animationCurrentVector = switch (animationType) {
                default -> throw new IncompatibleClassChangeError();
                case ModelPartAnimationType.POSITION -> new class_1160(modelPart.field_3657, modelPart.field_3656, modelPart.field_3655);
                case ModelPartAnimationType.ROTATION -> new class_1160(modelPart.field_3654, modelPart.field_3675, modelPart.field_3674);
            };
            animationContext = ModelPartAnimationContext.createWithProgress(progress, targetVector, animationCurrentVector);
            this.getAnimationContextTracker().add(modelPartName, animationType, animationContext);
        }
        animationContext.setProgress(progress);
        animationContext.recalculateCurrentVector();
        animationCurrentVector = animationContext.getCurrentVector();
        switch (animationType) {
            case POSITION: {
                ModelPartAnimator.setPosition(modelPart, animationCurrentVector);
                break;
            }
            case ROTATION: {
                ModelPartAnimator.setRotation(modelPart, animationCurrentVector);
            }
        }
    }

    public void animateXPositionOverTicks(class_630 modelPart, float targetX, int ticks) {
        this.animatePositionOverTicks(modelPart, targetX, modelPart.field_3656, modelPart.field_3655, ticks);
    }

    public void animateYPositionOverTicks(class_630 modelPart, float targetY, int ticks) {
        this.animatePositionOverTicks(modelPart, modelPart.field_3657, targetY, modelPart.field_3655, ticks);
    }

    public void animateZPositionOverTicks(class_630 modelPart, float targetX, int ticks) {
        this.animatePositionOverTicks(modelPart, targetX, modelPart.field_3656, modelPart.field_3655, ticks);
    }

    public void animatePositionOverTicks(class_630 modelPart, float targetX, float targetY, float targetZ, int ticks) {
        class_1160 targetVector = new class_1160(targetX, targetY, targetZ);
        this.animateOverTicks(modelPart, ModelPartAnimationType.POSITION, targetVector, ticks);
    }

    public void animateXRotationOverTicks(class_630 modelPart, float targetX, int ticks) {
        this.animateRotationOverTicks(modelPart, targetX, modelPart.field_3675, modelPart.field_3674, ticks);
    }

    public void animateYRotationOverTicks(class_630 modelPart, float targetY, int ticks) {
        this.animateRotationOverTicks(modelPart, modelPart.field_3654, targetY, modelPart.field_3674, ticks);
    }

    public void animateZRotationOverTicks(class_630 modelPart, float targetZ, int ticks) {
        this.animateRotationOverTicks(modelPart, modelPart.field_3675, modelPart.field_3674, targetZ, ticks);
    }

    public void animateRotationOverTicks(class_630 modelPart, float targetX, float targetY, float targetZ, int ticks) {
        class_1160 targetVector = new class_1160(targetX, targetY, targetZ);
        this.animateOverTicks(modelPart, ModelPartAnimationType.ROTATION, targetVector, ticks);
    }

    private void animateOverTicks(class_630 modelPart, ModelPartAnimationType animationType, class_1160 targetVector, int ticks) {
        class_1160 currentVector;
        ModelPartAnimationContext animationContext;
        String modelPartName = modelPart.toString();
        if (this.getAnimationContextTracker().contains(modelPartName, animationType)) {
            animationContext = this.getAnimationContextTracker().get(modelPartName, animationType);
            currentVector = animationContext.getCurrentVector();
            if (currentVector.equals((Object)targetVector)) {
                switch (animationType) {
                    case POSITION: {
                        ModelPartAnimator.setPosition(modelPart, targetVector);
                        break;
                    }
                    case ROTATION: {
                        ModelPartAnimator.setRotation(modelPart, targetVector);
                    }
                }
                return;
            }
            class_1160 animationTargetVector = animationContext.getTargetVector();
            if (!animationTargetVector.equals((Object)targetVector)) {
                this.getAnimationContextTracker().remove(modelPartName, animationType);
                animationContext = ModelPartAnimationContext.createWithTicks(this.getEntityCurrentTick(), ticks, targetVector, currentVector);
                this.getAnimationContextTracker().add(modelPartName, animationType, animationContext);
            }
        } else {
            currentVector = switch (animationType) {
                default -> throw new IncompatibleClassChangeError();
                case ModelPartAnimationType.POSITION -> new class_1160(modelPart.field_3657, modelPart.field_3656, modelPart.field_3655);
                case ModelPartAnimationType.ROTATION -> new class_1160(modelPart.field_3654, modelPart.field_3675, modelPart.field_3674);
            };
            animationContext = ModelPartAnimationContext.createWithTicks(this.getEntityCurrentTick(), ticks, targetVector, currentVector);
            this.getAnimationContextTracker().add(modelPartName, animationType, animationContext);
        }
        animationContext.setCurrentTick(this.getEntityCurrentTick());
        animationContext.recalculateProgress();
        animationContext.recalculateCurrentVector();
        currentVector = animationContext.getCurrentVector();
        switch (animationType) {
            case POSITION: {
                ModelPartAnimator.setPosition(modelPart, currentVector);
                break;
            }
            case ROTATION: {
                ModelPartAnimator.setRotation(modelPart, currentVector);
            }
        }
    }

    private AnimationContextTracker getAnimationContextTracker() {
        return this.entity.getAnimationContextTracker();
    }

    private int getEntityCurrentTick() {
        return ((class_1297)this.entity).field_6012;
    }
}

