/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.client.render.entity.animation;

import com.faboslav.friendsandfoes.util.animation.AnimationMath;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1160;

@Environment(value=EnvType.CLIENT)
public final class ModelPartAnimationContext {
    private final int initialTick;
    private final int totalTicks;
    private int currentTick;
    private final class_1160 targetVector;
    private final class_1160 currentVector;
    private float progress;

    private ModelPartAnimationContext(int initialTick, int totalTicks, float progress, class_1160 targetVector, class_1160 currentVector) {
        this.initialTick = initialTick;
        this.totalTicks = totalTicks;
        this.currentTick = initialTick;
        this.progress = progress;
        this.targetVector = targetVector;
        this.currentVector = currentVector;
    }

    public static ModelPartAnimationContext createWithTicks(int initialTick, int totalTicks, class_1160 targetVector, class_1160 currentVector) {
        return new ModelPartAnimationContext(initialTick, totalTicks, 0.0f, targetVector, currentVector);
    }

    public static ModelPartAnimationContext createWithProgress(float progress, class_1160 targetVector, class_1160 currentVector) {
        return new ModelPartAnimationContext(0, 0, progress, targetVector, currentVector);
    }

    public void setCurrentTick(int currentTick) {
        this.currentTick = currentTick;
    }

    public void recalculateProgress() {
        float progress = (float)(this.currentTick - this.initialTick) / (float)this.totalTicks;
        this.progress = Math.min(Math.max(-1.0f, progress), 1.0f);
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public class_1160 getCurrentVector() {
        return this.currentVector;
    }

    public class_1160 getTargetVector() {
        return this.targetVector;
    }

    public void recalculateCurrentVector() {
        this.currentVector.method_4949(this.recalculateCurrentX(), this.recalculateCurrentY(), this.recalculateCurrentZ());
    }

    private float recalculateCurrentX() {
        return this.calculateNewValue(this.currentVector.method_4943(), this.targetVector.method_4943());
    }

    private float recalculateCurrentY() {
        return this.calculateNewValue(this.currentVector.method_4945(), this.targetVector.method_4945());
    }

    private float recalculateCurrentZ() {
        return this.calculateNewValue(this.currentVector.method_4947(), this.targetVector.method_4947());
    }

    private float calculateNewValue(float currentValue, float targetValue) {
        return AnimationMath.lerp(this.progress, currentValue, targetValue);
    }
}

