/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.client.render.entity.model;

import com.faboslav.friendsandfoes.client.render.entity.model.AnimatedEntityModel;
import com.faboslav.friendsandfoes.entity.AnimatedEntity;
import com.faboslav.friendsandfoes.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.util.ModelAnimationHelper;
import com.faboslav.friendsandfoes.util.animation.AnimationMath;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_4496;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public final class CopperGolemEntityModel<T extends CopperGolemEntity>
extends AnimatedEntityModel<T> {
    private static final String MODEL_PART_BODY = "body";
    private static final String MODEL_PART_LEFT_ARM = "leftArm";
    private static final String MODEL_PART_RIGHT_ARM = "rightArm";
    private static final String MODEL_PART_LEFT_LEG = "leftLeg";
    private static final String MODEL_PART_RIGHT_LEG = "rightLeg";
    private static final String MODEL_PART_HEAD = "head";
    private static final String MODEL_PART_NOSE = "nose";
    private static final String MODEL_PART_ROD = "rod";
    private final class_630 head;
    private final class_630 nose;
    private final class_630 rod;
    private final class_630 body;
    private final class_630 leftArm;
    private final class_630 rightArm;
    private final class_630 leftLeg;
    private final class_630 rightLeg;
    private float buttonPressAnimationProgress;
    private float headSpinAnimationProgress;

    public CopperGolemEntityModel(class_630 root) {
        super(root);
        this.head = this.root.method_32086(MODEL_PART_HEAD);
        this.nose = this.head.method_32086(MODEL_PART_NOSE);
        this.rod = this.head.method_32086(MODEL_PART_ROD);
        this.body = this.root.method_32086(MODEL_PART_BODY);
        this.leftArm = this.root.method_32086(MODEL_PART_LEFT_ARM);
        this.rightArm = this.root.method_32086(MODEL_PART_RIGHT_ARM);
        this.leftLeg = this.root.method_32086(MODEL_PART_LEFT_LEG);
        this.rightLeg = this.root.method_32086(MODEL_PART_RIGHT_LEG);
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 root = modelData.method_32111();
        root.method_32117(MODEL_PART_HEAD, class_5606.method_32108().method_32101(0, 0).method_32098(-4.0f, -5.0f, -4.0f, 8.0f, 5.0f, 8.0f, new class_5605(0.01f)), class_5603.method_32090((float)0.0f, (float)14.0f, (float)0.0f));
        class_5610 head = root.method_32116(MODEL_PART_HEAD);
        head.method_32117(MODEL_PART_NOSE, class_5606.method_32108().method_32101(56, 15).method_32097(-1.0f, -1.0f, -2.0f, 2.0f, 3.0f, 2.0f), class_5603.method_32090((float)0.0f, (float)-1.0f, (float)-4.0f));
        head.method_32117(MODEL_PART_ROD, class_5606.method_32108().method_32101(56, 10).method_32097(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f).method_32101(40, 10).method_32097(-2.0f, -7.0f, -2.0f, 4.0f, 4.0f, 4.0f), class_5603.method_32090((float)0.0f, (float)-5.0f, (float)0.0f));
        root.method_32117(MODEL_PART_BODY, class_5606.method_32108().method_32101(40, 0).method_32097(-4.0f, 0.0f, -2.0f, 8.0f, 5.0f, 4.0f), class_5603.method_32090((float)0.0f, (float)14.0f, (float)0.0f));
        root.method_32117(MODEL_PART_LEFT_ARM, class_5606.method_32108().method_32101(10, 17).method_32097(0.0f, -1.0f, -1.5f, 2.0f, 10.0f, 3.0f), class_5603.method_32090((float)4.0f, (float)14.0f, (float)0.0f));
        root.method_32117(MODEL_PART_RIGHT_ARM, class_5606.method_32108().method_32101(0, 17).method_32097(-2.0f, -1.0f, -1.5f, 2.0f, 10.0f, 3.0f), class_5603.method_32090((float)-4.0f, (float)14.0f, (float)0.0f));
        root.method_32117(MODEL_PART_LEFT_LEG, class_5606.method_32108().method_32101(34, 17).method_32097(-2.0f, 0.0f, -1.5f, 4.0f, 5.0f, 3.0f), class_5603.method_32090((float)2.0f, (float)19.0f, (float)0.0f));
        root.method_32117(MODEL_PART_RIGHT_LEG, class_5606.method_32108().method_32101(20, 17).method_32097(-2.0f, 0.0f, -1.5f, 4.0f, 5.0f, 3.0f), class_5603.method_32090((float)-2.0f, (float)19.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)modelData, (int)64, (int)64);
    }

    public void setAngles(T copperGolem, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        if (((CopperGolemEntity)copperGolem).isOxidized()) {
            class_2487 modelAngles = ((CopperGolemEntity)copperGolem).getEntitySnapshot();
            float tickDelta = modelAngles.method_10583("tickDelta");
            limbAngle = modelAngles.method_10583("limbAngle");
            limbDistance = modelAngles.method_10583("lastLimbDistance");
            animationProgress = ModelAnimationHelper.getAnimationProgress(copperGolem, tickDelta);
        } else if (((CopperGolemEntity)copperGolem).field_6235 == 0) {
            limbDistance = (float)((double)limbDistance * 1.5);
            limbAngle = (float)((double)limbAngle * 1.5);
        }
        this.applyModelTransforms("root", this.root);
        this.modelAnimator.setEntity((AnimatedEntity)copperGolem);
        float headSpinAnimationProgress = ((CopperGolemEntity)copperGolem).getHeadSpinAnimationProgress();
        this.rightLeg.field_3654 = -1.5f * class_3532.method_24504((float)limbAngle, (float)13.0f) * limbDistance;
        this.leftLeg.field_3654 = 1.5f * class_3532.method_24504((float)limbAngle, (float)13.0f) * limbDistance;
        this.rightLeg.field_3675 = 0.0f;
        this.leftLeg.field_3675 = 0.0f;
        if (headSpinAnimationProgress > 0.0f && headSpinAnimationProgress <= 1.0f) {
            this.head.field_3675 = (float)class_3532.method_16436((double)this.headSpinAnimationProgress, (double)0.0, (double)(Math.PI * 2));
        } else {
            this.head.field_3675 = headYaw * ((float)Math.PI / 180);
            this.head.field_3654 = headPitch * ((float)Math.PI / 180);
        }
        if (((CopperGolemEntity)copperGolem).getButtonPressAnimationProgress() > 0.0f) {
            if (((CopperGolemEntity)copperGolem).getButtonPressAnimationProgress() == 1.0f) {
                this.leftArm.field_3654 = (float)Math.toRadians(-180.0f + 30.0f * class_3532.method_15379((float)class_3532.method_15374((float)(animationProgress * 0.5f))));
                this.rightArm.field_3654 = (float)Math.toRadians(-180.0f + 30.0f * class_3532.method_15379((float)class_3532.method_15362((float)(animationProgress * 0.5f))));
                this.leftArm.field_3674 = (float)Math.toRadians(20.0);
                this.rightArm.field_3674 = (float)Math.toRadians(-20.0);
            } else {
                this.leftArm.field_3654 = class_4496.method_22114((float)this.leftArm.field_3654, (float)((float)Math.toRadians(-165.0)), (float)this.buttonPressAnimationProgress);
                this.rightArm.field_3654 = class_4496.method_22114((float)this.rightArm.field_3654, (float)((float)Math.toRadians(-165.0)), (float)this.buttonPressAnimationProgress);
                this.leftArm.field_3674 = class_4496.method_22114((float)this.leftArm.field_3674, (float)((float)Math.toRadians(20.0)), (float)this.buttonPressAnimationProgress);
                this.rightArm.field_3674 = class_4496.method_22114((float)this.rightArm.field_3674, (float)((float)Math.toRadians(-20.0)), (float)this.buttonPressAnimationProgress);
            }
        } else {
            this.leftArm.field_3654 = (-0.2f + 1.5f * class_3532.method_24504((float)limbAngle, (float)13.0f)) * limbDistance;
            this.rightArm.field_3654 = (-0.2f - 1.5f * class_3532.method_24504((float)limbAngle, (float)13.0f)) * limbDistance;
        }
        float defaultRodPivotY = this.rod.field_3656;
        if (copperGolem.method_24828() && ((CopperGolemEntity)copperGolem).isMoving() && !((CopperGolemEntity)copperGolem).isOxidized()) {
            float rodPivotY = defaultRodPivotY + AnimationMath.absSin(animationProgress, 1.0f, 0.25f);
            this.modelAnimator.animateYPositionWithProgress(this.rod, rodPivotY, AnimationMath.absSin(animationProgress));
        } else {
            this.modelAnimator.animateYPositionOverTicks(this.rod, defaultRodPivotY, 10);
        }
    }

    public void animateModel(T copperGolem, float limbAngle, float limbDistance, float tickDelta) {
        if (((CopperGolemEntity)copperGolem).isOxidized()) {
            class_2487 modelAngles = ((CopperGolemEntity)copperGolem).getEntitySnapshot();
            tickDelta = modelAngles.method_10583("tickDelta");
        }
        this.buttonPressAnimationProgress = ((CopperGolemEntity)copperGolem).getLastButtonPressAnimationProgress() + (((CopperGolemEntity)copperGolem).getButtonPressAnimationProgress() - ((CopperGolemEntity)copperGolem).getLastButtonPressAnimationProgress()) * tickDelta;
        this.headSpinAnimationProgress = ((CopperGolemEntity)copperGolem).getLastHeadSpinAnimationProgress() + (((CopperGolemEntity)copperGolem).getHeadSpinAnimationProgress() - ((CopperGolemEntity)copperGolem).getLastHeadSpinAnimationProgress()) * tickDelta;
    }
}

