/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.client.render.entity.model;

import com.faboslav.friendsandfoes.client.render.entity.animation.ModelPartAnimator;
import com.faboslav.friendsandfoes.client.render.entity.model.AnimatedEntityModel;
import com.faboslav.friendsandfoes.entity.AnimatedEntity;
import com.faboslav.friendsandfoes.entity.GlareEntity;
import com.faboslav.friendsandfoes.util.animation.AnimationMath;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1532;
import net.minecraft.class_241;
import net.minecraft.class_3532;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

@Environment(value=EnvType.CLIENT)
public final class GlareEntityModel<T extends GlareEntity>
extends AnimatedEntityModel<T> {
    private static final String MODEL_PART_ROOT = "root";
    private static final String MODEL_PART_HEAD = "head";
    private static final String MODEL_PART_EYES = "eyes";
    private static final String MODEL_TOP_AZALEA = "topAzalea";
    private static final String MODEL_BOTTOM_AZALEA = "bottomAzalea";
    private static final String MODEL_SECOND_LAYER = "secondLayer";
    private static final String MODEL_THIRD_LAYER = "thirdLayer";
    private static final String MODEL_FOURTH_LAYER = "fourthLayer";
    private final class_630 head;
    private final class_630 eyes;
    private final class_630 topAzalea;
    private final class_630 bottomAzalea;
    private final class_630 secondLayer;
    private final class_630 thirdLayer;
    private final class_630 fourthLayer;
    private final class_630[] layers;

    public GlareEntityModel(class_630 root) {
        super(root);
        this.head = this.root.method_32086(MODEL_PART_HEAD);
        this.eyes = this.head.method_32086(MODEL_PART_EYES);
        this.topAzalea = this.head.method_32086(MODEL_TOP_AZALEA);
        this.bottomAzalea = this.head.method_32086(MODEL_BOTTOM_AZALEA);
        this.secondLayer = this.bottomAzalea.method_32086(MODEL_SECOND_LAYER);
        this.thirdLayer = this.secondLayer.method_32086(MODEL_THIRD_LAYER);
        this.fourthLayer = this.thirdLayer.method_32086(MODEL_FOURTH_LAYER);
        this.layers = new class_630[]{this.secondLayer, this.thirdLayer, this.fourthLayer};
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 root = modelData.method_32111();
        root.method_32117(MODEL_PART_HEAD, class_5606.method_32108().method_32101(0, 0).method_32098(-6.0f, 0.0f, -3.0f, 12.0f, 9.0f, 9.0f, new class_5605(-0.02f)), class_5603.method_32090((float)0.0f, (float)1.0f, (float)0.0f));
        class_5610 head = root.method_32116(MODEL_PART_HEAD);
        head.method_32117(MODEL_PART_EYES, class_5606.method_32108().method_32101(36, 0).method_32098(2.0f, -1.0f, -0.3f, 2.0f, 2.0f, 1.0f, new class_5605(-0.29f)).method_32101(36, 0).method_32098(-4.0f, -1.0f, -0.3f, 2.0f, 2.0f, 1.0f, new class_5605(-0.29f)), class_5603.method_32090((float)0.0f, (float)5.0f, (float)-3.0f));
        head.method_32117(MODEL_TOP_AZALEA, class_5606.method_32108().method_32101(72, 0).method_32098(-7.0f, 0.0f, -7.0f, 14.0f, 8.0f, 14.0f, new class_5605(0.01f)), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        head.method_32117(MODEL_BOTTOM_AZALEA, class_5606.method_32108().method_32101(0, 114).method_32098(-7.0f, 0.75f, -7.0f, 14.0f, 0.0f, 14.0f, new class_5605(-0.01f)).method_32101(72, 22).method_32098(-7.0f, -4.0f, -7.0f, 14.0f, 10.0f, 14.0f, new class_5605(0.01f)), class_5603.method_32090((float)0.0f, (float)8.0f, (float)0.0f));
        class_5610 bottomAzalea = head.method_32116(MODEL_BOTTOM_AZALEA);
        bottomAzalea.method_32117(MODEL_SECOND_LAYER, class_5606.method_32108().method_32101(80, 46).method_32098(-6.0f, 0.0f, -6.0f, 12.0f, 7.0f, 12.0f, new class_5605(0.01f)), class_5603.method_32090((float)0.0f, (float)1.0f, (float)0.0f));
        class_5610 secondLayer = bottomAzalea.method_32116(MODEL_SECOND_LAYER);
        secondLayer.method_32117(MODEL_THIRD_LAYER, class_5606.method_32108().method_32101(88, 65).method_32097(-5.0f, 0.0f, -5.0f, 10.0f, 7.0f, 10.0f), class_5603.method_32090((float)0.0f, (float)2.0f, (float)0.0f));
        class_5610 thirdLayer = secondLayer.method_32116(MODEL_THIRD_LAYER);
        thirdLayer.method_32117(MODEL_FOURTH_LAYER, class_5606.method_32108().method_32101(96, 82).method_32097(-4.0f, 0.0f, -4.0f, 8.0f, 7.0f, 8.0f), class_5603.method_32090((float)0.0f, (float)2.0f, (float)0.0f));
        return class_5607.method_32110((class_5609)modelData, (int)128, (int)128);
    }

    public void setAngles(T glare, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.applyModelTransforms(MODEL_PART_ROOT, this.root);
        this.modelAnimator.setEntity((AnimatedEntity)glare);
        this.animateEyes(glare);
        this.animateHead(glare, animationProgress);
        this.animateLayers(glare, animationProgress);
    }

    public void animateModel(T glare, float limbAngle, float limbDistance, float tickDelta) {
        float targetLayerRoll;
        float targetLayerPitch;
        if (((GlareEntity)glare).isMoving() && !(glare.method_5933() instanceof class_1532) && !((GlareEntity)glare).isGrumpy()) {
            targetLayerPitch = (float)Math.toRadians(10.0);
            targetLayerRoll = (float)Math.toRadians(1.0);
        } else {
            targetLayerPitch = (float)Math.toRadians(1.0);
            targetLayerRoll = (float)Math.toRadians(1.0);
        }
        tickDelta = (float)Math.abs(Math.sin(tickDelta)) * 0.1f;
        float layerPitch = class_3532.method_16439((float)tickDelta, (float)((GlareEntity)glare).getCurrentLayersPitch(), (float)targetLayerPitch);
        float layerRoll = class_3532.method_16439((float)tickDelta, (float)((GlareEntity)glare).getCurrentLayersRoll(), (float)targetLayerRoll);
        ((GlareEntity)glare).setCurrentLayerPitch(layerPitch);
        ((GlareEntity)glare).setCurrentLayerRoll(layerRoll);
    }

    private void animateHead(T glare, float animationProgress) {
        if (((GlareEntity)glare).isGrumpy()) {
            ModelPartAnimator.setXPosition(this.root, AnimationMath.sin(animationProgress, 0.5f));
            ModelPartAnimator.setYPosition(this.root, AnimationMath.absSin(animationProgress, 0.1f));
            ModelPartAnimator.setYRotation(this.root, AnimationMath.sin(animationProgress, 0.05f));
        } else {
            float targetPivotY = ((GlareEntity)glare).method_24345() ? 3.0f : 0.0f;
            this.modelAnimator.animateYPositionOverTicks(this.root, targetPivotY, 10);
        }
    }

    private void animateEyes(T glare) {
        class_241 targetEyesPositionOffset = ((GlareEntity)glare).getTargetEyesPositionOffset();
        this.modelAnimator.animatePositionOverTicks(this.eyes, this.eyes.field_3657 + targetEyesPositionOffset.field_1343, this.eyes.field_3656 + targetEyesPositionOffset.field_1342, this.eyes.field_3655, 10);
    }

    private void animateLayers(T glare, float animationProgress) {
        float layerAnimationProgress = animationProgress * 0.1f;
        float targetPitchLayerAnimationProgress = (float)Math.sin(layerAnimationProgress);
        float targetRollLayerAnimationProgress = (float)Math.cos(layerAnimationProgress);
        if (((GlareEntity)glare).isMoving()) {
            targetPitchLayerAnimationProgress = Math.abs(targetPitchLayerAnimationProgress);
            targetRollLayerAnimationProgress = Math.abs(targetRollLayerAnimationProgress);
        } else if (((GlareEntity)glare).method_24345()) {
            targetPitchLayerAnimationProgress = 0.0f;
            targetRollLayerAnimationProgress = 0.0f;
        }
        float currentPitchLayerAnimationProgress = class_3532.method_16439((float)((float)Math.abs(Math.sin(animationProgress)) * 0.1f), (float)((GlareEntity)glare).getCurrentLayerPitchAnimationProgress(), (float)targetPitchLayerAnimationProgress);
        float currentRollLayerAnimationProgress = class_3532.method_16439((float)((float)Math.abs(Math.sin(animationProgress)) * 0.1f), (float)((GlareEntity)glare).getCurrentLayerRollAnimationProgress(), (float)targetRollLayerAnimationProgress);
        for (class_630 layer : this.layers) {
            layer.field_3654 = currentPitchLayerAnimationProgress * ((GlareEntity)glare).getCurrentLayersPitch();
            layer.field_3674 = currentRollLayerAnimationProgress * ((GlareEntity)glare).getCurrentLayersRoll();
        }
        if (((GlareEntity)glare).isMoving()) {
            this.root.field_3654 = currentPitchLayerAnimationProgress * ((GlareEntity)glare).getCurrentLayersPitch();
        }
        ((GlareEntity)glare).setCurrentLayerPitchAnimationProgress(currentPitchLayerAnimationProgress);
        ((GlareEntity)glare).setCurrentLayerRollAnimationProgress(currentRollLayerAnimationProgress);
    }
}

