/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity;

import com.faboslav.friendsandfoes.client.render.entity.animation.AnimationContextTracker;
import com.faboslav.friendsandfoes.entity.AnimatedEntity;
import com.faboslav.friendsandfoes.entity.ai.goal.GlareAvoidMonsterGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.GlareEatGlowBerriesGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.GlareFlyToDarkSpotGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.GlareFollowOwnerGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.GlareShakeOffGlowBerriesGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.GlareSitGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.GlareWanderAroundGoal;
import com.faboslav.friendsandfoes.entity.ai.pathing.GlareNavigation;
import com.faboslav.friendsandfoes.init.ModCriteria;
import com.faboslav.friendsandfoes.init.ModSounds;
import com.faboslav.friendsandfoes.mixin.EntityNavigationAccessor;
import com.faboslav.friendsandfoes.util.RandomGenerator;
import java.util.Random;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1331;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1408;
import net.minecraft.class_1432;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3494;
import net.minecraft.class_3611;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public final class GlareEntity
extends class_1321
implements class_1432,
AnimatedEntity {
    public static final Predicate<class_1542> PICKABLE_FOOD_FILTER;
    private static final int GRUMPY_BITMASK = 2;
    private static final float MOVEMENT_SPEED = 0.6f;
    public static final int MIN_EYE_ANIMATION_TICK_AMOUNT = 10;
    public static final int MIN_TICKS_UNTIL_CAN_FIND_DARK_SPOT = 200;
    public static final int MAX_TICKS_UNTIL_CAN_FIND_DARK_SPOT = 400;
    public static final int MIN_TICKS_UNTIL_CAN_EAT_GLOW_BERRIES = 300;
    public static final int MAX_TICKS_UNTIL_CAN_EAT_GLOW_BERRIES = 600;
    private static final class_2940<Byte> GLARE_FLAGS;
    private static final class_2940<Integer> TICKS_UNTIL_CAN_FIND_DARK_SPOT;
    private static final class_2940<Integer> TICKS_UNTIL_CAN_EAT_GLOW_BERRIES;
    @Environment(value=EnvType.CLIENT)
    private AnimationContextTracker animationTickTracker;
    private class_241 targetEyesPositionOffset;
    private float currentLayerPitch;
    private float currentLayerRoll;
    private float currentLayerPitchAnimationProgress;
    private float currentLayerRollAnimationProgress;
    private GlareEatGlowBerriesGoal eatGlowBerriesGoal;
    private GlareFlyToDarkSpotGoal flyToDarkSpotGoal;

    public GlareEntity(class_1299<? extends GlareEntity> entityType, class_1937 world) {
        super(entityType, world);
        if (this.method_6181()) {
            this.method_5971();
        }
        this.field_6207 = new class_1331((class_1308)this, 10, true);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_20, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_14, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
        this.method_5952(true);
        this.targetEyesPositionOffset = new class_241(0.0f, 0.0f);
        this.currentLayerPitch = 0.0f;
        this.currentLayerRoll = 0.0f;
        this.currentLayerPitchAnimationProgress = 0.0f;
        this.currentLayerRollAnimationProgress = 0.0f;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(GLARE_FLAGS, (Object)0);
        this.field_6011.method_12784(TICKS_UNTIL_CAN_FIND_DARK_SPOT, (Object)this.generateRandomTicksUntilCanFindDarkSpot());
        this.field_6011.method_12784(TICKS_UNTIL_CAN_EAT_GLOW_BERRIES, (Object)this.generateRandomTicksUntilCanEatGlowBerries());
    }

    private boolean hasGlareFlag(int bitmask) {
        return ((Byte)this.field_6011.method_12789(GLARE_FLAGS) & bitmask) != 0;
    }

    private void setGlareFlag(int bitmask, boolean value) {
        byte glareFlags = (Byte)this.field_6011.method_12789(GLARE_FLAGS);
        if (value) {
            this.field_6011.method_12778(GLARE_FLAGS, (Object)((byte)(glareFlags | bitmask)));
        } else {
            this.field_6011.method_12778(GLARE_FLAGS, (Object)((byte)(glareFlags & ~bitmask)));
        }
    }

    public boolean method_5974(double distanceSquared) {
        return !this.method_16914();
    }

    public static boolean canSpawn(class_1299<GlareEntity> glareEntityEntityType, class_5425 serverWorldAccess, class_3730 spawnReason, class_2338 blockPos, Random random) {
        class_2680 blockState = serverWorldAccess.method_8320(blockPos.method_10074());
        boolean isAboveSurfaceLevel = blockPos.method_10264() >= 63;
        boolean isSkyVisible = serverWorldAccess.method_8311(blockPos);
        boolean isBlockPosDarkSpot = serverWorldAccess.method_22335(blockPos, 0) <= 3;
        boolean isRelatedBlock = blockState.method_27852(class_2246.field_28681) || blockState.method_27852(class_2246.field_28680) || blockState.method_27852(class_2246.field_28678) || blockState.method_27852(class_2246.field_28679) || blockState.method_27852(class_2246.field_10479) || blockState.method_27852(class_2246.field_28684) || blockState.method_27852(class_2246.field_28682) || blockState.method_27852(class_2246.field_10460) || blockState.method_27852(class_2246.field_10566) || blockState.method_27852(class_2246.field_10255);
        return !isAboveSurfaceLevel && !isSkyVisible && !isBlockPosDarkSpot && isRelatedBlock;
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new GlareSitGoal(this));
        this.field_6201.method_6277(2, (class_1352)new GlareFollowOwnerGoal(this, 8.0f, 2.0f, false));
        this.field_6201.method_6277(3, new GlareAvoidMonsterGoal<class_1588>(this, class_1588.class, 16.0f));
        this.eatGlowBerriesGoal = new GlareEatGlowBerriesGoal(this);
        this.field_6201.method_6277(4, (class_1352)this.eatGlowBerriesGoal);
        this.field_6201.method_6277(4, (class_1352)new GlareShakeOffGlowBerriesGoal(this));
        this.flyToDarkSpotGoal = new GlareFlyToDarkSpotGoal(this);
        this.field_6201.method_6277(5, (class_1352)this.flyToDarkSpotGoal);
        this.field_6201.method_6277(6, (class_1352)new GlareWanderAroundGoal(this));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1347((class_1308)this));
    }

    public void method_5773() {
        super.method_5773();
        if (this.getTicksUntilCanFindDarkSpot() > 0) {
            this.setTicksUntilCanFindDarkSpot(this.getTicksUntilCanFindDarkSpot() - 1);
        }
        if (this.getTicksUntilCanEatGlowBerries() > 0) {
            this.setTicksUntilCanEatGlowBerries(this.getTicksUntilCanEatGlowBerries() - 1);
        } else if (!(this.method_37908().method_8608() || this.eatGlowBerriesGoal.isRunning || this.getTicksUntilCanEatGlowBerries() != 0 || this.method_6118(class_1304.field_6173).method_7960())) {
            this.method_5706((class_1935)this.method_6047().method_7909());
            this.method_5673(class_1304.field_6173, class_1799.field_8037);
        }
        this.updateTargetEyesPositionOffset();
    }

    public boolean method_18397(class_1799 stack) {
        class_1304 equipmentSlot = class_1308.method_32326((class_1799)stack);
        if (!this.method_6118(equipmentSlot).method_7960()) {
            return false;
        }
        return equipmentSlot == class_1304.field_6173 && super.method_18397(stack);
    }

    public boolean method_5939(class_1799 stack) {
        return this.eatGlowBerriesGoal.isRunning && this.method_6118(class_1304.field_6173).method_7960();
    }

    private void dropItem(class_1799 stack) {
        class_1542 itemEntity = new class_1542(this.field_6002, this.method_23317(), this.method_23318(), this.method_23321(), stack);
        this.field_6002.method_8649((class_1297)itemEntity);
    }

    protected void method_5949(class_1542 item) {
        class_1799 itemStack = item.method_6983();
        if (this.method_5939(itemStack) && PICKABLE_FOOD_FILTER.test(item)) {
            int i = itemStack.method_7947();
            if (i > 1) {
                this.dropItem(itemStack.method_7971(i - 1));
            }
            this.method_29499(item);
            this.method_5673(class_1304.field_6173, itemStack.method_7971(1));
            this.method_6103((class_1297)item, itemStack.method_7947());
            item.method_31472();
        }
    }

    public class_241 getTargetEyesPositionOffset() {
        return this.targetEyesPositionOffset;
    }

    public void setTargetEyesPositionOffset(float xEyePositionOffset, float yEyePositionOffset) {
        this.targetEyesPositionOffset = new class_241(xEyePositionOffset, yEyePositionOffset);
    }

    private void updateTargetEyesPositionOffset() {
        if (this.field_6012 % 10 != 0 || RandomGenerator.generateInt(0, 2) != 0) {
            return;
        }
        this.setTargetEyesPositionOffset(RandomGenerator.generateFloat(-0.5f, 0.5f), RandomGenerator.generateFloat(-0.4f, 0.4f));
    }

    public float getCurrentLayersPitch() {
        return this.currentLayerPitch;
    }

    public void setCurrentLayerPitch(float currentLayersPitch) {
        this.currentLayerPitch = currentLayersPitch;
    }

    public float getCurrentLayersRoll() {
        return this.currentLayerRoll;
    }

    public void setCurrentLayerRoll(float currentLayersRoll) {
        this.currentLayerRoll = currentLayersRoll;
    }

    public float getCurrentLayerPitchAnimationProgress() {
        return this.currentLayerPitchAnimationProgress;
    }

    public void setCurrentLayerPitchAnimationProgress(float currentLayersPitchAnimationProgress) {
        this.currentLayerPitchAnimationProgress = currentLayersPitchAnimationProgress;
    }

    public float getCurrentLayerRollAnimationProgress() {
        return this.currentLayerRollAnimationProgress;
    }

    public void setCurrentLayerRollAnimationProgress(float currentLayersRollAnimationProgress) {
        this.currentLayerRollAnimationProgress = currentLayersRollAnimationProgress;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23720, (double)0.6f).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23717, 48.0);
    }

    protected class_1408 method_5965(class_1937 world) {
        GlareNavigation glareNavigation = new GlareNavigation(this, world);
        glareNavigation.method_6332(false);
        glareNavigation.method_6354(false);
        glareNavigation.method_6331(true);
        EntityNavigationAccessor entityNavigation = (EntityNavigationAccessor)((Object)glareNavigation);
        entityNavigation.setNodeReachProximity(0.1f);
        return glareNavigation;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    protected class_3414 method_5994() {
        return (class_3414)ModSounds.ENTITY_GLARE_AMBIENT.get();
    }

    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        this.method_5783(soundEvent, 0.025f, RandomGenerator.generateFloat(0.85f, 1.25f));
    }

    private class_3414 getGrumpinessSound() {
        return (class_3414)ModSounds.ENTITY_GLARE_GRUMPINESS.get();
    }

    public void playGrumpinessSound() {
        class_3414 soundEvent = this.getGrumpinessSound();
        this.method_5783(soundEvent, 0.05f, RandomGenerator.generateFloat(1.2f, 1.3f));
    }

    private class_3414 getGrumpinessShortSound() {
        return (class_3414)ModSounds.ENTITY_GLARE_GRUMPINESS_SHORT.get();
    }

    public void playGrumpinessShortSound() {
        class_3414 soundEvent = this.getGrumpinessShortSound();
        this.method_5783(soundEvent, 0.05f, RandomGenerator.generateFloat(1.2f, 1.3f));
    }

    private class_3414 getRustleSound() {
        return (class_3414)ModSounds.ENTITY_GLARE_RUSTLE.get();
    }

    public void playRustleSound() {
        class_3414 soundEvent = this.getRustleSound();
        this.method_5783(soundEvent, 0.1f, 0.1f);
    }

    public class_3414 method_18869(class_1799 stack) {
        return (class_3414)ModSounds.ENTITY_GLARE_EAT.get();
    }

    public void playEatSound(class_1799 stack) {
        class_3414 soundEvent = this.method_18869(stack);
        this.method_5783(soundEvent, 1.0f, 1.0f);
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)ModSounds.ENTITY_GLARE_HURT.get();
    }

    protected void method_6013(class_1282 source) {
        this.method_5783(this.method_6011(source), 1.0f, 0.5f);
    }

    protected class_3414 method_6002() {
        return (class_3414)ModSounds.ENTITY_GLARE_DEATH.get();
    }

    protected float method_6107() {
        return 1.0f;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 itemInHand = itemStack.method_7909();
        boolean interactionResult = false;
        if (itemInHand == class_1802.field_28659) {
            interactionResult = this.method_6181() ? this.tryToHealWithGlowBerries(player, itemStack) : this.tryToTameWithGlowBerries(player, itemStack);
        }
        if (interactionResult) {
            this.method_33569(class_5712.field_28725, this.method_33575());
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        class_1269 actionResult = super.method_5992(player, hand);
        if (this.method_6171((class_1309)player) && !actionResult.method_23665() && !this.isGrumpy()) {
            this.method_24346(!this.method_24345());
            this.method_5942().method_6344(0.0);
            this.method_5942().method_6340();
            return class_1269.field_5812;
        }
        return actionResult;
    }

    private boolean tryToHealWithGlowBerries(class_1657 player, class_1799 itemStack) {
        if (this.method_6032() == this.method_6063()) {
            return false;
        }
        if (this.field_6002.field_9236) {
            return true;
        }
        class_1792 glowBerries = itemStack.method_7909();
        if (glowBerries.method_19264() == null) {
            return false;
        }
        this.method_6025(glowBerries.method_19264().method_19230());
        if (!player.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        this.playEatSound(itemStack);
        class_2392 particleEffect = new class_2392(class_2398.field_11218, itemStack);
        this.spawnParticles((class_2394)particleEffect, 7);
        return true;
    }

    private boolean tryToTameWithGlowBerries(class_1657 player, class_1799 itemStack) {
        if (this.field_6002.field_9236) {
            return true;
        }
        if (!player.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        this.playEatSound(itemStack);
        if (this.field_5974.nextInt(3) == 0) {
            this.method_6170(player);
            this.field_6002.method_8421((class_1297)this, (byte)7);
        } else {
            this.field_6002.method_8421((class_1297)this, (byte)6);
        }
        return true;
    }

    public boolean method_24345() {
        return this.method_6172();
    }

    public void method_24346(boolean isSitting) {
        super.method_24346(isSitting);
        super.method_6179(isSitting);
    }

    public boolean method_6581() {
        return !this.field_5952;
    }

    private void swimUpward(class_3494<class_3611> fluid) {
        this.method_18799(this.method_18798().method_1031(0.0, 0.01, 0.0));
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
    }

    public boolean method_5931(class_1657 player) {
        return !this.method_5934();
    }

    protected void method_6180(boolean positive) {
        class_2400 particleEffect = positive ? class_2398.field_11201 : class_2398.field_11251;
        for (int i = 0; i < 7; ++i) {
            double d = this.field_5974.nextGaussian() * 0.02;
            double e = this.field_5974.nextGaussian() * 0.02;
            double f = this.field_5974.nextGaussian() * 0.02;
            this.field_6002.method_8406((class_2394)particleEffect, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
        }
    }

    public void method_6173(boolean tamed) {
        super.method_6173(tamed);
        if (tamed) {
            this.method_5996(class_5134.field_23716).method_6192(20.0);
            this.method_6033(this.method_6063());
        } else {
            this.method_5996(class_5134.field_23716).method_6192(10.0);
        }
    }

    public void method_6170(class_1657 owner) {
        this.method_5971();
        this.method_6173(true);
        this.method_6174(owner.method_5667());
        if (owner instanceof class_3222) {
            ModCriteria.TAME_GLARE.trigger((class_3222)owner, this);
        }
    }

    public boolean method_6481(class_1799 stack) {
        return false;
    }

    public boolean method_6482() {
        return false;
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.method_37908().method_8608()) {
            this.flyToDarkSpotGoal.method_6270();
        }
        this.method_24346(false);
        this.method_5942().method_6344(0.0);
        this.method_5942().method_6340();
        return super.method_5643(source, amount);
    }

    public int getTicksUntilCanFindDarkSpot() {
        return (Integer)this.field_6011.method_12789(TICKS_UNTIL_CAN_FIND_DARK_SPOT);
    }

    public void setTicksUntilCanFindDarkSpot(int ticksUntilCanFindDarkSpot) {
        this.field_6011.method_12778(TICKS_UNTIL_CAN_FIND_DARK_SPOT, (Object)ticksUntilCanFindDarkSpot);
    }

    public int generateRandomTicksUntilCanFindDarkSpot() {
        return RandomGenerator.generateInt(200, 400);
    }

    public int getTicksUntilCanEatGlowBerries() {
        return (Integer)this.field_6011.method_12789(TICKS_UNTIL_CAN_EAT_GLOW_BERRIES);
    }

    public void setTicksUntilCanEatGlowBerries(int ticksUntilCanEatGlowBerries) {
        this.field_6011.method_12778(TICKS_UNTIL_CAN_EAT_GLOW_BERRIES, (Object)ticksUntilCanEatGlowBerries);
    }

    public int generateRandomTicksUntilCanEatGlowBerries() {
        return RandomGenerator.generateInt(300, 600);
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)this.method_5751() * 0.6, 0.0);
    }

    protected float method_18394(class_4050 poseIn, class_4048 sizeIn) {
        return 1.1f;
    }

    public float method_6029() {
        return 0.6f;
    }

    public float getFastMovementSpeed() {
        return 0.75f;
    }

    public void setGrumpy(boolean grumpy) {
        this.setGlareFlag(2, grumpy);
    }

    public boolean isGrumpy() {
        return this.hasGlareFlag(2);
    }

    public boolean isMoving() {
        return !this.method_24828() && this.method_18798().method_1027() >= 1.0E-4;
    }

    public void spawnParticles(class_2394 particleEffect, int amount) {
        class_1937 world = this.method_37908();
        if (world.method_8608()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((class_3218)world).method_14199(particleEffect, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 1, this.method_6051().nextGaussian() * 0.02, this.method_6051().nextGaussian() * 0.02, this.method_6051().nextGaussian() * 0.02, 0.1);
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationTickTracker == null) {
            this.animationTickTracker = new AnimationContextTracker();
        }
        return this.animationTickTracker;
    }

    static {
        GLARE_FLAGS = class_2945.method_12791(GlareEntity.class, (class_2941)class_2943.field_13319);
        TICKS_UNTIL_CAN_EAT_GLOW_BERRIES = class_2945.method_12791(GlareEntity.class, (class_2941)class_2943.field_13327);
        TICKS_UNTIL_CAN_FIND_DARK_SPOT = class_2945.method_12791(GlareEntity.class, (class_2941)class_2943.field_13327);
        PICKABLE_FOOD_FILTER = itemEntity -> {
            class_1792 item = itemEntity.method_6983().method_7909();
            return item == class_1802.field_28659.method_8389() && itemEntity.method_5805() && !itemEntity.method_6977();
        };
    }
}

