/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.init.ModEntity;
import com.faboslav.friendsandfoes.init.ModSounds;
import com.faboslav.friendsandfoes.util.RandomGenerator;
import com.faboslav.friendsandfoes.util.animation.AnimationMath;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import org.jetbrains.annotations.Nullable;

public final class IceologerIceChunkEntity
extends class_1297 {
    private static final String OWNER_UUID_NBT_NAME = "OwnerUuid";
    private static final String TARGET_UUID_NBT_NAME = "TargetUuid";
    private static final String TICKS_UNTIL_FALL_NBT_NAME = "TicksUntilFall";
    private static final String IDLE_TICKS_NBT_NAME = "IdleTicks";
    private static final int MIN_FLYING_TICKS = 60;
    private static final int MAX_FLYING_TICKS = 100;
    private static final int MIN_IDLE_TICKS = 10;
    private static final int MAX_IDLE_TICKS = 20;
    private static final int SUMMON_TICKS = 30;
    private static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(IceologerIceChunkEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Optional<UUID>> TARGET_UUID = class_2945.method_12791(IceologerIceChunkEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<class_2487> TARGET_POSITION = class_2945.method_12791(IceologerIceChunkEntity.class, (class_2941)class_2943.field_13318);
    private static final class_2940<Integer> TICKS_UNTIL_FALL = class_2945.method_12791(IceologerIceChunkEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> IDLE_TICKS = class_2945.method_12791(IceologerIceChunkEntity.class, (class_2941)class_2943.field_13327);
    @Nullable
    private class_1309 owner;
    @Nullable
    private class_1309 target;
    private int lifetimeTicks;
    private float summonAnimationProgress;
    private float lastSummonAnimationProgress;

    public IceologerIceChunkEntity(class_1299<? extends IceologerIceChunkEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5684(true);
        this.method_5875(true);
        this.lifetimeTicks = 0;
        this.summonAnimationProgress = 0.0f;
        this.lastSummonAnimationProgress = 0.0f;
        this.playSummonSound();
    }

    protected void method_5693() {
        this.field_6011.method_12784(OWNER_UUID, Optional.empty());
        this.field_6011.method_12784(TARGET_UUID, Optional.empty());
        this.field_6011.method_12784(TARGET_POSITION, (Object)new class_2487());
        this.field_6011.method_12784(TICKS_UNTIL_FALL, (Object)RandomGenerator.generateInt(60, 100));
        this.field_6011.method_12784(IDLE_TICKS, (Object)RandomGenerator.generateInt(10, 20));
    }

    protected void method_5749(class_2487 nbt) {
        if (nbt.method_25928(OWNER_UUID_NBT_NAME)) {
            this.setOwnerUuid(nbt.method_25926(OWNER_UUID_NBT_NAME));
        }
        if (nbt.method_25928(TARGET_UUID_NBT_NAME)) {
            this.setTargetUuid(nbt.method_25926(TARGET_UUID_NBT_NAME));
        }
        if (nbt.method_10545(TICKS_UNTIL_FALL_NBT_NAME)) {
            this.setTicksUntilFall(nbt.method_10550(TICKS_UNTIL_FALL_NBT_NAME));
        }
        if (nbt.method_10545(IDLE_TICKS_NBT_NAME)) {
            this.setIdleTicks(nbt.method_10550(IDLE_TICKS_NBT_NAME));
        }
    }

    protected void method_5652(class_2487 nbt) {
        if (this.getOwnerUuid() != null) {
            nbt.method_25927(OWNER_UUID_NBT_NAME, this.getOwnerUuid());
        }
        if (this.getTargetUuid() != null) {
            nbt.method_25927(TARGET_UUID_NBT_NAME, this.getTargetUuid());
        }
        nbt.method_10569(TICKS_UNTIL_FALL_NBT_NAME, this.getTicksUntilFall());
        nbt.method_10569(IDLE_TICKS_NBT_NAME, this.getIdleTicks());
    }

    @Nullable
    public UUID getOwnerUuid() {
        return ((Optional)this.field_6011.method_12789(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(OWNER_UUID, Optional.ofNullable(uuid));
    }

    @Nullable
    public class_1309 getOwner() {
        class_1297 entity;
        if (this.owner == null && this.getOwnerUuid() != null && !this.method_37908().method_8608() && (entity = ((class_3218)this.field_6002).method_14190(this.getOwnerUuid())) instanceof class_1309) {
            this.owner = (class_1309)entity;
        }
        return this.owner;
    }

    @Nullable
    public UUID getTargetUuid() {
        return ((Optional)this.field_6011.method_12789(TARGET_UUID)).orElse(null);
    }

    public void setTargetUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(TARGET_UUID, Optional.ofNullable(uuid));
    }

    @Nullable
    public class_1309 getTarget() {
        class_1297 entity;
        if (this.target == null && this.getTargetUuid() != null && !this.method_37908().method_8608() && (entity = ((class_3218)this.field_6002).method_14190(this.getTargetUuid())) instanceof class_1309) {
            this.target = (class_1309)entity;
        }
        return this.target;
    }

    public void setTargetPosition(class_2487 targetPosition) {
        this.field_6011.method_12778(TARGET_POSITION, (Object)targetPosition);
    }

    public class_2487 getTargetPosition() {
        return (class_2487)this.field_6011.method_12789(TARGET_POSITION);
    }

    public void method_5773() {
        super.method_5773();
        if (this.lifetimeTicks == 10) {
            this.playSummonSound();
        } else if (this.lifetimeTicks == 40) {
            this.playAmbientSound();
        }
        ++this.lifetimeTicks;
        this.setSummonAnimationProgress();
        if (this.getTarget() != null && !this.method_37908().method_8608()) {
            class_1657 playerTarget;
            if (this.getTarget().method_31747() && ((playerTarget = (class_1657)this.getTarget()).method_7325() || playerTarget.method_7337())) {
                this.customDiscard();
                return;
            }
            if (this.getTicksUntilFall() > 0) {
                this.setPositionAboveTarget();
            }
        }
        if (this.getTicksUntilFall() > 0) {
            this.setTicksUntilFall(this.getTicksUntilFall() - 1);
            return;
        }
        this.method_5762(0.0, -0.05f, 0.0);
        this.method_5784(class_1313.field_6308, this.method_18798());
        if (this.field_5992) {
            this.damageHitEntities();
            this.customDiscard();
        }
    }

    public class_2596<?> method_18002() {
        return new class_2604((class_1297)this);
    }

    public int getTicksUntilFall() {
        return (Integer)this.field_6011.method_12789(TICKS_UNTIL_FALL);
    }

    private void setTicksUntilFall(int ticksUntilFall) {
        this.field_6011.method_12778(TICKS_UNTIL_FALL, (Object)ticksUntilFall);
    }

    private int getIdleTicks() {
        return (Integer)this.field_6011.method_12789(IDLE_TICKS);
    }

    private void setIdleTicks(int idleTicks) {
        this.field_6011.method_12778(IDLE_TICKS, (Object)idleTicks);
    }

    private void damageHitEntities() {
        if (this.method_37908().method_8608()) {
            return;
        }
        List hitEntities = this.method_37908().method_18467(class_1309.class, this.method_5829().method_1009(0.2, 0.0, 0.2));
        for (class_1309 hitEntity : hitEntities) {
            this.damage(hitEntity);
        }
    }

    private void damage(class_1309 hitEntity) {
        class_1309 livingEntity = this.getOwner();
        if (!hitEntity.method_5805() || hitEntity.method_5655() || hitEntity == livingEntity || livingEntity != null && livingEntity.method_5722((class_1297)hitEntity)) {
            return;
        }
        hitEntity.method_5643(class_1282.field_5846, 12.0f);
        if (hitEntity.method_32316()) {
            hitEntity.method_32317(400);
        }
    }

    private void customDiscard() {
        this.playHitSound();
        this.spawnHitParticles();
        this.method_31472();
    }

    public void setPositionAboveTarget() {
        if (this.getTarget() == null || this.getTicksUntilFall() <= 10) {
            return;
        }
        float tickDelta = FriendsAndFoes.serverTickDeltaCounter.tickDelta;
        double x = this.method_19538().method_10216();
        double y = this.method_19538().method_10214();
        double z = this.method_19538().method_10215();
        float height = this.getTarget().method_17682();
        if (!(this.getTargetPosition().method_10545("x") && this.getTargetPosition().method_10545("y") && this.getTargetPosition().method_10545("z") && this.getTargetPosition().method_10545("height"))) {
            x = this.getTarget().method_23317();
            y = this.getTarget().method_23318();
            z = this.getTarget().method_23321();
        }
        double yWithHeightOffset = this.getYPositionWithHeightOffset(y, height);
        double targetX = this.getTarget().method_23317();
        double targetY = this.getTarget().method_23318();
        double targetZ = this.getTarget().method_23321();
        double targetYWithHeightOffset = this.getYPositionWithHeightOffset(targetY, height);
        class_2487 targetPosition = new class_2487();
        targetPosition.method_10549("x", x);
        targetPosition.method_10549("y", y);
        targetPosition.method_10549("z", z);
        targetPosition.method_10549("height", (double)height);
        this.method_5814(AnimationMath.lerp(tickDelta, x, targetX), AnimationMath.lerp(tickDelta, yWithHeightOffset, targetYWithHeightOffset), AnimationMath.lerp(tickDelta, z, targetZ));
    }

    public void setPositionAboveTarget(float tickDelta) {
        if (!(this.method_37908().method_8608() && this.getTargetPosition().method_10545("x") && this.getTargetPosition().method_10545("y") && this.getTargetPosition().method_10545("z") && this.getTargetPosition().method_10545("height"))) {
            return;
        }
        double x = this.method_19538().method_10216();
        double y = this.method_19538().method_10214();
        double z = this.method_19538().method_10215();
        double targetX = this.getTargetPosition().method_10574("x");
        double targetY = this.getTargetPosition().method_10574("y");
        double targetZ = this.getTargetPosition().method_10574("z");
        double targetHeight = this.getTargetPosition().method_10574("height");
        double targetYWithHeightOffset = this.getYPositionWithHeightOffset(targetY, targetHeight);
        this.method_5814(AnimationMath.lerp(tickDelta, x, targetX), AnimationMath.lerp(tickDelta, y, targetYWithHeightOffset), AnimationMath.lerp(tickDelta, z, targetZ));
    }

    private double getYPositionWithHeightOffset(double y, double height) {
        return Math.min(y + height * height, y + 6.0);
    }

    private class_3414 getAmbientSound() {
        return (class_3414)ModSounds.ENTITY_ICE_CHUNK_AMBIENT.get();
    }

    private void playAmbientSound() {
        class_3414 soundEvent = this.getAmbientSound();
        this.method_5783(soundEvent, 1.0f, RandomGenerator.generateFloat(0.95f, 1.05f));
    }

    private class_3414 getHitSound() {
        return (class_3414)ModSounds.ENTITY_ICE_CHUNK_HIT.get();
    }

    private void playHitSound() {
        class_3414 soundEvent = this.getHitSound();
        this.method_5783(soundEvent, 1.0f, RandomGenerator.generateFloat(0.95f, 1.05f));
    }

    private class_3414 getSummonSound() {
        return (class_3414)ModSounds.ENTITY_ICE_CHUNK_SUMMON.get();
    }

    private void playSummonSound() {
        class_3414 soundEvent = this.getSummonSound();
        this.method_5783(soundEvent, 1.0f, RandomGenerator.generateFloat(0.95f, 1.05f));
    }

    public void spawnHitParticles() {
        this.spawnParticles((class_2394)new class_2388(class_2398.field_11217, class_2246.field_10384.method_9564()), 16);
    }

    private void spawnParticles(class_2394 particleEffect, int amount) {
        class_1937 world = this.method_37908();
        if (world.method_8608()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((class_3218)world).method_14199(particleEffect, this.method_23322(0.5), this.method_23319() + 0.5, this.method_23325(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public float getSummonAnimationProgress() {
        return this.summonAnimationProgress;
    }

    public void setSummonAnimationProgress() {
        this.lastSummonAnimationProgress = this.summonAnimationProgress;
        this.summonAnimationProgress = Math.min(1.0f, (float)this.lifetimeTicks / 30.0f);
    }

    public float getLastSummonAnimationProgress() {
        return this.lastSummonAnimationProgress;
    }

    public static IceologerIceChunkEntity createWithOwnerAndTarget(class_1937 world, class_1309 owner, class_1309 target) {
        IceologerIceChunkEntity chunkEntity = new IceologerIceChunkEntity((class_1299<? extends IceologerIceChunkEntity>)((class_1299)ModEntity.ICE_CHUNK.get()), world);
        chunkEntity.setOwnerUuid(owner.method_5667());
        chunkEntity.setTargetUuid(target.method_5667());
        chunkEntity.method_5814(target.method_23317(), chunkEntity.getYPositionWithHeightOffset(target.method_23318(), target.method_17682()), target.method_23321());
        return chunkEntity;
    }
}

