/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.goal;

import com.faboslav.friendsandfoes.block.CopperButtonBlock;
import com.faboslav.friendsandfoes.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.util.RandomGenerator;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public final class CopperGolemPressButtonGoal
extends class_1352 {
    private final int COPPER_BUTTON_SEARCH_DISTANCE = 8;
    private final CopperGolemEntity copperGolem;
    private class_2338 copperButtonToPress;
    private class_2338 positionToStandOn;
    private class_2338 positionToLookAt;
    private class_11 currentPath;
    private int standingNearToCopperButtonTicks;
    private int idleTicksBeforeButtonPress;
    private int idleTicksAfterButtonPress;
    private int ticksAfterButtonPress;
    private boolean isRunning;
    private int runTicks;
    private boolean copperButtonWasSuccessfullyPressed;
    private final Predicate<class_2680> copperButtonPredicate = state -> state.method_26204() instanceof CopperButtonBlock;

    public CopperGolemPressButtonGoal(CopperGolemEntity copperGolem) {
        this.copperGolem = copperGolem;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.copperGolem.getTicksUntilCanPressButton() > 0) {
            return false;
        }
        if (this.copperGolem.isOxidized()) {
            return false;
        }
        if (this.copperGolem.method_5942().method_23966()) {
            return false;
        }
        if (this.copperGolem.isSpinningHead()) {
            return false;
        }
        ArrayList<class_2338> copperButtons = this.findCopperButtons();
        this.copperButtonToPress = this.getRandomCopperButtonToPress(copperButtons);
        if (this.copperButtonToPress == null) {
            return false;
        }
        this.calculatePositionToStandOn();
        this.calculatePositionToLookAt();
        return this.positionToStandOn != null && this.positionToLookAt != null;
    }

    public boolean method_6266() {
        if (this.copperGolem.isOxidized()) {
            return false;
        }
        if (this.runTicks >= 900) {
            return false;
        }
        if (this.copperButtonWasSuccessfullyPressed && this.ticksAfterButtonPress >= this.idleTicksAfterButtonPress) {
            return false;
        }
        if (this.copperButtonToPress == null || this.positionToStandOn == null || this.positionToLookAt == null) {
            return false;
        }
        class_2680 copperButtonBlockState = this.getCopperButtonBlockState(this.copperButtonToPress);
        return copperButtonBlockState != null;
    }

    public void method_6269() {
        this.isRunning = true;
        this.runTicks = 0;
        this.standingNearToCopperButtonTicks = 0;
        this.ticksAfterButtonPress = 0;
        this.copperButtonWasSuccessfullyPressed = false;
        int minIdleTicks = 20;
        int maxIdleTicks = 40;
        this.idleTicksBeforeButtonPress = RandomGenerator.generateInt(minIdleTicks, maxIdleTicks);
        this.idleTicksAfterButtonPress = RandomGenerator.generateInt(minIdleTicks, maxIdleTicks);
    }

    public void method_6270() {
        this.isRunning = false;
        this.copperButtonToPress = null;
        this.positionToStandOn = null;
        this.positionToLookAt = null;
        this.currentPath = null;
        this.copperGolem.setIsPressingButton(false);
        int minCooldownTicks = 150;
        if (this.copperGolem.isDegraded()) {
            minCooldownTicks *= this.copperGolem.getOxidationLevel().ordinal();
        }
        int maxCooldownTicks = 1200;
        int cooldown = RandomGenerator.generateInt(minCooldownTicks, maxCooldownTicks);
        this.copperGolem.setTicksUntilCanPressButton(cooldown);
    }

    public void method_6268() {
        ++this.runTicks;
        class_1408 navigation = this.copperGolem.method_5942();
        double distanceToButton = this.copperGolem.method_19538().method_1028((double)this.positionToStandOn.method_10263(), (double)this.positionToStandOn.method_10264(), (double)this.positionToStandOn.method_10260());
        this.currentPath = navigation.method_6352((double)this.positionToStandOn.method_10263(), (double)this.positionToStandOn.method_10264(), (double)this.positionToStandOn.method_10260(), 0);
        if (this.currentPath != null) {
            this.copperGolem.method_5942().method_6334(this.currentPath, (double)this.copperGolem.method_6029());
        }
        if (distanceToButton <= 3.0) {
            this.copperGolem.method_5988().method_20248((double)this.positionToLookAt.method_10263(), (double)this.positionToLookAt.method_10264(), (double)this.positionToLookAt.method_10260());
        }
        if (distanceToButton >= 1.5) {
            if (this.copperGolem.isPressingButton()) {
                this.copperGolem.setIsPressingButton(false);
            }
            return;
        }
        ++this.standingNearToCopperButtonTicks;
        if (this.standingNearToCopperButtonTicks >= this.idleTicksBeforeButtonPress / 3 && !this.copperGolem.isPressingButton()) {
            this.copperGolem.setIsPressingButton(true);
        }
        if (this.standingNearToCopperButtonTicks <= this.idleTicksBeforeButtonPress) {
            return;
        }
        if (!this.copperButtonWasSuccessfullyPressed) {
            this.copperButtonWasSuccessfullyPressed = this.pressCopperButton();
        } else {
            ++this.ticksAfterButtonPress;
        }
    }

    private boolean pressCopperButton() {
        class_2680 copperButtonBlockState = this.getCopperButtonBlockState(this.copperButtonToPress);
        if (copperButtonBlockState == null) {
            return false;
        }
        if (((Boolean)copperButtonBlockState.method_11654((class_2769)CopperButtonBlock.field_10729)).booleanValue()) {
            return false;
        }
        CopperButtonBlock copperButtonBlock = (CopperButtonBlock)copperButtonBlockState.method_26204();
        copperButtonBlock.method_21845(copperButtonBlockState, this.copperGolem.method_5770(), this.copperButtonToPress);
        this.copperGolem.method_5770().method_8396(null, this.copperButtonToPress, copperButtonBlock.method_9712(true), class_3419.field_15245, 0.3f, 0.6f);
        this.copperGolem.method_5770().method_32888((class_1297)this.copperGolem, class_5712.field_28174, this.copperButtonToPress);
        return true;
    }

    private ArrayList<class_2338> findCopperButtons() {
        int horizontalSearchDistance = 8;
        int verticalSearchDistance = 4;
        class_1937 world = this.copperGolem.method_37908();
        class_2338 currentPosition = this.copperGolem.method_24515();
        ArrayList<class_2338> copperButtonBlocks = new ArrayList<class_2338>();
        for (int xPosition = -horizontalSearchDistance; xPosition <= horizontalSearchDistance; ++xPosition) {
            for (int zPosition = -horizontalSearchDistance; zPosition <= horizontalSearchDistance; ++zPosition) {
                for (int yPosition = -verticalSearchDistance; yPosition <= verticalSearchDistance; ++yPosition) {
                    class_2338.class_2339 mutableBlockPosition = new class_2338.class_2339();
                    mutableBlockPosition.method_10103(currentPosition.method_10263() + xPosition, currentPosition.method_10264() + yPosition, currentPosition.method_10260() + zPosition);
                    if (!this.copperButtonPredicate.test(world.method_8320((class_2338)mutableBlockPosition))) continue;
                    copperButtonBlocks.add((class_2338)mutableBlockPosition);
                }
            }
        }
        return copperButtonBlocks;
    }

    @Nullable
    private class_2338 getRandomCopperButtonToPress(ArrayList<class_2338> copperButtons) {
        int copperButtonsCount = copperButtons.size();
        if (copperButtonsCount == 0) {
            return null;
        }
        int randomCopperButtonIndex = RandomGenerator.generateInt(0, copperButtonsCount - 1);
        return copperButtons.get(randomCopperButtonIndex);
    }

    private void calculatePositionToStandOn() {
        class_2680 copperButtonBlockState = this.getCopperButtonBlockState(this.copperButtonToPress);
        if (copperButtonBlockState == null) {
            return;
        }
        class_2338 positionToStandOn = null;
        class_2350 direction = (class_2350)copperButtonBlockState.method_11654((class_2769)class_2383.field_11177);
        class_3218 serverWorld = (class_3218)this.copperGolem.method_5770();
        switch (direction) {
            case field_11033: {
                if (!serverWorld.method_22347(this.copperButtonToPress.method_10074()) || !serverWorld.method_8320(this.copperButtonToPress.method_10087(2)).method_26168((class_1922)serverWorld, this.copperButtonToPress, (class_1297)this.copperGolem)) break;
                positionToStandOn = this.copperButtonToPress.method_10069(0, -2, 0);
                break;
            }
            case field_11036: {
                if (!serverWorld.method_8320(this.copperButtonToPress.method_10087(1)).method_26168((class_1922)serverWorld, this.copperButtonToPress, (class_1297)this.copperGolem) || !serverWorld.method_22347(this.copperButtonToPress.method_10084())) break;
                positionToStandOn = this.copperButtonToPress;
                break;
            }
            case field_11043: 
            case field_11035: 
            case field_11034: 
            case field_11039: {
                if (serverWorld.method_22347(this.copperButtonToPress.method_10074()) && serverWorld.method_8320(this.copperButtonToPress.method_10087(2)).method_26168((class_1922)serverWorld, this.copperButtonToPress, (class_1297)this.copperGolem)) {
                    positionToStandOn = this.copperButtonToPress.method_10069(0, -1, 0);
                    break;
                }
                if (!serverWorld.method_22347(this.copperButtonToPress.method_10084()) || !serverWorld.method_8320(this.copperButtonToPress.method_10074()).method_26168((class_1922)serverWorld, this.copperButtonToPress, (class_1297)this.copperGolem)) break;
                positionToStandOn = this.copperButtonToPress;
            }
        }
        if (positionToStandOn != null) {
            positionToStandOn = positionToStandOn.method_10080(0.5, 0.0, 0.5);
        }
        this.positionToStandOn = positionToStandOn;
    }

    private void calculatePositionToLookAt() {
        class_2680 copperButtonBlockState = this.getCopperButtonBlockState(this.copperButtonToPress);
        if (copperButtonBlockState == null) {
            return;
        }
        class_2338 positionToLookAt = this.copperButtonToPress;
        class_2350 direction = (class_2350)copperButtonBlockState.method_11654((class_2769)class_2383.field_11177);
        this.positionToLookAt = positionToLookAt = (switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033, class_2350.field_11036 -> positionToLookAt;
            case class_2350.field_11043 -> positionToLookAt.method_10069(0, 0, 1);
            case class_2350.field_11034 -> positionToLookAt.method_10069(-1, 0, 0);
            case class_2350.field_11035 -> positionToLookAt.method_10069(0, 0, -1);
            case class_2350.field_11039 -> positionToLookAt.method_10069(1, 0, 0);
        });
    }

    @Nullable
    private class_2680 getCopperButtonBlockState(class_2338 copperButtonBlockPos) {
        class_3218 serverWorld = (class_3218)this.copperGolem.method_5770();
        class_2680 blockState = serverWorld.method_8320(copperButtonBlockPos);
        if (blockState.method_26204() instanceof CopperButtonBlock) {
            return blockState;
        }
        return null;
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

