/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.init;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.config.FriendsAndFoesConfig;
import com.faboslav.friendsandfoes.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.entity.GlareEntity;
import com.faboslav.friendsandfoes.entity.IceologerEntity;
import com.faboslav.friendsandfoes.entity.IceologerIceChunkEntity;
import com.faboslav.friendsandfoes.entity.MaulerEntity;
import com.faboslav.friendsandfoes.entity.MoobloomEntity;
import com.faboslav.friendsandfoes.mixin.SpawnRestrictionAccessor;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1430;
import net.minecraft.class_155;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_2902;
import net.minecraft.class_3732;
import net.minecraft.class_5321;
import net.minecraft.class_5483;

public final class ModEntity {
    private static final DeferredRegister<class_1299<?>> ENTITY_TYPES = DeferredRegister.create((String)"friendsandfoes", (class_5321)class_2378.field_25107);
    private static boolean previousUseChoiceTypeRegistrations = class_155.field_25135;
    public static final RegistrySupplier<class_1299<CopperGolemEntity>> COPPER_GOLEM;
    public static final RegistrySupplier<class_1299<GlareEntity>> GLARE;
    public static final RegistrySupplier<class_1299<IceologerEntity>> ICEOLOGER;
    public static final RegistrySupplier<class_1299<IceologerIceChunkEntity>> ICE_CHUNK;
    public static final RegistrySupplier<class_1299<MaulerEntity>> MAULER;
    public static final RegistrySupplier<class_1299<MoobloomEntity>> MOOBLOOM;

    public static void initRegister() {
        previousUseChoiceTypeRegistrations = class_155.field_25135;
        class_155.field_25135 = false;
        ENTITY_TYPES.register();
        class_155.field_25135 = previousUseChoiceTypeRegistrations;
        ModEntity.initMobAttributes();
    }

    public static void init() {
        ModEntity.initSpawnRestrictions();
        ModEntity.initBiomeModifications();
    }

    public static void initMobAttributes() {
        EntityAttributeRegistry.register(COPPER_GOLEM, CopperGolemEntity::createAttributes);
        EntityAttributeRegistry.register(GLARE, GlareEntity::createAttributes);
        EntityAttributeRegistry.register(ICEOLOGER, IceologerEntity::createAttributes);
        EntityAttributeRegistry.register(MAULER, MaulerEntity::createAttributes);
        EntityAttributeRegistry.register(MOOBLOOM, class_1430::method_26883);
    }

    public static void initSpawnRestrictions() {
        SpawnRestrictionAccessor.callRegister((class_1299)GLARE.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, GlareEntity::canSpawn);
        SpawnRestrictionAccessor.callRegister((class_1299)ICEOLOGER.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, class_3732::method_20739);
        SpawnRestrictionAccessor.callRegister((class_1299)MAULER.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, MaulerEntity::canSpawn);
        SpawnRestrictionAccessor.callRegister((class_1299)MOOBLOOM.get(), class_1317.class_1319.field_6317, class_2902.class_2903.field_13203, MoobloomEntity::canSpawn);
    }

    public static void initBiomeModifications() {
        FriendsAndFoesConfig config = FriendsAndFoes.getConfig();
        if (config.enableGlareSpawn) {
            Predicate<BiomeModifications.BiomeContext> LUSH_CAVES = ctx -> Objects.equals(ctx.getKey(), class_1972.field_29218.method_29177());
            ModEntity.registerBiomeModification(LUSH_CAVES, (class_1299)GLARE.get(), class_1311.field_6303, config.glareSpawnWeight, config.glareSpawnMinGroupSize, config.glareSpawnMaxGroupSize);
        }
        if (config.enableMaulerSpawn) {
            Predicate<BiomeModifications.BiomeContext> DESERT = ctx -> Objects.equals(ctx.getKey(), class_1972.field_9424.method_29177());
            Predicate<BiomeModifications.BiomeContext> BADLANDS = ctx -> Objects.equals(ctx.getKey(), class_1972.field_9415.method_29177());
            Predicate<BiomeModifications.BiomeContext> ERODED_BADLANDS = ctx -> Objects.equals(ctx.getKey(), class_1972.field_9443.method_29177());
            Predicate<BiomeModifications.BiomeContext> WOODED_BADLANDS = ctx -> Objects.equals(ctx.getKey(), class_1972.field_35110.method_29177());
            Predicate<BiomeModifications.BiomeContext> SAVANNA = ctx -> Objects.equals(ctx.getKey(), class_1972.field_9449.method_29177());
            Predicate<BiomeModifications.BiomeContext> SAVANNA_PLATEAU = ctx -> Objects.equals(ctx.getKey(), class_1972.field_9430.method_29177());
            ModEntity.registerBiomeModification(DESERT, (class_1299)MAULER.get(), class_1311.field_6294, config.maulerDesertSpawnWeight, config.maulerDesertSpawnMinGroupSize, config.maulerDesertSpawnMaxGroupSize);
            ModEntity.registerBiomeModification(BADLANDS, (class_1299)MAULER.get(), class_1311.field_6294, config.maulerBadlandsSpawnWeight, config.maulerBadlandsSpawnMinGroupSize, config.maulerBadlandsSpawnMaxGroupSize);
            ModEntity.registerBiomeModification(ERODED_BADLANDS, (class_1299)MAULER.get(), class_1311.field_6294, config.maulerBadlandsSpawnWeight, config.maulerBadlandsSpawnMinGroupSize, config.maulerBadlandsSpawnMaxGroupSize);
            ModEntity.registerBiomeModification(WOODED_BADLANDS, (class_1299)MAULER.get(), class_1311.field_6294, config.maulerBadlandsSpawnWeight, config.maulerBadlandsSpawnMinGroupSize, config.maulerBadlandsSpawnMaxGroupSize);
            ModEntity.registerBiomeModification(SAVANNA, (class_1299)MAULER.get(), class_1311.field_6294, config.maulerSavannaSpawnWeight, config.maulerSavannaSpawnMinGroupSize, config.maulerSavannaSpawnMaxGroupSize);
            ModEntity.registerBiomeModification(SAVANNA_PLATEAU, (class_1299)MAULER.get(), class_1311.field_6294, config.maulerSavannaSpawnWeight, config.maulerSavannaSpawnMinGroupSize, config.maulerSavannaSpawnMaxGroupSize);
        }
        if (config.enableMoobloomSpawn) {
            Predicate<BiomeModifications.BiomeContext> FLOWER_FOREST = ctx -> Objects.equals(ctx.getKey(), class_1972.field_9414.method_29177());
            Predicate<BiomeModifications.BiomeContext> MEADOW = ctx -> Objects.equals(ctx.getKey(), class_1972.field_34470.method_29177());
            ModEntity.registerBiomeModification(FLOWER_FOREST, (class_1299)MOOBLOOM.get(), class_1311.field_6294, config.moobloomFlowerForestSpawnWeight, config.moobloomFlowerForestSpawnMinGroupSize, config.moobloomFlowerForestSpawnMaxGroupSize);
            ModEntity.registerBiomeModification(MEADOW, (class_1299)MOOBLOOM.get(), class_1311.field_6294, config.moobloomMeadowSpawnWeight, config.moobloomMeadowSpawnMinGroupSize, config.moobloomMeadowSpawnMaxGroupSize);
        }
    }

    private static void registerBiomeModification(Predicate<BiomeModifications.BiomeContext> biomes, class_1299<?> type, class_1311 spawnGroup, int weight, int min, int max) {
        BiomeModifications.addProperties(biomes, (ctx, p) -> p.getSpawnProperties().addSpawn(spawnGroup, new class_5483.class_1964(type, weight, min, max)));
    }

    private ModEntity() {
    }

    static {
        class_155.field_25135 = false;
        COPPER_GOLEM = ENTITY_TYPES.register("copper_golem", () -> class_1299.class_1300.method_5903(CopperGolemEntity::new, (class_1311)class_1311.field_17715).method_17687(0.75f, 1.375f).method_27299(10).method_5905(FriendsAndFoes.makeStringID("copper_golem")));
        GLARE = ENTITY_TYPES.register("glare", () -> class_1299.class_1300.method_5903(GlareEntity::new, (class_1311)class_1311.field_6303).method_17687(0.875f, 1.4375f).method_27299(8).method_5905(FriendsAndFoes.makeStringID("glare")));
        ICEOLOGER = ENTITY_TYPES.register("iceologer", () -> class_1299.class_1300.method_5903(IceologerEntity::new, (class_1311)class_1311.field_6302).method_17687(0.6f, 1.95f).method_27299(10).method_5905(FriendsAndFoes.makeStringID("iceologer")));
        ICE_CHUNK = ENTITY_TYPES.register("ice_chunk", () -> class_1299.class_1300.method_5903(IceologerIceChunkEntity::new, (class_1311)class_1311.field_17715).method_19947().method_17687(2.5f, 1.0f).method_27299(6).method_5905(FriendsAndFoes.makeStringID("ice_chunk")));
        MAULER = ENTITY_TYPES.register("mauler", () -> class_1299.class_1300.method_5903(MaulerEntity::new, (class_1311)class_1311.field_6294).method_17687(0.5625f, 0.5625f).method_27299(10).method_5905(FriendsAndFoes.makeStringID("mauler")));
        MOOBLOOM = ENTITY_TYPES.register("moobloom", () -> class_1299.class_1300.method_5903(MoobloomEntity::new, (class_1311)class_1311.field_6294).method_17687(0.9f, 1.4f).method_27299(10).method_5905(FriendsAndFoes.makeStringID("moobloom")));
        class_155.field_25135 = previousUseChoiceTypeRegistrations;
    }
}

