/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.client.render.entity;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.client.render.entity.model.CopperGolemEntityModel;
import com.faboslav.friendsandfoes.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.init.ModEntityRenderer;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class CopperGolemEntityRenderer
extends MobRenderer<CopperGolemEntity, CopperGolemEntityModel<CopperGolemEntity>> {
    private static final Map<WeatheringCopper.WeatherState, ResourceLocation> OXIDATION_TO_TEXTURE_MAP = ImmutableMap.of((Object)WeatheringCopper.WeatherState.UNAFFECTED, (Object)FriendsAndFoes.makeID("textures/entity/copper_golem/copper_golem.png"), (Object)WeatheringCopper.WeatherState.EXPOSED, (Object)FriendsAndFoes.makeID("textures/entity/copper_golem/exposed_copper_golem.png"), (Object)WeatheringCopper.WeatherState.WEATHERED, (Object)FriendsAndFoes.makeID("textures/entity/copper_golem/weathered_copper_golem.png"), (Object)WeatheringCopper.WeatherState.OXIDIZED, (Object)FriendsAndFoes.makeID("textures/entity/copper_golem/oxidized_copper_golem.png"));

    public CopperGolemEntityRenderer(EntityRendererProvider.Context context) {
        super(context, new CopperGolemEntityModel(context.m_174023_(ModEntityRenderer.COPPER_GOLEM_LAYER)), 0.35f);
    }

    public ResourceLocation getTexture(CopperGolemEntity entity) {
        return OXIDATION_TO_TEXTURE_MAP.get(entity.getOxidationLevel());
    }
}

