/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.client.render.entity.animation;

import com.faboslav.friendsandfoes.client.render.entity.animation.AnimationContextTracker;
import com.faboslav.friendsandfoes.client.render.entity.animation.ModelPartAnimationContext;
import com.faboslav.friendsandfoes.client.render.entity.animation.ModelPartAnimationType;
import com.faboslav.friendsandfoes.client.render.entity.animation.ModelPartAnimator;
import com.faboslav.friendsandfoes.entity.AnimatedEntity;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ModelAnimator {
    AnimatedEntity entity;

    public void setEntity(AnimatedEntity entity) {
        this.entity = entity;
    }

    public void animateXPositionWithProgress(ModelPart modelPart, float targetX, float progress) {
        this.animatePositionWithProgress(modelPart, targetX, modelPart.f_104201_, modelPart.f_104202_, progress);
    }

    public void animateYPositionWithProgress(ModelPart modelPart, float targetY, float progress) {
        this.animatePositionWithProgress(modelPart, modelPart.f_104200_, targetY, modelPart.f_104202_, progress);
    }

    public void animateZPositionWithProgress(ModelPart modelPart, float targetZ, float progress) {
        this.animatePositionWithProgress(modelPart, modelPart.f_104200_, modelPart.f_104201_, targetZ, progress);
    }

    public void animatePositionWithProgress(ModelPart modelPart, float targetX, float targetY, float targetZ, float progress) {
        Vector3f targetVector = new Vector3f(targetX, targetY, targetZ);
        this.animateWithProgress(modelPart, ModelPartAnimationType.POSITION, targetVector, progress);
    }

    public void animateXRotationWithProgress(ModelPart modelPart, float targetX, float progress) {
        this.animateRotationWithProgress(modelPart, targetX, modelPart.f_104204_, modelPart.f_104205_, progress);
    }

    public void animateYRotationWithProgress(ModelPart modelPart, float targetY, float progress) {
        this.animateRotationWithProgress(modelPart, modelPart.f_104203_, targetY, modelPart.f_104205_, progress);
    }

    public void animateZRotationWithProgress(ModelPart modelPart, float targetX, float progress) {
        this.animateRotationWithProgress(modelPart, targetX, modelPart.f_104204_, modelPart.f_104205_, progress);
    }

    public void animateRotationWithProgress(ModelPart modelPart, float targetX, float targetY, float targetZ, float progress) {
        Vector3f targetVector = new Vector3f(targetX, targetY, targetZ);
        this.animateWithProgress(modelPart, ModelPartAnimationType.ROTATION, targetVector, progress);
    }

    private void animateWithProgress(ModelPart modelPart, ModelPartAnimationType animationType, Vector3f targetVector, float progress) {
        Vector3f animationCurrentVector;
        ModelPartAnimationContext animationContext;
        String modelPartName = modelPart.toString();
        if (this.getAnimationContextTracker().contains(modelPartName, animationType)) {
            animationContext = this.getAnimationContextTracker().get(modelPartName, animationType);
            animationCurrentVector = animationContext.getCurrentVector();
            Vector3f animationTargetVector = animationContext.getTargetVector();
            if (!animationTargetVector.equals((Object)targetVector)) {
                this.getAnimationContextTracker().remove(modelPartName, animationType);
                animationContext = ModelPartAnimationContext.createWithProgress(progress, targetVector, animationCurrentVector);
                this.getAnimationContextTracker().add(modelPartName, animationType, animationContext);
            }
        } else {
            animationCurrentVector = switch (animationType) {
                default -> throw new IncompatibleClassChangeError();
                case ModelPartAnimationType.POSITION -> new Vector3f(modelPart.f_104200_, modelPart.f_104201_, modelPart.f_104202_);
                case ModelPartAnimationType.ROTATION -> new Vector3f(modelPart.f_104203_, modelPart.f_104204_, modelPart.f_104205_);
            };
            animationContext = ModelPartAnimationContext.createWithProgress(progress, targetVector, animationCurrentVector);
            this.getAnimationContextTracker().add(modelPartName, animationType, animationContext);
        }
        animationContext.setProgress(progress);
        animationContext.recalculateCurrentVector();
        animationCurrentVector = animationContext.getCurrentVector();
        switch (animationType) {
            case POSITION: {
                ModelPartAnimator.setPosition(modelPart, animationCurrentVector);
                break;
            }
            case ROTATION: {
                ModelPartAnimator.setRotation(modelPart, animationCurrentVector);
            }
        }
    }

    public void animateXPositionOverTicks(ModelPart modelPart, float targetX, int ticks) {
        this.animatePositionOverTicks(modelPart, targetX, modelPart.f_104201_, modelPart.f_104202_, ticks);
    }

    public void animateYPositionOverTicks(ModelPart modelPart, float targetY, int ticks) {
        this.animatePositionOverTicks(modelPart, modelPart.f_104200_, targetY, modelPart.f_104202_, ticks);
    }

    public void animateZPositionOverTicks(ModelPart modelPart, float targetX, int ticks) {
        this.animatePositionOverTicks(modelPart, targetX, modelPart.f_104201_, modelPart.f_104202_, ticks);
    }

    public void animatePositionOverTicks(ModelPart modelPart, float targetX, float targetY, float targetZ, int ticks) {
        Vector3f targetVector = new Vector3f(targetX, targetY, targetZ);
        this.animateOverTicks(modelPart, ModelPartAnimationType.POSITION, targetVector, ticks);
    }

    public void animateXRotationOverTicks(ModelPart modelPart, float targetX, int ticks) {
        this.animateRotationOverTicks(modelPart, targetX, modelPart.f_104204_, modelPart.f_104205_, ticks);
    }

    public void animateYRotationOverTicks(ModelPart modelPart, float targetY, int ticks) {
        this.animateRotationOverTicks(modelPart, modelPart.f_104203_, targetY, modelPart.f_104205_, ticks);
    }

    public void animateZRotationOverTicks(ModelPart modelPart, float targetZ, int ticks) {
        this.animateRotationOverTicks(modelPart, modelPart.f_104204_, modelPart.f_104205_, targetZ, ticks);
    }

    public void animateRotationOverTicks(ModelPart modelPart, float targetX, float targetY, float targetZ, int ticks) {
        Vector3f targetVector = new Vector3f(targetX, targetY, targetZ);
        this.animateOverTicks(modelPart, ModelPartAnimationType.ROTATION, targetVector, ticks);
    }

    private void animateOverTicks(ModelPart modelPart, ModelPartAnimationType animationType, Vector3f targetVector, int ticks) {
        Vector3f currentVector;
        ModelPartAnimationContext animationContext;
        String modelPartName = modelPart.toString();
        if (this.getAnimationContextTracker().contains(modelPartName, animationType)) {
            animationContext = this.getAnimationContextTracker().get(modelPartName, animationType);
            currentVector = animationContext.getCurrentVector();
            if (currentVector.equals((Object)targetVector)) {
                switch (animationType) {
                    case POSITION: {
                        ModelPartAnimator.setPosition(modelPart, targetVector);
                        break;
                    }
                    case ROTATION: {
                        ModelPartAnimator.setRotation(modelPart, targetVector);
                    }
                }
                return;
            }
            Vector3f animationTargetVector = animationContext.getTargetVector();
            if (!animationTargetVector.equals((Object)targetVector)) {
                this.getAnimationContextTracker().remove(modelPartName, animationType);
                animationContext = ModelPartAnimationContext.createWithTicks(this.getEntityCurrentTick(), ticks, targetVector, currentVector);
                this.getAnimationContextTracker().add(modelPartName, animationType, animationContext);
            }
        } else {
            currentVector = switch (animationType) {
                default -> throw new IncompatibleClassChangeError();
                case ModelPartAnimationType.POSITION -> new Vector3f(modelPart.f_104200_, modelPart.f_104201_, modelPart.f_104202_);
                case ModelPartAnimationType.ROTATION -> new Vector3f(modelPart.f_104203_, modelPart.f_104204_, modelPart.f_104205_);
            };
            animationContext = ModelPartAnimationContext.createWithTicks(this.getEntityCurrentTick(), ticks, targetVector, currentVector);
            this.getAnimationContextTracker().add(modelPartName, animationType, animationContext);
        }
        animationContext.setCurrentTick(this.getEntityCurrentTick());
        animationContext.recalculateProgress();
        animationContext.recalculateCurrentVector();
        currentVector = animationContext.getCurrentVector();
        switch (animationType) {
            case POSITION: {
                ModelPartAnimator.setPosition(modelPart, currentVector);
                break;
            }
            case ROTATION: {
                ModelPartAnimator.setRotation(modelPart, currentVector);
            }
        }
    }

    private AnimationContextTracker getAnimationContextTracker() {
        return this.entity.getAnimationContextTracker();
    }

    private int getEntityCurrentTick() {
        return ((Entity)this.entity).f_19797_;
    }
}

