/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity;

import com.faboslav.friendsandfoes.client.render.entity.animation.AnimationContextTracker;
import com.faboslav.friendsandfoes.entity.AnimatedEntity;
import com.faboslav.friendsandfoes.entity.ai.goal.CopperGolemFleeEntityGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.CopperGolemLookAtEntityGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.CopperGolemPressButtonGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.CopperGolemSpinHeadGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.CopperGolemTemptGoal;
import com.faboslav.friendsandfoes.entity.ai.goal.CopperGolemWanderAroundGoal;
import com.faboslav.friendsandfoes.init.ModSounds;
import com.faboslav.friendsandfoes.mixin.EntityNavigationAccessor;
import com.faboslav.friendsandfoes.util.ModelAnimationHelper;
import com.faboslav.friendsandfoes.util.RandomGenerator;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class CopperGolemEntity
extends AbstractGolem
implements AnimatedEntity {
    private static final float MOVEMENT_SPEED = 0.35f;
    private static final int COPPER_INGOT_HEAL_AMOUNT = 5;
    private static final float OXIDATION_CHANCE = 4.0E-5f;
    public static final int MIN_TICKS_UNTIL_CAN_PRESS_BUTTON = 200;
    public static final int MAX_TICKS_UNTIL_CAN_PRESS_BUTTON = 1200;
    public static final int MIN_TICKS_UNTIL_NEXT_HEAD_SPIN = 150;
    public static final int MAX_TICKS_UNTIL_NEXT_HEAD_SPIN = 300;
    private static final String OXIDATION_LEVEL_NBT_NAME = "OxidationLevel";
    private static final String IS_WAXED_NBT_NAME = "IsWaxed";
    private static final String BUTTON_PRESS_ANIMATION_PROGRESS_NBT_NAME = "ButtonPressAnimationProgress";
    private static final String LAST_BUTTON_PRESS_ANIMATION_PROGRESS_NBT_NAME = "LastButtonPressAnimationProgress";
    private static final String HEAD_SPIN_ANIMATION_PROGRESS_NBT_NAME = "HeadSpinAnimationProgress";
    private static final String LAST_HEAD_SPIN_ANIMATION_PROGRESS_NBT_NAME = "LastHeadSpinAnimationProgress";
    private static final String ENTITY_SNAPSHOT_NBT_NAME = "EntitySnapshot";
    private static final EntityDataAccessor<Integer> OXIDATION_LEVEL = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> OXIDATION_TICKS = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_WAXED = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_PRESSING_BUTTON = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SPINNING_HEAD;
    private static final EntityDataAccessor<Boolean> IS_MOVING;
    private static final EntityDataAccessor<Integer> TICKS_UNTIL_CAN_PRESS_BUTTON;
    private static final EntityDataAccessor<Integer> TICKS_UNTIL_NEXT_HEAD_SPIN;
    private static final EntityDataAccessor<Float> BUTTON_PRESS_ANIMATION_PROGRESS;
    private static final EntityDataAccessor<Float> LAST_BUTTON_PRESS_ANIMATION_PROGRESS;
    private static final EntityDataAccessor<Float> HEAD_SPIN_ANIMATION_PROGRESS;
    private static final EntityDataAccessor<Float> LAST_HEAD_SPIN_ANIMATION_PROGRESS;
    private static final EntityDataAccessor<CompoundTag> ENTITY_SNAPSHOT;
    private static final Predicate<Entity> NOTICEABLE_PLAYER_FILTER;
    public CopperGolemPressButtonGoal pressButtonGoal;
    @OnlyIn(value=Dist.CLIENT)
    private AnimationContextTracker animationTickTracker;

    public CopperGolemEntity(EntityType<? extends CopperGolemEntity> entityType, Level world) {
        super(entityType, world);
        this.f_19793_ = 0.3f;
        EntityNavigationAccessor entityNavigation = (EntityNavigationAccessor)this.m_21573_();
        entityNavigation.setNodeReachProximity(0.01f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CopperGolemFleeEntityGoal((PathfinderMob)this, Player.class, 16.0f, this.m_6113_(), this.m_6113_(), entity -> NOTICEABLE_PLAYER_FILTER.test((Entity)((Player)entity)) && this.isWaxed()));
        this.pressButtonGoal = new CopperGolemPressButtonGoal(this);
        this.f_21345_.m_25352_(2, (Goal)this.pressButtonGoal);
        this.f_21345_.m_25352_(3, (Goal)new CopperGolemTemptGoal(this, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42784_})));
        this.f_21345_.m_25352_(4, (Goal)new CopperGolemSpinHeadGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new CopperGolemWanderAroundGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new CopperGolemLookAtEntityGoal((Mob)this, CopperGolemEntity.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new CopperGolemLookAtEntityGoal((Mob)this, IronGolem.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new CopperGolemLookAtEntityGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OXIDATION_LEVEL, (Object)WeatheringCopper.WeatherState.UNAFFECTED.ordinal());
        this.f_19804_.m_135372_(OXIDATION_TICKS, (Object)0);
        this.f_19804_.m_135372_(IS_WAXED, (Object)false);
        this.f_19804_.m_135372_(IS_PRESSING_BUTTON, (Object)false);
        this.f_19804_.m_135372_(TICKS_UNTIL_CAN_PRESS_BUTTON, (Object)RandomGenerator.generateInt(200, 1200));
        this.f_19804_.m_135372_(IS_SPINNING_HEAD, (Object)false);
        this.f_19804_.m_135372_(IS_MOVING, (Object)false);
        this.f_19804_.m_135372_(TICKS_UNTIL_NEXT_HEAD_SPIN, (Object)RandomGenerator.generateInt(150, 300));
        this.f_19804_.m_135372_(BUTTON_PRESS_ANIMATION_PROGRESS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LAST_BUTTON_PRESS_ANIMATION_PROGRESS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HEAD_SPIN_ANIMATION_PROGRESS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LAST_HEAD_SPIN_ANIMATION_PROGRESS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ENTITY_SNAPSHOT, (Object)new CompoundTag());
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_(OXIDATION_LEVEL_NBT_NAME, this.getOxidationLevel().ordinal());
        nbt.m_128350_(BUTTON_PRESS_ANIMATION_PROGRESS_NBT_NAME, this.getButtonPressAnimationProgress());
        nbt.m_128350_(LAST_BUTTON_PRESS_ANIMATION_PROGRESS_NBT_NAME, this.getLastButtonPressAnimationProgress());
        nbt.m_128350_(HEAD_SPIN_ANIMATION_PROGRESS_NBT_NAME, this.getHeadSpinAnimationProgress());
        nbt.m_128350_(LAST_HEAD_SPIN_ANIMATION_PROGRESS_NBT_NAME, this.getLastHeadSpinAnimationProgress());
        nbt.m_128379_(IS_WAXED_NBT_NAME, this.isWaxed());
        nbt.m_128365_(ENTITY_SNAPSHOT_NBT_NAME, (Tag)this.getEntitySnapshot());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setOxidationLevel(WeatheringCopper.WeatherState.values()[nbt.m_128451_(OXIDATION_LEVEL_NBT_NAME)]);
        this.setIsWaxed(nbt.m_128471_(IS_WAXED_NBT_NAME));
        this.setButtonPressAnimationProgress(nbt.m_128457_(BUTTON_PRESS_ANIMATION_PROGRESS_NBT_NAME));
        this.setLastButtonPressAnimationProgress(nbt.m_128457_(LAST_BUTTON_PRESS_ANIMATION_PROGRESS_NBT_NAME));
        this.setHeadSpinAnimationProgress(nbt.m_128457_(HEAD_SPIN_ANIMATION_PROGRESS_NBT_NAME));
        this.setLastHeadSpinAnimationProgress(nbt.m_128457_(LAST_HEAD_SPIN_ANIMATION_PROGRESS_NBT_NAME));
        this.setEntitySnapshot(nbt.m_128469_(ENTITY_SNAPSHOT_NBT_NAME));
        this.applyEntitySnapshot();
    }

    public void setEntitySnapshot(CompoundTag entitySnapshot) {
        this.f_19804_.m_135381_(ENTITY_SNAPSHOT, (Object)entitySnapshot);
    }

    public void applyEntitySnapshot() {
        CompoundTag entitySnapshot = this.getEntitySnapshot();
        if (entitySnapshot.m_128456_()) {
            return;
        }
        this.f_20907_ = entitySnapshot.m_128459_("serverYaw");
        this.f_19859_ = entitySnapshot.m_128457_("prevYaw");
        this.m_146922_(this.f_19859_);
        this.f_19860_ = entitySnapshot.m_128457_("prevPitch");
        this.f_20908_ = this.f_19860_;
        this.m_146926_(this.f_19860_);
        this.f_20937_ = entitySnapshot.m_128451_("roll");
        this.f_20883_ = this.f_20884_ = entitySnapshot.m_128457_("prevBodyYaw");
        this.f_20933_ = entitySnapshot.m_128459_("serverHeadYaw");
        this.f_20885_ = this.f_20886_ = entitySnapshot.m_128457_("prevHeadYaw");
        this.f_20921_ = this.f_20920_ = entitySnapshot.m_128457_("lastHandSwingProgress");
        this.f_20924_ = this.f_20923_ = entitySnapshot.m_128457_("lastLimbDistance");
        this.f_20925_ = entitySnapshot.m_128457_("limbAngle");
        this.f_20894_ = this.f_20895_ = entitySnapshot.m_128457_("prevLookDirection");
        this.f_19797_ = entitySnapshot.m_128451_("age");
        this.f_20893_ = this.f_20892_ = entitySnapshot.m_128457_("prevStepBobbingAmount");
    }

    public CompoundTag getEntitySnapshot() {
        return (CompoundTag)this.f_19804_.m_135370_(ENTITY_SNAPSHOT);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_7324_(Entity entity) {
        if (this.isOxidized()) {
            return;
        }
        super.m_7324_(entity);
    }

    protected int m_7302_(int air) {
        return air;
    }

    public float m_6100_() {
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 2.5f;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModSounds.ENTITY_COPPER_GOLEM_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ENTITY_COPPER_GOLEM_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (this.isOxidized()) {
            return;
        }
        this.m_5496_((SoundEvent)ModSounds.ENTITY_COPPER_GOLEM_STEP.get(), 1.0f, this.m_6100_());
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() instanceof LightningBolt || source == DamageSource.f_19325_) {
            return false;
        }
        if (!this.f_19853_.f_46443_) {
            this.pressButtonGoal.m_8041_();
        }
        boolean damageResult = super.m_6469_(source, amount);
        if (this.isOxidized()) {
            CompoundTag entitySnapshot = this.getEntitySnapshot();
            this.f_20924_ = this.f_20923_ = entitySnapshot.m_128457_("lastLimbDistance");
            this.f_20925_ = entitySnapshot.m_128457_("limbAngle");
        }
        return damageResult;
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * 0.4, 0.0);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return 0.75f;
    }

    public float m_6113_() {
        return 0.35f - (float)this.getOxidationLevel().ordinal() * 0.05f;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        Item itemInHand = itemStack.m_41720_();
        boolean interactionResult = false;
        if (itemInHand == Items.f_151052_) {
            interactionResult = this.tryToInteractMobWithCopperIngot(player, itemStack);
        } else if (itemInHand == Items.f_42784_) {
            interactionResult = this.tryToInteractMobWithHoneycomb(player, itemStack);
        } else if (itemInHand instanceof AxeItem) {
            interactionResult = this.tryToInteractMobWithAxe(player, hand, itemStack);
        }
        if (interactionResult) {
            this.m_146859_(GameEvent.f_157771_, this.m_146901_());
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    private boolean tryToInteractMobWithCopperIngot(Player player, ItemStack itemStack) {
        if (this.m_21223_() == this.m_21233_()) {
            return false;
        }
        this.m_5634_(5.0f);
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        this.m_5496_((SoundEvent)ModSounds.ENTITY_COPPER_GOLEM_REPAIR.get(), 1.0f, this.m_6100_() - 1.0f);
        return true;
    }

    private boolean tryToInteractMobWithHoneycomb(Player player, ItemStack itemStack) {
        if (this.isWaxed() || this.isOxidized()) {
            return false;
        }
        this.setIsWaxed(true);
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        this.m_5496_(SoundEvents.f_144178_, 1.0f, 1.0f);
        this.spawnParticles((ParticleOptions)ParticleTypes.f_175828_, 7);
        return true;
    }

    private boolean tryToInteractMobWithAxe(Player player, InteractionHand hand, ItemStack itemStack) {
        if (!this.isWaxed() && !this.isDegraded()) {
            return false;
        }
        if (this.isWaxed()) {
            this.setIsWaxed(false);
            this.m_5496_(SoundEvents.f_144060_, 1.0f, 1.0f);
            this.spawnParticles((ParticleOptions)ParticleTypes.f_175829_, 7);
        } else if (this.isDegraded()) {
            if (!this.m_20193_().m_5776_()) {
                int increasedOxidationLevelOrdinal = this.getOxidationLevel().ordinal() - 1;
                WeatheringCopper.WeatherState[] OxidationLevels = WeatheringCopper.WeatherState.values();
                this.setOxidationLevel(OxidationLevels[increasedOxidationLevelOrdinal]);
            }
            this.m_5496_(SoundEvents.f_144059_, 1.0f, 1.0f);
            this.spawnParticles((ParticleOptions)ParticleTypes.f_175831_, 7);
        }
        if (!this.f_19853_.f_46443_ && !player.m_150110_().f_35937_) {
            itemStack.m_41622_(1, (LivingEntity)player, playerEntity -> player.m_21190_(hand));
        }
        return true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isOxidized()) {
            this.applyEntitySnapshot();
            return;
        }
        if (this.getTicksUntilCanPressButton() > 0) {
            this.setTicksUntilCanPressButton(this.getTicksUntilCanPressButton() - 1);
        }
        if (this.getTicksUntilNextHeadSpin() > 0) {
            this.setTicksUntilNextHeadSpin(this.getTicksUntilNextHeadSpin() - 1);
        }
        this.updateButtonPressAnimation();
        this.updateHeadSpinAnimation();
        if (!this.m_183503_().m_5776_()) {
            this.setIsMoving(this.m_21573_().m_26572_());
        }
        if (!this.isWaxed()) {
            this.handleOxidationIncrease();
        }
    }

    public void m_7023_(Vec3 movementInput) {
        if (!this.isOxidized()) {
            super.m_7023_(movementInput);
            return;
        }
        if (this.m_20193_().m_5776_()) {
            return;
        }
        this.applyGravityToTravel(movementInput);
    }

    private void applyGravityToTravel(Vec3 movementInput) {
        boolean bl;
        double d = 0.08;
        boolean bl2 = bl = this.m_20184_().f_82480_ <= 0.0;
        if (bl && this.m_21023_(MobEffects.f_19591_)) {
            d = 0.01;
            this.m_183634_();
        }
        if (!this.m_21255_()) {
            BlockPos blockPos = this.m_20099_();
            float p = this.f_19853_.m_8055_(blockPos).m_60734_().m_49958_();
            float f = this.f_19861_ ? p * 0.91f : 0.91f;
            Vec3 vec3d6 = this.m_21074_(movementInput, p);
            double q = vec3d6.f_82480_;
            if (this.m_21023_(MobEffects.f_19620_)) {
                q += (0.05 * (double)(this.m_21124_(MobEffects.f_19620_).m_19564_() + 1) - vec3d6.f_82480_) * 0.2;
                this.m_183634_();
            } else if (this.f_19853_.f_46443_ && !this.f_19853_.m_46805_(blockPos)) {
                q = this.m_20186_() > (double)this.f_19853_.m_141937_() ? -0.1 : 0.0;
            } else if (!this.m_20068_()) {
                q -= d;
            }
            if (this.m_147223_()) {
                this.m_20334_(vec3d6.f_82479_, q, vec3d6.f_82481_);
            } else {
                this.m_20334_(vec3d6.f_82479_ * (double)f, q * (double)0.98f, vec3d6.f_82481_ * (double)f);
            }
        }
    }

    public void m_6083_() {
        super.m_6083_();
        if (this.isOxidized()) {
            this.applyEntitySnapshot();
        }
    }

    public void m_8038_(ServerLevel serverWorld, LightningBolt lightning) {
        super.m_8038_(serverWorld, lightning);
        this.m_21153_(this.m_21233_());
        if (this.isDegraded()) {
            this.spawnParticles((ParticleOptions)ParticleTypes.f_175829_, 7);
        }
        if (!this.isWaxed() && !this.m_20193_().m_5776_()) {
            this.setOxidationLevel(WeatheringCopper.WeatherState.UNAFFECTED);
        }
    }

    private void updateButtonPressAnimation() {
        this.setLastButtonPressAnimationProgress(this.getButtonPressAnimationProgress());
        if (this.isPressingButton()) {
            this.setButtonPressAnimationProgress(Math.min(1.0f, this.getButtonPressAnimationProgress() + 0.2f));
        } else {
            this.setButtonPressAnimationProgress(Math.max(0.0f, this.getButtonPressAnimationProgress() - 0.2f));
        }
    }

    private void updateHeadSpinAnimation() {
        this.setLastHeadSpinAnimationProgress(this.getHeadSpinAnimationProgress());
        if (this.isSpinningHead()) {
            this.setHeadSpinAnimationProgress(Math.min(1.0f, this.getHeadSpinAnimationProgress() + 0.075f));
        } else {
            this.setHeadSpinAnimationProgress(0.0f);
        }
    }

    public void handleOxidationIncrease() {
        if (this.m_20193_().m_5776_() || this.isOxidized() || this.isWaxed()) {
            return;
        }
        if (RandomGenerator.generateRandomFloat() < 4.0E-5f) {
            int degradedOxidationLevelOrdinal = this.getOxidationLevel().ordinal() + 1;
            WeatheringCopper.WeatherState[] OxidationLevels = WeatheringCopper.WeatherState.values();
            this.setOxidationLevel(OxidationLevels[degradedOxidationLevelOrdinal]);
        }
    }

    public boolean isOxidized() {
        return this.getOxidationLevel() == WeatheringCopper.WeatherState.OXIDIZED;
    }

    public boolean isDegraded() {
        return this.getOxidationLevel().ordinal() > WeatheringCopper.WeatherState.UNAFFECTED.ordinal();
    }

    public WeatheringCopper.WeatherState getOxidationLevel() {
        return WeatheringCopper.WeatherState.values()[(Integer)this.f_19804_.m_135370_(OXIDATION_LEVEL)];
    }

    public void setOxidationLevel(WeatheringCopper.WeatherState OxidationLevel) {
        this.f_19804_.m_135381_(OXIDATION_LEVEL, (Object)OxidationLevel.ordinal());
        if (this.isOxidized() && !this.m_21525_()) {
            this.becomeStatue();
        } else if (!this.isOxidized() && this.m_21525_()) {
            this.becomeEntity();
        }
    }

    private void becomeStatue() {
        CompoundTag entitySnapshot = this.takeEntitySnapshot();
        this.setEntitySnapshot(entitySnapshot);
        this.m_21557_(true);
        for (WrappedGoal goal : this.f_21345_.m_25386_().toList()) {
            goal.m_8041_();
        }
        this.m_21573_().m_26517_(0.0);
        this.m_21573_().m_26573_();
        this.m_21566_().m_6849_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0);
        this.m_21566_().m_8126_();
        this.m_21563_().m_24946_(this.m_21563_().m_24969_(), this.m_21563_().m_24970_(), this.m_21563_().m_24971_());
        this.m_21563_().m_8128_();
        this.f_19850_ = false;
        this.f_20899_ = false;
        this.m_7910_(0.0f);
        this.f_19867_ = 0.0f;
        this.f_19787_ = 0.0f;
        this.f_20900_ = 0.0f;
        this.f_20901_ = 0.0f;
        this.m_20256_(Vec3.f_82478_);
        this.f_19812_ = true;
    }

    private void becomeEntity() {
        this.m_21557_(false);
        this.f_19850_ = true;
    }

    private CompoundTag takeEntitySnapshot() {
        CompoundTag entitySnapshot = new CompoundTag();
        entitySnapshot.m_128347_("serverYaw", this.f_20907_);
        entitySnapshot.m_128350_("prevYaw", this.f_19859_);
        entitySnapshot.m_128347_("serverPitch", this.f_20908_);
        entitySnapshot.m_128350_("prevPitch", this.f_19860_);
        entitySnapshot.m_128405_("roll", this.m_21256_());
        entitySnapshot.m_128350_("prevBodyYaw", this.f_20884_);
        entitySnapshot.m_128347_("serverHeadYaw", this.f_20933_);
        entitySnapshot.m_128350_("prevHeadYaw", this.f_20886_);
        entitySnapshot.m_128350_("lastHandSwingProgress", this.f_20920_);
        entitySnapshot.m_128350_("lastLimbDistance", this.f_20923_);
        entitySnapshot.m_128350_("limbAngle", this.f_20925_);
        entitySnapshot.m_128350_("prevLookDirection", this.f_20895_);
        entitySnapshot.m_128405_("age", this.f_19797_);
        entitySnapshot.m_128350_("tickDelta", ModelAnimationHelper.getTickDelta());
        entitySnapshot.m_128350_("prevStepBobbingAmount", this.f_20892_);
        return entitySnapshot;
    }

    public boolean isWaxed() {
        return (Boolean)this.f_19804_.m_135370_(IS_WAXED);
    }

    public void setIsWaxed(boolean isWaxed) {
        this.f_19804_.m_135381_(IS_WAXED, (Object)isWaxed);
    }

    public boolean isPressingButton() {
        return (Boolean)this.f_19804_.m_135370_(IS_PRESSING_BUTTON);
    }

    public void setIsPressingButton(boolean isPressingButton) {
        this.f_19804_.m_135381_(IS_PRESSING_BUTTON, (Object)isPressingButton);
    }

    public int getTicksUntilCanPressButton() {
        return (Integer)this.f_19804_.m_135370_(TICKS_UNTIL_CAN_PRESS_BUTTON);
    }

    public void setTicksUntilCanPressButton(int ticksUntilCanPressButton) {
        this.f_19804_.m_135381_(TICKS_UNTIL_CAN_PRESS_BUTTON, (Object)ticksUntilCanPressButton);
    }

    public boolean isSpinningHead() {
        return (Boolean)this.f_19804_.m_135370_(IS_SPINNING_HEAD);
    }

    public void setIsSpinningHead(boolean isSpinningHead) {
        this.f_19804_.m_135381_(IS_SPINNING_HEAD, (Object)isSpinningHead);
    }

    public boolean isMoving() {
        return (Boolean)this.f_19804_.m_135370_(IS_MOVING);
    }

    public void setIsMoving(boolean isMoving) {
        this.f_19804_.m_135381_(IS_MOVING, (Object)isMoving);
    }

    public int getTicksUntilNextHeadSpin() {
        return (Integer)this.f_19804_.m_135370_(TICKS_UNTIL_NEXT_HEAD_SPIN);
    }

    public void setTicksUntilNextHeadSpin(int ticksUntilNextHeadSpin) {
        this.f_19804_.m_135381_(TICKS_UNTIL_NEXT_HEAD_SPIN, (Object)ticksUntilNextHeadSpin);
    }

    public float getButtonPressAnimationProgress() {
        return ((Float)this.f_19804_.m_135370_(BUTTON_PRESS_ANIMATION_PROGRESS)).floatValue();
    }

    public void setButtonPressAnimationProgress(float buttonPressAnimationProgress) {
        this.f_19804_.m_135381_(BUTTON_PRESS_ANIMATION_PROGRESS, (Object)Float.valueOf(buttonPressAnimationProgress));
    }

    public float getLastButtonPressAnimationProgress() {
        return ((Float)this.f_19804_.m_135370_(LAST_BUTTON_PRESS_ANIMATION_PROGRESS)).floatValue();
    }

    public void setLastButtonPressAnimationProgress(float lastButtonPressAnimationProgress) {
        this.f_19804_.m_135381_(LAST_BUTTON_PRESS_ANIMATION_PROGRESS, (Object)Float.valueOf(lastButtonPressAnimationProgress));
    }

    public float getHeadSpinAnimationProgress() {
        return ((Float)this.f_19804_.m_135370_(HEAD_SPIN_ANIMATION_PROGRESS)).floatValue();
    }

    public void setHeadSpinAnimationProgress(float headSpinAnimationProgress) {
        this.f_19804_.m_135381_(HEAD_SPIN_ANIMATION_PROGRESS, (Object)Float.valueOf(headSpinAnimationProgress));
    }

    public float getLastHeadSpinAnimationProgress() {
        return ((Float)this.f_19804_.m_135370_(LAST_HEAD_SPIN_ANIMATION_PROGRESS)).floatValue();
    }

    public void setLastHeadSpinAnimationProgress(float lastHeadSpinAnimationProgress) {
        this.f_19804_.m_135381_(LAST_HEAD_SPIN_ANIMATION_PROGRESS, (Object)Float.valueOf(lastHeadSpinAnimationProgress));
    }

    public void spawnParticles(ParticleOptions particleEffect, int amount) {
        Level world = this.m_183503_();
        if (world.m_5776_()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((ServerLevel)world).m_8767_(particleEffect, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 1, this.m_21187_().nextGaussian() * 0.02, this.m_21187_().nextGaussian() * 0.02, this.m_21187_().nextGaussian() * 0.02, 1.0);
        }
    }

    public void setSpawnYaw(float yaw) {
        this.f_20907_ = yaw;
        this.f_19859_ = yaw;
        this.m_146922_(yaw);
        this.f_20884_ = yaw;
        this.f_20883_ = yaw;
        this.f_20933_ = yaw;
        this.f_20886_ = yaw;
        this.f_20885_ = yaw;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationTickTracker == null) {
            this.animationTickTracker = new AnimationContextTracker();
        }
        return this.animationTickTracker;
    }

    static {
        TICKS_UNTIL_CAN_PRESS_BUTTON = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        IS_SPINNING_HEAD = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        IS_MOVING = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        TICKS_UNTIL_NEXT_HEAD_SPIN = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        BUTTON_PRESS_ANIMATION_PROGRESS = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        LAST_BUTTON_PRESS_ANIMATION_PROGRESS = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        HEAD_SPIN_ANIMATION_PROGRESS = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        LAST_HEAD_SPIN_ANIMATION_PROGRESS = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        ENTITY_SNAPSHOT = SynchedEntityData.m_135353_(CopperGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
        NOTICEABLE_PLAYER_FILTER = entity -> {
            Player player = (Player)entity;
            ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item itemInHand = itemStack.m_41720_();
            return itemInHand instanceof AxeItem && EntitySelector.f_20406_.test(player);
        };
    }
}

