/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.forge;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.FriendsAndFoesServer;
import com.faboslav.friendsandfoes.forge.FriendsAndFoesForgeClient;
import com.faboslav.friendsandfoes.init.ModEntity;
import com.faboslav.friendsandfoes.util.ServerWorldSpawnersUtil;
import com.faboslav.friendsandfoes.world.spawner.IceologerSpawner;
import com.faboslav.friendsandfoes.world.spawner.IllusionerSpawner;
import dev.architectury.platform.Platform;
import dev.architectury.platform.forge.EventBuses;
import dev.architectury.utils.Env;
import net.minecraft.Util;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="friendsandfoes")
@Mod.EventBusSubscriber(modid="friendsandfoes", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class FriendsAndFoesForge {
    public FriendsAndFoesForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        EventBuses.registerModEventBus((String)"friendsandfoes", (IEventBus)modEventBus);
        FriendsAndFoes.initRegisters();
        FriendsAndFoesForgeClient.init();
        modEventBus.addListener(FriendsAndFoesForge::init);
        modEventBus.addListener(FriendsAndFoesForgeClient::clientInit);
        modEventBus.addListener(FriendsAndFoesForge::serverInit);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(FriendsAndFoesForge::initSpawners);
        forgeBus.addListener(FriendsAndFoesForge::initTickDeltaCounter);
    }

    private static void init(FMLCommonSetupEvent event) {
        FriendsAndFoes.initCustomRegisters();
        if (FriendsAndFoes.getConfig().enableIllusionerInRaids) {
            Raid.RaiderType.create((String)"ILLUSIONER", (EntityType)EntityType.f_20459_, (int[])new int[]{0, 0, 0, 0, 1, 0, 1, 1});
        }
        if (FriendsAndFoes.getConfig().enableIceologerInRaids) {
            Raid.RaiderType.create((String)"ICEOLOGER", (EntityType)((EntityType)ModEntity.ICEOLOGER.get()), (int[])new int[]{0, 0, 0, 0, 1, 1, 0, 1});
        }
    }

    private static void serverInit(FMLDedicatedServerSetupEvent event) {
        event.enqueueWork(() -> {
            if (Platform.getEnvironment() != Env.SERVER) {
                return;
            }
            FriendsAndFoesServer.init();
        });
    }

    private static void initSpawners(WorldEvent.Load event) {
        if (event.getWorld().m_5776_() || event.getWorld().m_6042_().m_63969_() != DimensionType.f_63840_) {
            return;
        }
        ServerLevel world = event.getWorld().m_142572_().m_129783_();
        if (world == null) {
            return;
        }
        ServerWorldSpawnersUtil.register(world, new IceologerSpawner());
        ServerWorldSpawnersUtil.register(world, new IllusionerSpawner());
    }

    private static void initTickDeltaCounter(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        FriendsAndFoes.serverTickDeltaCounter.beginRenderTick(Util.m_137550_());
    }
}

