/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.mixin;

import com.faboslav.friendsandfoes.init.ModBlocks;
import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={HoneycombItem.class})
public abstract class HoneycombItemMixin {
    private static final Supplier<BiMap<Block, Block>> UNWAXED_TO_WAXED_BUTTON_BLOCKS = Suppliers.memoize(() -> ImmutableBiMap.builder().put(ModBlocks.COPPER_BUTTON.get(), ModBlocks.WAXED_COPPER_BUTTON.get()).put(ModBlocks.EXPOSED_COPPER_BUTTON.get(), ModBlocks.WAXED_EXPOSED_COPPER_BUTTON.get()).put(ModBlocks.WEATHERED_COPPER_BUTTON.get(), ModBlocks.WAXED_WEATHERED_COPPER_BUTTON.get()).put(ModBlocks.OXIDIZED_COPPER_BUTTON.get(), ModBlocks.WAXED_OXIDIZED_COPPER_BUTTON.get()).build());

    @Inject(method={"getWaxedState"}, at={@At(value="RETURN")}, cancellable=true)
    private static void getWaxedState(BlockState state, CallbackInfoReturnable<Optional<BlockState>> cir) {
        Optional<BlockState> blockState = (Optional<BlockState>)cir.getReturnValue();
        if (blockState.isPresent()) {
            cir.setReturnValue((Object)blockState);
        }
        blockState = Optional.ofNullable((Block)UNWAXED_TO_WAXED_BUTTON_BLOCKS.get().get((Object)state.m_60734_())).map(block -> block.m_152465_(state));
        cir.setReturnValue(blockState);
    }
}

