/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.mixin;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.faboslav.friendsandfoes.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.init.ModEntity;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.WeatheringCopperFullBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightningRodBlock.class})
public abstract class LightningRodBlockMixin
extends RodBlock {
    @Nullable
    private BlockPattern copperGolemPattern;
    private static final Predicate<BlockState> IS_GOLEM_LIGHTNING_ROD_PREDICATE = state -> state != null && state == Blocks.f_152587_.m_49966_().m_61124_((Property)LightningRodBlock.f_52588_, (Comparable)Direction.UP);
    private static final Predicate<BlockState> IS_GOLEM_HEAD_PREDICATE = state -> state != null && (state.m_60713_(Blocks.f_50143_) || state.m_60713_(Blocks.f_50144_));
    private static final Predicate<BlockState> IS_GOLEM_BODY_PREDICATE = state -> state != null && (state.m_60713_(Blocks.f_152504_) || state.m_60713_(Blocks.f_152502_) || state.m_60713_(Blocks.f_152503_) || state.m_60713_(Blocks.f_152501_) || state.m_60713_(Blocks.f_152571_) || state.m_60713_(Blocks.f_152572_) || state.m_60713_(Blocks.f_152573_) || state.m_60713_(Blocks.f_152574_));

    protected LightningRodBlockMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @Inject(method={"onBlockAdded"}, at={@At(value="HEAD")})
    private void customOnBlockAdded(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean notify, CallbackInfo ci) {
        if (!oldState.m_60713_(state.m_60734_())) {
            this.tryToSpawnCopperGolem(world, pos);
        }
    }

    private void tryToSpawnCopperGolem(Level world, BlockPos pos) {
        if (!FriendsAndFoes.getConfig().enableCopperGolem) {
            return;
        }
        BlockPattern.BlockPatternMatch patternSearchResult = this.getCopperGolemPattern().m_61184_((LevelReader)world, pos);
        if (patternSearchResult == null) {
            return;
        }
        BlockState headBlockState = patternSearchResult.m_61229_(0, 1, 0).m_61168_();
        BlockState bodyBlockState = patternSearchResult.m_61229_(0, 2, 0).m_61168_();
        for (int i = 0; i < this.getCopperGolemPattern().m_61202_(); ++i) {
            BlockInWorld cachedBlockPosition = patternSearchResult.m_61229_(0, i, 0);
            world.m_7731_(cachedBlockPosition.m_61176_(), Blocks.f_50016_.m_49966_(), 2);
            world.m_46796_(2001, cachedBlockPosition.m_61176_(), Block.m_49956_((BlockState)cachedBlockPosition.m_61168_()));
        }
        BlockPos cachedBlockPosition = patternSearchResult.m_61229_(0, 2, 0).m_61176_();
        float copperGolemYaw = ((Direction)headBlockState.m_61143_((Property)CarvedPumpkinBlock.f_51367_)).m_122435_();
        CopperGolemEntity copperGolemEntity = (CopperGolemEntity)((EntityType)ModEntity.COPPER_GOLEM.get()).m_20615_(world);
        copperGolemEntity.m_6034_((double)cachedBlockPosition.m_123341_() + 0.5, (double)cachedBlockPosition.m_123342_() + 0.05, (double)cachedBlockPosition.m_123343_() + 0.5);
        copperGolemEntity.setSpawnYaw(copperGolemYaw);
        world.m_7967_((Entity)copperGolemEntity);
        WeatheringCopper.WeatherState oxidationLevel = bodyBlockState.m_60713_(Blocks.f_152571_) ? WeatheringCopper.WeatherState.UNAFFECTED : (bodyBlockState.m_60713_(Blocks.f_152572_) ? WeatheringCopper.WeatherState.WEATHERED : (bodyBlockState.m_60713_(Blocks.f_152573_) ? WeatheringCopper.WeatherState.EXPOSED : (bodyBlockState.m_60713_(Blocks.f_152574_) ? WeatheringCopper.WeatherState.OXIDIZED : ((WeatheringCopperFullBlock)bodyBlockState.m_60734_()).m_142297_())));
        copperGolemEntity.setOxidationLevel(oxidationLevel);
        copperGolemEntity.setIsWaxed(this.isCopperBlockWaxed(bodyBlockState));
        for (ServerPlayer serverPlayerEntity : world.m_45976_(ServerPlayer.class, copperGolemEntity.m_142469_().m_82400_(5.0))) {
            CriteriaTriggers.f_10580_.m_68256_(serverPlayerEntity, (Entity)copperGolemEntity);
        }
        for (int j = 0; j < this.getCopperGolemPattern().m_61202_(); ++j) {
            BlockInWorld cachedBlockPosition2 = patternSearchResult.m_61229_(0, j, 0);
            world.m_6289_(cachedBlockPosition2.m_61176_(), Blocks.f_50016_);
        }
    }

    private BlockPattern getCopperGolemPattern() {
        if (this.copperGolemPattern == null) {
            this.copperGolemPattern = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"|", "^", "#"}).m_61244_('|', BlockInWorld.m_61169_(IS_GOLEM_LIGHTNING_ROD_PREDICATE)).m_61244_('^', BlockInWorld.m_61169_(IS_GOLEM_HEAD_PREDICATE)).m_61244_('#', BlockInWorld.m_61169_(IS_GOLEM_BODY_PREDICATE)).m_61249_();
        }
        return this.copperGolemPattern;
    }

    private boolean isCopperBlockWaxed(BlockState blockState) {
        return blockState.m_60713_(Blocks.f_152571_) || blockState.m_60713_(Blocks.f_152572_) || blockState.m_60713_(Blocks.f_152573_) || blockState.m_60713_(Blocks.f_152574_);
    }
}

