/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.world.gen.feature;

import com.faboslav.friendsandfoes.FriendsAndFoes;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.JigsawFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.structure.BuiltinStructureSets;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;

public final class IllusionerShackFeature
extends JigsawFeature {
    public IllusionerShackFeature(Codec<JigsawConfiguration> configCodec) {
        super(configCodec, 0, true, true, IllusionerShackFeature::canGenerate);
    }

    private static boolean canGenerate(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        return FriendsAndFoes.getConfig().generateIllusionerShackStructure && !IllusionerShackFeature.isVillageNearby(context) && IllusionerShackFeature.isSuitableChunk(context);
    }

    private static boolean isVillageNearby(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        int chunkPosX = context.f_197355_().f_45578_;
        int chunkPosZ = context.f_197355_().f_45579_;
        return context.f_197352_().m_212265_(BuiltinStructureSets.f_209820_, context.f_197354_(), chunkPosX, chunkPosZ, 10);
    }

    private static boolean isSuitableChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        int i = context.f_197355_().f_45578_ >> 4;
        int j = context.f_197355_().f_45579_ >> 4;
        WorldgenRandom chunkRandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        chunkRandom.setSeed((long)(i ^ j << 4) ^ context.f_197354_());
        chunkRandom.nextInt();
        BlockPos blockpos = context.f_197355_().m_151394_(0);
        int topLandY = context.f_197352_().m_142647_(blockpos.m_123341_(), blockpos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
        return topLandY >= 80;
    }

    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }
}

