/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.block;

import java.util.Random;
import mod.schnappdragon.habitat.common.block.SlimeFernBlock;
import mod.schnappdragon.habitat.common.block.WallSlimeFernBlock;
import mod.schnappdragon.habitat.core.registry.HabitatBlocks;
import mod.schnappdragon.habitat.core.registry.HabitatParticleTypes;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractSlimeFernBlock
extends Block
implements IGrowable {
    public AbstractSlimeFernBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public void func_180655_c(BlockState state, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextInt(10) == 0) {
            VoxelShape voxelshape = this.func_220053_a(state, (IBlockReader)worldIn, pos, ISelectionContext.func_216377_a());
            Vector3d vector3d = voxelshape.func_197752_a().func_189972_c();
            double X = (double)pos.func_177958_n() + vector3d.field_72450_a;
            double Y = (double)pos.func_177956_o() + vector3d.field_72448_b;
            double Z = (double)pos.func_177952_p() + vector3d.field_72449_c;
            worldIn.func_195594_a((IParticleData)HabitatParticleTypes.FALLING_SLIME.get(), X + (2.0 * rand.nextDouble() - 1.0) / 2.5, Y - rand.nextDouble() / 5.0, Z + (2.0 * rand.nextDouble() - 1.0) / 2.5, 0.0, 0.0, 0.0);
        }
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        double motionY;
        if (entityIn.func_200600_R() != EntityType.field_200743_ai && (motionY = Math.abs(entityIn.func_213322_ci().field_72448_b)) < 0.1 && !entityIn.func_226271_bk_()) {
            double slowedMotion = 0.4 + motionY * 0.2;
            entityIn.func_213317_d(entityIn.func_213322_ci().func_216372_d(slowedMotion, 1.0, slowedMotion));
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        if (!isClient) {
            ChunkPos chunkPos = new ChunkPos(pos);
            return SharedSeedRandom.func_205190_a((int)chunkPos.field_77276_a, (int)chunkPos.field_77275_b, (long)((ISeedReader)worldIn).func_72905_C(), (long)987234911L).nextInt(10) == 0;
        }
        return false;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        Direction[] directions = new Direction[]{Direction.DOWN, Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.UP};
        block0: for (int j = 0; j < 3; ++j) {
            blockpos$mutable.func_239621_a_((Vector3i)pos, MathHelper.func_76136_a((Random)rand, (int)1, (int)2) - MathHelper.func_76136_a((Random)rand, (int)1, (int)2), MathHelper.func_76136_a((Random)rand, (int)1, (int)2) - MathHelper.func_76136_a((Random)rand, (int)1, (int)2), MathHelper.func_76136_a((Random)rand, (int)1, (int)2) - MathHelper.func_76136_a((Random)rand, (int)1, (int)2));
            if (!worldIn.func_175623_d((BlockPos)blockpos$mutable) && !worldIn.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76222_j()) continue;
            for (Direction dir : directions) {
                if (!worldIn.func_180495_p(blockpos$mutable.func_177972_a(dir)).func_224755_d((IBlockReader)worldIn, (BlockPos)blockpos$mutable, dir.func_176734_d())) continue;
                BlockState state1 = ((Block)HabitatBlocks.SLIME_FERN.get()).func_176223_P();
                if (dir == Direction.UP) {
                    state1 = (BlockState)state1.func_206870_a((Property)SlimeFernBlock.ON_CEILING, (Comparable)Boolean.valueOf(true));
                } else if (dir != Direction.DOWN) {
                    state1 = (BlockState)((Block)HabitatBlocks.WALL_SLIME_FERN.get()).func_176223_P().func_206870_a((Property)WallSlimeFernBlock.HORIZONTAL_FACING, (Comparable)dir.func_176734_d());
                }
                worldIn.func_180501_a((BlockPos)blockpos$mutable, state1, 3);
                continue block0;
            }
        }
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }
}

