/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.block;

import java.util.Random;
import java.util.function.Supplier;
import mod.schnappdragon.habitat.common.block.HabitatFlowerBlock;
import mod.schnappdragon.habitat.common.block.misc.BallCactusColor;
import mod.schnappdragon.habitat.core.tags.HabitatBlockTags;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.potion.Effect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BallCactusFlowerBlock
extends HabitatFlowerBlock
implements IGrowable {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);
    private final BallCactusColor color;

    public BallCactusFlowerBlock(BallCactusColor colorIn, Supplier<Effect> stewEffect, int stewEffectDuration, AbstractBlock.Properties properties) {
        super(stewEffect, stewEffectDuration, properties);
        this.color = colorIn;
    }

    public BallCactusColor getColor() {
        return this.color;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public AbstractBlock.OffsetType func_176218_Q() {
        return AbstractBlock.OffsetType.NONE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_235714_a_(HabitatBlockTags.BALL_CACTUS_FLOWER_PLACEABLE_ON) || worldIn.func_180495_p(pos.func_177977_b()).func_235714_a_(HabitatBlockTags.BALL_CACTUS_PLANTABLE_ON);
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (this.canGrow((World)worldIn, pos) && random.nextInt(10) == 0) {
            worldIn.func_175656_a(pos, this.color.getGrowingBallCactus().func_176223_P());
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return this.canGrow((World)worldIn, pos);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return this.canGrow(worldIn, pos);
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        worldIn.func_175656_a(pos, (rand.nextBoolean() ? this.color.getGrowingBallCactus() : this.color.getBallCactus()).func_176223_P());
    }

    public boolean canGrow(World worldIn, BlockPos pos) {
        return !worldIn.func_180495_p(pos.func_177977_b()).func_235714_a_(HabitatBlockTags.BALL_CACTUS_FLOWER_PLACEABLE_ON);
    }
}

