/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.block;

import java.util.Random;
import mod.schnappdragon.habitat.common.block.state.properties.HabitatBlockStateProperties;
import mod.schnappdragon.habitat.common.entity.monster.PookaEntity;
import mod.schnappdragon.habitat.core.registry.HabitatConfiguredFeatures;
import mod.schnappdragon.habitat.core.registry.HabitatItems;
import mod.schnappdragon.habitat.core.registry.HabitatParticleTypes;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.server.ServerWorld;

public class FairyRingMushroomBlock
extends BushBlock
implements IGrowable {
    protected static final VoxelShape[] SHAPE = new VoxelShape[]{Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};
    public static final IntegerProperty MUSHROOMS = HabitatBlockStateProperties.MUSHROOMS_1_4;
    public static final BooleanProperty DUSTED = HabitatBlockStateProperties.DUSTED;

    public FairyRingMushroomBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)MUSHROOMS, (Comparable)Integer.valueOf(1))).func_206870_a((Property)DUSTED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{MUSHROOMS, DUSTED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE[(Integer)state.func_177229_b((Property)MUSHROOMS) - 1];
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_200015_d((IBlockReader)worldIn, pos.func_177977_b());
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn.func_200600_R() == EntityType.field_200736_ab) {
            RabbitEntity rabbit = (RabbitEntity)entityIn;
            rabbit.func_184185_a((SoundEvent)HabitatSoundEvents.ENTITY_RABBIT_CONVERTED_TO_POOKA.get(), 1.0f, rabbit.func_70631_g_() ? (rabbit.func_70681_au().nextFloat() - rabbit.func_70681_au().nextFloat()) * 0.2f + 1.5f : (rabbit.func_70681_au().nextFloat() - rabbit.func_70681_au().nextFloat()) * 0.2f + 1.0f);
            rabbit.func_70106_y();
            worldIn.func_217376_c((Entity)PookaEntity.convertRabbit(rabbit));
            for (int i = 0; i < 8; ++i) {
                ((ServerWorld)worldIn).func_195598_a((IParticleData)HabitatParticleTypes.FAIRY_RING_SPORE.get(), rabbit.func_226282_d_(0.5), rabbit.func_226283_e_(0.5), rabbit.func_226287_g_(0.5), 0, rabbit.func_70681_au().nextGaussian(), 0.0, rabbit.func_70681_au().nextGaussian(), 0.01);
            }
        }
    }

    public void func_180655_c(BlockState state, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((Property)DUSTED)).booleanValue() && rand.nextInt(18 - 2 * (Integer)state.func_177229_b((Property)MUSHROOMS)) == 0) {
            worldIn.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o() + rand.nextDouble(), (double)pos.func_177952_p() + rand.nextDouble(), 0.0, 0.0, 0.0);
        }
        if (rand.nextInt(9 - (Integer)state.func_177229_b((Property)MUSHROOMS)) == 0) {
            worldIn.func_195594_a((IParticleData)HabitatParticleTypes.FAIRY_RING_SPORE.get(), (double)pos.func_177958_n() + rand.nextDouble(), (double)pos.func_177956_o() + rand.nextDouble(), (double)pos.func_177952_p() + rand.nextDouble(), rand.nextGaussian() * 0.01, 0.0, rand.nextGaussian() * 0.01);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (player.func_184586_b(handIn).func_77973_b() instanceof ShearsItem && (Integer)state.func_177229_b((Property)MUSHROOMS) > 1) {
            FairyRingMushroomBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)this.getBlock()));
            player.func_184586_b(handIn).func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)MUSHROOMS, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)MUSHROOMS) - 1)), 2);
            worldIn.func_184133_a(null, pos, (SoundEvent)HabitatSoundEvents.BLOCK_FAIRY_RING_MUSHROOM_SHEAR.get(), SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        if (player.func_184586_b(handIn).func_77973_b() == HabitatItems.FAIRY_RING_MUSHROOM.get() && (Integer)state.func_177229_b((Property)MUSHROOMS) < 4) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184586_b(handIn).func_190918_g(1);
            }
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)MUSHROOMS, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)MUSHROOMS) + 1)), 2);
            worldIn.func_184133_a(null, pos, SoundType.field_185850_c.func_185841_e(), SoundCategory.BLOCKS, SoundType.field_185850_c.func_185843_a() + 0.5f, SoundType.field_185850_c.func_185847_b() * 0.8f);
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        if (player.func_184586_b(handIn).func_77973_b() == Items.field_151137_ax && !((Boolean)state.func_177229_b((Property)DUSTED)).booleanValue()) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184586_b(handIn).func_190918_g(1);
            }
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)DUSTED, (Comparable)Boolean.valueOf(true)), 2);
            worldIn.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.125, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
            worldIn.func_184133_a(null, pos, (SoundEvent)HabitatSoundEvents.BLOCK_FAIRY_RING_MUSHROOM_DUST.get(), SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public int func_180656_a(BlockState state, IBlockReader worldIn, BlockPos pos, Direction side) {
        return (Boolean)state.func_177229_b((Property)DUSTED) != false ? (Integer)state.func_177229_b((Property)MUSHROOMS) : 0;
    }

    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((Property)MUSHROOMS) < 4 && (Boolean)state.func_177229_b((Property)DUSTED) == false;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if ((Integer)state.func_177229_b((Property)MUSHROOMS) < 4 && random.nextInt(25) == 0) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)MUSHROOMS, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)MUSHROOMS) + 1)), 2);
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Boolean)state.func_177229_b((Property)DUSTED) == false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        if ((Boolean)state.func_177229_b((Property)DUSTED) != false) return false;
        if ((Integer)state.func_177229_b((Property)MUSHROOMS) != 4) return true;
        float f = rand.nextFloat();
        float f2 = worldIn.func_180495_p(pos.func_177977_b()).func_235714_a_((ITag)BlockTags.field_242171_aD) ? 0.8f : 0.4f;
        if (!(f < f2)) return false;
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        if ((Integer)state.func_177229_b((Property)MUSHROOMS) < 4) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)MUSHROOMS, (Comparable)Integer.valueOf(Math.min(4, (Integer)state.func_177229_b((Property)MUSHROOMS) + MathHelper.func_76136_a((Random)rand, (int)1, (int)2)))), 2);
        } else {
            this.growHugeMushroom(worldIn, rand, pos, state);
        }
    }

    private void growHugeMushroom(ServerWorld world, Random rand, BlockPos pos, BlockState state) {
        world.func_217377_a(pos, false);
        ConfiguredFeature<?, ?> configuredfeature = HabitatConfiguredFeatures.HUGE_FAIRY_RING_MUSHROOM;
        if (!configuredfeature.func_242765_a((ISeedReader)world, world.func_72863_F().func_201711_g(), rand, pos)) {
            world.func_180501_a(pos, state, 3);
        }
    }
}

