/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.block;

import java.util.Random;
import javax.annotation.Nullable;
import mod.schnappdragon.habitat.common.block.IHasPistonDestroyEffect;
import mod.schnappdragon.habitat.common.entity.projectile.KabloomFruitEntity;
import mod.schnappdragon.habitat.core.registry.HabitatItems;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ToolItem;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;

public class KabloomBushBlock
extends BushBlock
implements IGrowable,
IHasPistonDestroyEffect {
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)9.0, (double)15.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0), Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0)};
    public static final IntegerProperty AGE = BlockStateProperties.field_208170_W;

    public KabloomBushBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[(Integer)state.func_177229_b((Property)AGE)];
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn.func_200600_R() != EntityType.field_226289_e_) {
            if (entityIn instanceof LivingEntity && (Integer)state.func_177229_b((Property)AGE) > 1) {
                entityIn.func_213295_a(state, new Vector3d((double)0.95f, 0.9, (double)0.95f));
            }
            if ((Integer)state.func_177229_b((Property)AGE) == 7) {
                this.dropFruit(state, worldIn, pos, entityIn instanceof ProjectileEntity ? ((ProjectileEntity)entityIn).func_234616_v_() : entityIn, true, false);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if ((Integer)state.func_177229_b((Property)AGE) == 7) {
            if (player.func_184586_b(handIn).func_77973_b() instanceof ShearsItem) {
                KabloomBushBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)HabitatItems.KABLOOM_FRUIT.get(), 1));
                player.func_184586_b(handIn).func_222118_a(1, (LivingEntity)player, playerIn -> playerIn.func_213334_d(handIn));
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(3)), 2);
                worldIn.func_184133_a(null, pos, (SoundEvent)HabitatSoundEvents.BLOCK_KABLOOM_BUSH_SHEAR.get(), SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            } else {
                this.dropFruit(state, worldIn, pos, (Entity)player, true, false);
            }
            return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void catchFire(BlockState state, World worldIn, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        if ((Integer)state.func_177229_b((Property)AGE) == 7) {
            this.dropFruit(state, worldIn, pos, (Entity)igniter, true, true);
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        ItemStack held = player.func_184614_ca();
        if (!((Integer)state.func_177229_b((Property)AGE) != 7 || player.field_71075_bZ.field_75098_d || held.func_77973_b() instanceof ShearsItem || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)held) != 0 && held.func_77973_b() instanceof ToolItem)) {
            this.dropFruit(state, worldIn, pos, (Entity)player, false, false);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Override
    public void onPistonDestroy(World worldIn, BlockPos pos, BlockState state) {
        if ((Integer)state.func_177229_b((Property)AGE) == 7) {
            this.dropFruit(state, worldIn, pos, null, false, false);
        }
    }

    private void dropFruit(BlockState state, World worldIn, BlockPos pos, @Nullable Entity activator, boolean replaceBush, boolean setFire) {
        if (!worldIn.field_72995_K) {
            if (replaceBush) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(3)), 2);
                worldIn.func_184133_a(null, pos, (SoundEvent)HabitatSoundEvents.BLOCK_KABLOOM_BUSH_RUSTLE.get(), SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            }
            KabloomFruitEntity kabloom = new KabloomFruitEntity(worldIn, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.6f, (float)pos.func_177952_p() + 0.5f);
            kabloom.func_212361_a(activator);
            if (setFire) {
                kabloom.func_70015_d(8);
            }
            worldIn.func_217376_c((Entity)kabloom);
        }
    }

    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((Property)AGE) < 7;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if ((Integer)state.func_177229_b((Property)AGE) < 7 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt(5) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf((Integer)state.func_177229_b((Property)AGE) + 1)), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((Property)AGE) < 7;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(Math.min(7, (Integer)state.func_177229_b((Property)AGE) + MathHelper.func_76136_a((Random)rand, (int)2, (int)4)))), 2);
    }

    public PlantType getPlantType(IBlockReader world, BlockPos pos) {
        return PlantType.PLAINS;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return (Integer)state.func_177229_b((Property)AGE) > 1 ? PathNodeType.DANGER_OTHER : null;
    }
}

