/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.block;

import javax.annotation.Nullable;
import mod.schnappdragon.habitat.common.block.IHasPistonDestroyEffect;
import mod.schnappdragon.habitat.common.entity.projectile.KabloomFruitEntity;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.PushReaction;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class KabloomFruitPileBlock
extends Block
implements IHasPistonDestroyEffect {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public KabloomFruitPileBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        this.explode(worldIn, pos, entityIn instanceof ProjectileEntity ? ((ProjectileEntity)entityIn).func_234616_v_() : entityIn, true, false);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        this.explode(worldIn, pos, (Entity)player, true, false);
        return ActionResultType.func_233537_a_((boolean)worldIn.field_72995_K);
    }

    public void catchFire(BlockState state, World worldIn, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        this.explode(worldIn, pos, (Entity)igniter, true, true);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        this.explode(worldIn, pos, null, false, false);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        ItemStack held = player.func_184614_ca();
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)held) == 0 || !(held.func_77973_b() instanceof ToolItem)) {
            this.explode(worldIn, pos, (Entity)player, false, false);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Override
    public void onPistonDestroy(World worldIn, BlockPos pos, BlockState state) {
        this.explode(worldIn, pos, null, false, false);
    }

    private void explode(World worldIn, BlockPos pos, @Nullable Entity activator, boolean destroyBlock, boolean setFire) {
        if (!worldIn.field_72995_K) {
            if (destroyBlock) {
                worldIn.func_175655_b(pos, false);
            }
            worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), (SoundEvent)HabitatSoundEvents.ENTITY_KABLOOM_FRUIT_EXPLODE.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.2f, true);
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197627_t, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 1.0, 0.0, 0.0);
            for (int i = 1; i <= 9; ++i) {
                KabloomFruitEntity kabloom = new KabloomFruitEntity(worldIn, (float)pos.func_177958_n() + worldIn.field_73012_v.nextFloat(), (float)pos.func_177956_o() + worldIn.field_73012_v.nextFloat(), (float)pos.func_177952_p() + worldIn.field_73012_v.nextFloat());
                kabloom.func_212361_a(activator);
                if (setFire) {
                    kabloom.func_70015_d(8);
                }
                worldIn.func_217376_c((Entity)kabloom);
            }
        }
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.DANGER_OTHER;
    }
}

