/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nullable;
import mod.schnappdragon.habitat.common.block.state.properties.HabitatBlockStateProperties;
import mod.schnappdragon.habitat.common.tileentity.RafflesiaTileEntity;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import mod.schnappdragon.habitat.core.tags.HabitatBlockTags;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.extensions.IForgeBlock;

public class RafflesiaBlock
extends BushBlock
implements IForgeBlock,
IGrowable {
    protected static final VoxelShape DEFAULT_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)16.0);
    protected static final VoxelShape COOLDOWN_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    public static final BooleanProperty ON_COOLDOWN = HabitatBlockStateProperties.ON_COOLDOWN;
    public static final BooleanProperty HAS_STEW = HabitatBlockStateProperties.HAS_STEW;

    public RafflesiaBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)ON_COOLDOWN, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HAS_STEW, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{ON_COOLDOWN, HAS_STEW});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (((Boolean)state.func_177229_b((Property)ON_COOLDOWN)).booleanValue()) {
            return COOLDOWN_SHAPE;
        }
        return DEFAULT_SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_235714_a_(HabitatBlockTags.RAFFLESIA_PLANTABLE_ON);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader worldIn) {
        return new RafflesiaTileEntity();
    }

    public void func_180655_c(BlockState state, World worldIn, BlockPos pos, Random rand) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof RafflesiaTileEntity && rand.nextInt(128) == 0 && !((Boolean)state.func_177229_b((Property)ON_COOLDOWN)).booleanValue()) {
            RafflesiaTileEntity rafflesia = (RafflesiaTileEntity)tile;
            double X = (double)pos.func_177958_n() + 0.5;
            double Z = (double)pos.func_177952_p() + 0.5;
            worldIn.func_195594_a(this.getParticle(rafflesia.Effects), X + (2.0 * rand.nextDouble() - 1.0) / 3.0, (double)((float)pos.func_177956_o() + 0.25f) + rand.nextDouble() / 2.0, Z + (2.0 * rand.nextDouble() - 1.0) / 3.0, 0.0, 0.01, 0.0);
        }
    }

    private void createCloud(World worldIn, BlockPos pos, ListNBT effects) {
        AreaEffectCloudEntity cloud = new AreaEffectCloudEntity(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.25, (double)pos.func_177952_p() + 0.5);
        cloud.func_184486_b(50);
        cloud.func_184483_a(1.0f);
        cloud.func_195059_a(this.getParticle(effects));
        for (int i = 0; i < effects.size(); ++i) {
            Effect effect;
            int j = 160;
            CompoundNBT tag = effects.func_150305_b(i);
            if (tag.func_150297_b("EffectDuration", 3)) {
                j = tag.func_74762_e("EffectDuration");
            }
            if ((effect = Effect.func_188412_a((int)tag.func_74771_c("EffectId"))) == null) continue;
            cloud.func_184496_a(new EffectInstance(effect, j));
        }
        worldIn.func_184133_a(null, pos, (SoundEvent)HabitatSoundEvents.BLOCK_RAFFLESIA_SPEW.get(), SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
        worldIn.func_217376_c((Entity)cloud);
    }

    private IParticleData getParticle(ListNBT effects) {
        ArrayList effectInstances = Lists.newArrayList();
        for (int i = 0; i < effects.size(); ++i) {
            int j = 160;
            CompoundNBT tag = effects.func_150305_b(i);
            Effect effect = Effect.func_188412_a((int)tag.func_74771_c("EffectId"));
            if (effect == null) continue;
            effectInstances.add(new EffectInstance(effect, j));
        }
        int color = PotionUtils.func_185181_a((Collection)effectInstances);
        return new RedstoneParticleData((float)ColorHelper.PackedColor.func_233007_b_((int)color) / 255.0f, (float)ColorHelper.PackedColor.func_233008_c_((int)color) / 255.0f, (float)ColorHelper.PackedColor.func_233009_d_((int)color) / 255.0f, 1.0f);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        TileEntity tile;
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof RafflesiaTileEntity && !((Boolean)state.func_177229_b((Property)ON_COOLDOWN)).booleanValue()) {
            RafflesiaTileEntity rafflesia = (RafflesiaTileEntity)tile;
            this.createCloud(worldIn, pos, rafflesia.Effects);
            worldIn.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)ON_COOLDOWN, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)HAS_STEW, (Comparable)Boolean.valueOf(false)));
            ListNBT Effects2 = new ListNBT();
            CompoundNBT tag = new CompoundNBT();
            tag.func_74774_a("EffectId", (byte)19);
            tag.func_74768_a("EffectDuration", 240);
            Effects2.add((Object)tag);
            rafflesia.Effects = Effects2;
            rafflesia.onChange(worldIn, worldIn.func_180495_p(pos));
        }
        super.func_196262_a(state, worldIn, pos, entityIn);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tile;
        ItemStack stack = player.func_184586_b(handIn);
        if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_222115_pz && (tile = worldIn.func_175625_s(pos)) instanceof RafflesiaTileEntity && !((Boolean)state.func_177229_b((Property)HAS_STEW)).booleanValue()) {
            RafflesiaTileEntity rafflesia = (RafflesiaTileEntity)tile;
            CompoundNBT tag = stack.func_77978_p();
            if (tag != null && tag.func_150297_b("Effects", 9)) {
                rafflesia.Effects = tag.func_150295_c("Effects", 10);
            }
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)HAS_STEW, (Comparable)Boolean.valueOf(true)));
            rafflesia.onChange(worldIn, worldIn.func_180495_p(pos));
            player.func_184611_a(handIn, player.field_71075_bZ.field_75098_d ? stack : new ItemStack((IItemProvider)Items.field_151054_z));
            worldIn.func_184133_a(null, pos, (SoundEvent)HabitatSoundEvents.BLOCK_RAFFLESIA_SLURP.get(), SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public boolean func_149653_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)ON_COOLDOWN);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (((Boolean)state.func_177229_b((Property)ON_COOLDOWN)).booleanValue() && random.nextInt(2) == 0) {
            this.cooldownReset(worldIn, pos, state);
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return (Boolean)state.func_177229_b((Property)HAS_STEW) == false || (Boolean)state.func_177229_b((Property)ON_COOLDOWN) != false;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((Property)ON_COOLDOWN)).booleanValue()) {
            this.cooldownReset(worldIn, pos, state);
        } else if (!((Boolean)state.func_177229_b((Property)HAS_STEW)).booleanValue()) {
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (int j = 0; j < 8; ++j) {
                blockpos$mutable.func_239621_a_((Vector3i)pos, MathHelper.func_76136_a((Random)rand, (int)1, (int)2) - MathHelper.func_76136_a((Random)rand, (int)1, (int)2), MathHelper.func_76136_a((Random)rand, (int)1, (int)2) - MathHelper.func_76136_a((Random)rand, (int)1, (int)2), MathHelper.func_76136_a((Random)rand, (int)1, (int)2) - MathHelper.func_76136_a((Random)rand, (int)1, (int)2));
                if (!worldIn.func_175623_d((BlockPos)blockpos$mutable) && !worldIn.func_180495_p((BlockPos)blockpos$mutable).func_185904_a().func_76222_j() || !worldIn.func_180495_p(blockpos$mutable.func_177977_b()).func_235714_a_(HabitatBlockTags.RAFFLESIA_PLANTABLE_ON)) continue;
                worldIn.func_180501_a((BlockPos)blockpos$mutable, state, 3);
                break;
            }
        }
    }

    private void cooldownReset(ServerWorld worldIn, BlockPos pos, BlockState state) {
        worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((Property)ON_COOLDOWN, (Comparable)Boolean.valueOf(false)));
        worldIn.func_184133_a(null, pos, (SoundEvent)HabitatSoundEvents.BLOCK_RAFFLESIA_POP.get(), SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
    }

    public boolean func_149740_M(BlockState state) {
        return (Boolean)state.func_177229_b((Property)HAS_STEW);
    }

    public int func_180641_l(BlockState state, World worldIn, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)HAS_STEW) != false ? 1 : 0;
    }

    @Nullable
    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.DANGER_OTHER;
    }
}

