/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.entity.item;

import mod.schnappdragon.habitat.core.registry.HabitatEntityTypes;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;

public class HabitatBoatEntity
extends BoatEntity {
    private static final DataParameter<Integer> BOAT_TYPE = EntityDataManager.func_187226_a(HabitatBoatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public HabitatBoatEntity(EntityType<? extends BoatEntity> typeIn, World worldIn) {
        super(typeIn, worldIn);
        this.field_70156_m = true;
    }

    public HabitatBoatEntity(World worldIn, double x, double y, double z) {
        this((EntityType<? extends BoatEntity>)((EntityType)HabitatEntityTypes.BOAT.get()), worldIn);
        this.func_70107_b(x, y, z);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = x;
        this.field_70167_r = y;
        this.field_70166_s = z;
    }

    public Type getHabitatBoatType() {
        return Type.byId((Integer)this.field_70180_af.func_187225_a(BOAT_TYPE));
    }

    public Item func_184455_j() {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("habitat", this.getHabitatBoatType().getName() + "_boat"));
    }

    public void setBoatType(Type boatType) {
        this.field_70180_af.func_187227_b(BOAT_TYPE, (Object)boatType.ordinal());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BOAT_TYPE, (Object)Type.FAIRY_RING_MUSHROOM.ordinal());
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("Type", this.getHabitatBoatType().getName());
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_150297_b("Type", 8)) {
            this.setBoatType(Type.getTypeFromString(compound.func_74779_i("Type")));
        }
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        this.field_184473_aH = this.func_213322_ci().field_72448_b;
        if (!this.func_184218_aH()) {
            if (onGroundIn) {
                if (this.field_70143_R > 3.0f) {
                    if (this.field_184469_aF != BoatEntity.Status.ON_LAND) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_225503_b_(this.field_70143_R, 1.0f);
                    if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                        this.func_70106_y();
                        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                            Item planks = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("habitat", this.getHabitatBoatType().getName() + "_planks"));
                            for (int i = 0; i < 3; ++i) {
                                this.func_199703_a((IItemProvider)planks);
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.func_199703_a((IItemProvider)Items.field_151055_y);
                            }
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (!this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177977_b()).func_206884_a((ITag)FluidTags.field_206959_a) && y < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - y);
            }
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum Type {
        FAIRY_RING_MUSHROOM("fairy_ring_mushroom");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] types = Type.values();
            if (id < 0 || id >= types.length) {
                id = 0;
            }
            return types[id];
        }

        public static Type getTypeFromString(String nameIn) {
            Type[] types;
            for (Type type : types = Type.values()) {
                if (!type.getName().equals(nameIn)) continue;
                return type;
            }
            return types[0];
        }
    }
}

