/*
 * Decompiled with CFR 0.152.
 */
package mod.schnappdragon.habitat.common.entity.monster;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.schnappdragon.habitat.core.HabitatConfig;
import mod.schnappdragon.habitat.core.registry.HabitatCriterionTriggers;
import mod.schnappdragon.habitat.core.registry.HabitatEntityTypes;
import mod.schnappdragon.habitat.core.registry.HabitatItems;
import mod.schnappdragon.habitat.core.registry.HabitatParticleTypes;
import mod.schnappdragon.habitat.core.registry.HabitatSoundEvents;
import mod.schnappdragon.habitat.core.tags.HabitatItemTags;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.IForgeShearable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class PookaEntity
extends RabbitEntity
implements IMob,
IForgeShearable {
    private static final DataParameter<Boolean> PACIFIED = EntityDataManager.func_187226_a(PookaEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int aidId;
    private int aidDuration;
    private int ailmentId;
    private int ailmentDuration;
    private int forgiveTicks = 0;

    public PookaEntity(EntityType<? extends PookaEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal(this, 2.2));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal(this).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, new NearestAttackableTargetGoal<RabbitEntity>(this, RabbitEntity.class, 10, true, false, livingEntity -> livingEntity.func_200600_R() == EntityType.field_200736_ab));
        this.field_70715_bh.func_75776_a(2, new NearestAttackableTargetGoal<PlayerEntity>(this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, new NearestAttackableTargetGoal<WolfEntity>(this, WolfEntity.class, true));
        this.field_70715_bh.func_75776_a(2, new NearestAttackableTargetGoal<IronGolemEntity>(this, IronGolemEntity.class, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal(this, 1.25, Ingredient.func_199805_a(HabitatItemTags.POOKA_FOOD), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal(this));
        this.field_70714_bg.func_75776_a(4, new AvoidEntityGoal<WolfEntity>(this, WolfEntity.class, 10.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(4, new AvoidEntityGoal<IronGolemEntity>(this, IronGolemEntity.class, 4.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(11, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 3.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 5.0).func_233815_a_(Attributes.field_233826_i_, 8.0);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)HabitatItems.POOKA_SPAWN_EGG.get());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PACIFIED, (Object)false);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("AidId", this.aidId);
        compound.func_74768_a("AidDuration", this.aidDuration);
        compound.func_74768_a("AilmentId", this.ailmentId);
        compound.func_74768_a("AilmentDuration", this.ailmentDuration);
        compound.func_74768_a("ForgiveTicks", this.forgiveTicks);
        compound.func_74757_a("IsPacified", this.isPacified());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setAidAndAilment(compound.func_74762_e("AidId"), compound.func_74762_e("AidDuration"), compound.func_74762_e("AilmentId"), compound.func_74762_e("AilmentDuration"));
        this.forgiveTicks = compound.func_74762_e("ForgiveTicks");
        this.setPacified(compound.func_74767_n("IsPacified"));
    }

    private void setAidAndAilment(int aidI, int aidD, int ailI, int ailD) {
        this.aidId = aidI;
        this.aidDuration = aidD;
        this.ailmentId = ailI;
        this.ailmentDuration = ailD;
    }

    private void setPacified(boolean isPacified) {
        this.field_70180_af.func_187227_b(PACIFIED, (Object)isPacified);
    }

    public boolean isPacified() {
        return (Boolean)this.field_70180_af.func_187225_a(PACIFIED);
    }

    private void setForgiveTimer() {
        this.forgiveTicks = 12000;
    }

    public void func_70619_bc() {
        LivingEntity livingentity;
        if (this.forgiveTicks > 0) {
            --this.forgiveTicks;
        }
        if (this.field_70122_E && !this.isPacified() && this.field_175538_bq == 0 && (livingentity = this.func_70638_az()) != null && this.func_70068_e((Entity)livingentity) < 16.0) {
            this.calculateRotationYaw(livingentity.func_226277_ct_(), livingentity.func_226281_cx_());
            this.field_70765_h.func_75642_a(livingentity.func_226277_ct_(), livingentity.func_226278_cu_(), livingentity.func_226281_cx_(), this.field_70765_h.func_75638_b());
            this.func_184770_cZ();
            this.field_175537_bp = true;
        }
        super.func_70619_bc();
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.func_226281_cx_()), (double)(x - this.func_226277_ct_())) * 57.2957763671875) - 90.0f;
    }

    public boolean isShearable(@Nonnull ItemStack item, World world, BlockPos pos) {
        return this.isPacified();
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable PlayerEntity player, @Nonnull ItemStack item, World world, BlockPos pos, int fortune) {
        world.func_217384_a(null, (Entity)this, (SoundEvent)HabitatSoundEvents.ENTITY_POOKA_SHEAR.get(), SoundCategory.HOSTILE, 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
        if (!this.field_70170_p.func_201670_d()) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226283_e_(0.5), this.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.func_70106_y();
            world.func_217376_c((Entity)PookaEntity.convertPooka(this));
        }
        return Collections.singletonList(new ItemStack((IItemProvider)HabitatItems.FAIRY_RING_MUSHROOM.get()));
    }

    public static RabbitEntity convertPooka(PookaEntity pooka) {
        RabbitEntity rabbit = (RabbitEntity)EntityType.field_200736_ab.func_200721_a(pooka.field_70170_p);
        rabbit.func_70012_b(pooka.func_226277_ct_(), pooka.func_226278_cu_(), pooka.func_226281_cx_(), pooka.field_70177_z, pooka.field_70125_A);
        rabbit.func_70606_j(pooka.func_110143_aJ());
        rabbit.field_70761_aq = pooka.field_70761_aq;
        if (pooka.func_145818_k_()) {
            rabbit.func_200203_b(pooka.func_200201_e());
            rabbit.func_174805_g(pooka.func_174833_aM());
        }
        if (pooka.func_104002_bU()) {
            rabbit.func_110163_bv();
        }
        rabbit.func_175529_r(pooka.func_175531_cl());
        rabbit.func_82227_f(pooka.func_70631_g_());
        rabbit.func_184224_h(pooka.func_190530_aW());
        return rabbit;
    }

    public static PookaEntity convertRabbit(RabbitEntity rabbit) {
        PookaEntity pooka = (PookaEntity)((EntityType)HabitatEntityTypes.POOKA.get()).func_200721_a(rabbit.field_70170_p);
        pooka.func_70012_b(rabbit.func_226277_ct_(), rabbit.func_226278_cu_(), rabbit.func_226281_cx_(), rabbit.field_70177_z, rabbit.field_70125_A);
        pooka.func_70606_j(rabbit.func_110143_aJ());
        pooka.field_70761_aq = rabbit.field_70761_aq;
        if (rabbit.func_145818_k_()) {
            pooka.func_200203_b(rabbit.func_200201_e());
            pooka.func_174805_g(rabbit.func_174833_aM());
        }
        pooka.func_110163_bv();
        pooka.setForgiveTimer();
        Pair<Integer, Integer> aid = pooka.getRandomAid();
        Pair<Integer, Integer> ailment = pooka.getRandomAilment();
        pooka.setAidAndAilment((Integer)aid.getLeft(), (Integer)aid.getRight(), (Integer)ailment.getLeft(), (Integer)ailment.getRight());
        pooka.func_175529_r(rabbit.func_175531_cl());
        pooka.func_82227_f(rabbit.func_70631_g_());
        pooka.func_184224_h(rabbit.func_190530_aW());
        return pooka;
    }

    public SoundCategory func_184176_by() {
        return this.isPacified() ? SoundCategory.NEUTRAL : SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184771_da() {
        return (SoundEvent)HabitatSoundEvents.ENTITY_POOKA_JUMP.get();
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)HabitatSoundEvents.ENTITY_POOKA_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)HabitatSoundEvents.ENTITY_POOKA_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)HabitatSoundEvents.ENTITY_POOKA_DEATH.get();
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vector3d vec, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.field_70170_p.field_72995_K && stack.func_77973_b().func_206844_a(HabitatItemTags.POOKA_FEEDING_FOOD)) {
            this.func_110163_bv();
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            int roll = this.field_70146_Z.nextInt(5);
            if (this.isPacified()) {
                this.func_70691_i(stack.func_77973_b().func_219967_s().func_221466_a());
            } else if (this.forgiveTicks == 0 && (this.func_70631_g_() && roll > 0 || roll == 0) && this.isAlone()) {
                this.setPacified(true);
                this.func_184185_a((SoundEvent)HabitatSoundEvents.ENTITY_POOKA_PACIFY.get(), 1.0f, 1.0f);
                HabitatCriterionTriggers.PACIFY_POOKA.trigger((ServerPlayerEntity)player);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.func_70604_c(null);
                this.field_70170_p.func_72960_a((Entity)this, (byte)11);
            } else {
                if (this.forgiveTicks > 0) {
                    this.forgiveTicks = (int)((double)this.forgiveTicks - (double)this.forgiveTicks * 0.1);
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)12);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_184199_a(player, vec, hand);
    }

    private boolean isAlone() {
        return this.field_70170_p.func_175647_a(PookaEntity.class, this.func_174813_aQ().func_72314_b(16.0, 10.0, 16.0), pooka -> !pooka.isPacified()).size() == 1;
    }

    public PookaEntity func_241840_a(ServerWorld serverWorld, AgeableEntity entity) {
        PookaEntity pooka = (PookaEntity)((EntityType)HabitatEntityTypes.POOKA.get()).func_200721_a((World)serverWorld);
        int i = this.getRandomRabbitType((IWorld)serverWorld);
        boolean pacified = false;
        Pair<Integer, Integer> aid = this.getRandomAid();
        int aidI = (Integer)aid.getLeft();
        int aidD = (Integer)aid.getRight();
        Pair<Integer, Integer> ailment = this.getRandomAilment();
        int ailI = (Integer)ailment.getLeft();
        int ailD = (Integer)ailment.getRight();
        if (entity instanceof PookaEntity) {
            PookaEntity parent = (PookaEntity)entity;
            boolean bl = pacified = this.isPacified() && parent.isPacified();
            if (this.field_70146_Z.nextInt(20) != 0) {
                i = this.field_70146_Z.nextBoolean() ? parent.func_175531_cl() : this.func_175531_cl();
            }
            if (this.field_70146_Z.nextInt(20) != 0) {
                if (this.field_70146_Z.nextBoolean()) {
                    aidI = parent.aidId;
                    aidD = parent.aidDuration;
                } else {
                    aidI = this.aidId;
                    aidD = this.aidDuration;
                }
            }
            if (this.field_70146_Z.nextInt(20) != 0) {
                if (this.field_70146_Z.nextBoolean()) {
                    ailI = parent.ailmentId;
                    ailD = parent.ailmentDuration;
                } else {
                    ailI = this.ailmentId;
                    ailD = this.ailmentDuration;
                }
            }
        }
        pooka.func_175529_r(i);
        pooka.setPacified(pacified);
        pooka.setAidAndAilment(aidI, aidD, ailI, ailD);
        pooka.func_110163_bv();
        return pooka;
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b().func_206844_a(HabitatItemTags.POOKA_BREEDING_FOOD);
    }

    public static boolean canPookaSpawn(EntityType<PookaEntity> pooka, IWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return world.func_180495_p(pos.func_177977_b()).func_203425_a(Blocks.field_196658_i);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Pair<Integer, Integer> aid = this.getRandomAid();
        Pair<Integer, Integer> ailment = this.getRandomAilment();
        boolean pacified = false;
        int i = this.getRandomRabbitType((IWorld)worldIn);
        int aidI = (Integer)aid.getLeft();
        int aidD = (Integer)aid.getRight();
        int ailI = (Integer)ailment.getLeft();
        int ailD = (Integer)ailment.getRight();
        if (spawnDataIn instanceof PookaData) {
            PookaData data = (PookaData)((Object)spawnDataIn);
            i = data.field_179427_a;
            aidI = data.aidIdData;
            aidD = data.aidDurationData;
            ailI = data.ailmentIdData;
            ailD = data.ailmentDurationData;
            pacified = data.pacifiedData;
        } else {
            spawnDataIn = new PookaData(i, aidI, aidD, ailI, ailD, false);
        }
        this.func_175529_r(i);
        this.setAidAndAilment(aidI, aidD, ailI, ailD);
        this.setPacified(pacified);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private int getRandomRabbitType(IWorld world) {
        Biome biome = world.func_226691_t_(this.func_233580_cy_());
        int i = this.field_70146_Z.nextInt(100);
        if (biome.func_201851_b() == Biome.RainType.SNOW) {
            return i < 80 ? 1 : 3;
        }
        if (biome.func_201856_r() == Biome.Category.DESERT) {
            return 4;
        }
        return i < 50 ? 0 : (i < 90 ? 5 : 2);
    }

    private Pair<Integer, Integer> getRandomAid() {
        return this.getEffect(HabitatConfig.COMMON.pookaPositiveEffects);
    }

    private Pair<Integer, Integer> getRandomAilment() {
        return this.getEffect(HabitatConfig.COMMON.pookaNegativeEffects);
    }

    private Pair<Integer, Integer> getEffect(ForgeConfigSpec.ConfigValue<String> config) {
        List<String> stewEffectPairs = Arrays.asList(StringUtils.deleteWhitespace((String)((String)config.get())).split(","));
        String[] pair = stewEffectPairs.get(this.field_70146_Z.nextInt(stewEffectPairs.size())).split(":");
        return Pair.of((Object)Integer.parseInt(pair[0]), (Object)(Integer.parseInt(pair[1]) * 20));
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn.func_200600_R() == EntityType.field_200736_ab && !entityIn.func_180431_b(DamageSource.func_76358_a((LivingEntity)this))) {
            this.func_184185_a((SoundEvent)HabitatSoundEvents.ENTITY_POOKA_ATTACK.get(), 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            RabbitEntity rabbit = (RabbitEntity)entityIn;
            rabbit.func_184185_a((SoundEvent)HabitatSoundEvents.ENTITY_RABBIT_CONVERTED_TO_POOKA.get(), 1.0f, rabbit.func_70631_g_() ? (rabbit.func_70681_au().nextFloat() - rabbit.func_70681_au().nextFloat()) * 0.2f + 1.5f : (rabbit.func_70681_au().nextFloat() - rabbit.func_70681_au().nextFloat()) * 0.2f + 1.0f);
            rabbit.func_70106_y();
            this.field_70170_p.func_217376_c((Entity)PookaEntity.convertRabbit(rabbit));
            for (int i = 0; i < 8; ++i) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)HabitatParticleTypes.FAIRY_RING_SPORE.get(), rabbit.func_226282_d_(0.5), rabbit.func_226283_e_(0.5), rabbit.func_226287_g_(0.5), 0, rabbit.func_70681_au().nextGaussian(), 0.0, rabbit.func_70681_au().nextGaussian(), 0.01);
            }
            return false;
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_233637_b_(Attributes.field_233823_f_));
        if (flag) {
            Effect effect;
            this.func_174815_a((LivingEntity)this, entityIn);
            this.func_184185_a((SoundEvent)HabitatSoundEvents.ENTITY_POOKA_ATTACK.get(), 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            if (!this.func_70631_g_() && entityIn instanceof LivingEntity && (effect = Effect.func_188412_a((int)this.ailmentId)) != null) {
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(effect, this.ailmentDuration * (this.field_70170_p.func_175659_aa() == Difficulty.HARD ? 2 : 1)));
                for (int i = 0; i < 2; ++i) {
                    ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)HabitatParticleTypes.FAIRY_RING_SPORE.get(), entityIn.func_226282_d_(0.5), entityIn.func_226283_e_(0.5), entityIn.func_226287_g_(0.5), 0, this.field_70146_Z.nextGaussian(), 0.0, this.field_70146_Z.nextGaussian(), 0.01);
                }
            }
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        Effect effect = Effect.func_188412_a((int)this.aidId);
        if (!this.func_70631_g_() && effect != null) {
            this.func_195064_c(new EffectInstance(effect, this.aidDuration));
            this.field_70170_p.func_72960_a((Entity)this, (byte)14);
        }
        if (this.isPacified() && source.func_76346_g() instanceof PlayerEntity && !source.func_180136_u()) {
            this.setPacified(false);
            this.setForgiveTimer();
            this.field_70170_p.func_72960_a((Entity)this, (byte)13);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70103_a(byte id) {
        if (id == 11) {
            this.spawnParticles((IParticleData)ParticleTypes.field_197633_z, 5, true);
        } else if (id == 12) {
            this.spawnParticles((IParticleData)ParticleTypes.field_197601_L, 5, true);
        } else if (id == 13) {
            this.spawnParticles((IParticleData)ParticleTypes.field_197609_b, 5, true);
        } else if (id == 14) {
            this.spawnParticles((IParticleData)HabitatParticleTypes.FAIRY_RING_SPORE.get(), 2, false);
        } else if (id == 15) {
            this.spawnParticles((IParticleData)HabitatParticleTypes.FAIRY_RING_SPORE.get(), 8, false);
        } else {
            super.func_70103_a(id);
        }
    }

    protected void spawnParticles(IParticleData particle, int number, boolean vanillaPresets) {
        for (int i = 0; i < number; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * (vanillaPresets ? 0.02 : 0.01);
            double d1 = vanillaPresets ? this.field_70146_Z.nextGaussian() * 0.02 : 0.0;
            double d2 = this.field_70146_Z.nextGaussian() * (vanillaPresets ? 0.02 : 0.01);
            double d3 = vanillaPresets ? 0.5 : 0.0;
            this.field_70170_p.func_195594_a(particle, this.func_226282_d_(0.5 + d3), this.func_226279_cv_() + d3, this.func_226287_g_(0.5 + d3), d0, d1, d2);
        }
    }

    static class AttackGoal
    extends MeleeAttackGoal {
        private final PookaEntity pooka;

        public AttackGoal(PookaEntity pooka) {
            super((CreatureEntity)pooka, 1.4, true);
            this.pooka = pooka;
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 4.0f + attackTarget.func_213311_cf();
        }

        public boolean func_75250_a() {
            return !this.pooka.isPacified() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return !this.pooka.isPacified() && super.func_75253_b();
        }
    }

    static class AvoidEntityGoal<T extends LivingEntity>
    extends net.minecraft.entity.ai.goal.AvoidEntityGoal<T> {
        private final PookaEntity pooka;

        public AvoidEntityGoal(PookaEntity pooka, Class<T> entity, float range, double v1, double v2) {
            super((CreatureEntity)pooka, entity, range, v1, v2);
            this.pooka = pooka;
        }

        public boolean func_75250_a() {
            return this.pooka.isPacified() && super.func_75250_a();
        }
    }

    static class NearestAttackableTargetGoal<T extends LivingEntity>
    extends net.minecraft.entity.ai.goal.NearestAttackableTargetGoal<T> {
        private final PookaEntity pooka;

        public NearestAttackableTargetGoal(PookaEntity pooka, Class<T> targetClassIn, boolean checkSight) {
            super((MobEntity)pooka, targetClassIn, checkSight);
            this.pooka = pooka;
        }

        public NearestAttackableTargetGoal(PookaEntity pooka, Class<T> targetClassIn, int targetChanceIn, boolean checkSight, boolean nearbyOnlyIn, @Nullable Predicate<LivingEntity> targetPredicate) {
            super((MobEntity)pooka, targetClassIn, targetChanceIn, checkSight, nearbyOnlyIn, targetPredicate);
            this.pooka = pooka;
        }

        public boolean func_75250_a() {
            return !this.pooka.isPacified() && super.func_75250_a();
        }
    }

    static class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        private final PookaEntity pooka;

        public HurtByTargetGoal(PookaEntity pooka) {
            super((CreatureEntity)pooka, new Class[0]);
            this.pooka = pooka;
        }

        public boolean func_75250_a() {
            return !this.pooka.isPacified() && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return !this.pooka.isPacified() && super.func_75253_b();
        }

        protected void func_190105_f() {
            double d0 = this.func_111175_f();
            AxisAlignedBB axisalignedbb = AxisAlignedBB.func_241549_a_((Vector3d)this.field_75299_d.func_213303_ch()).func_72314_b(d0, 10.0, d0);
            List list = this.field_75299_d.field_70170_p.func_225317_b(PookaEntity.class, axisalignedbb);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                PookaEntity pookaentity = (PookaEntity)((Object)iterator.next());
                if (this.field_75299_d == pookaentity || pookaentity.func_70638_az() != null || pookaentity.func_184191_r((Entity)this.field_75299_d.func_70643_av())) continue;
                if (this.field_75299_d.func_70643_av() instanceof PlayerEntity && pookaentity.isPacified()) {
                    pookaentity.setPacified(false);
                    pookaentity.setForgiveTimer();
                    pookaentity.field_70170_p.func_72960_a((Entity)pookaentity, (byte)13);
                }
                this.func_220793_a((MobEntity)pookaentity, this.field_75299_d.func_70643_av());
            }
            return;
        }
    }

    static class TemptGoal
    extends net.minecraft.entity.ai.goal.TemptGoal {
        private final PookaEntity pooka;

        public TemptGoal(PookaEntity pooka, double speed, Ingredient temptItem, boolean scaredByMovement) {
            super((CreatureEntity)pooka, speed, temptItem, scaredByMovement);
            this.pooka = pooka;
        }

        public boolean func_75250_a() {
            return this.pooka.isPacified() && super.func_75250_a();
        }

        public void func_75246_d() {
            super.func_75246_d();
            Effect aid = Effect.func_188412_a((int)this.pooka.aidId);
            if (!this.pooka.func_70631_g_() && this.pooka.func_70681_au().nextInt(30) == 0 && aid != null) {
                this.field_75289_h.func_195064_c(new EffectInstance(aid, this.pooka.aidDuration));
            }
        }
    }

    static class PanicGoal
    extends net.minecraft.entity.ai.goal.PanicGoal {
        private final PookaEntity pooka;

        public PanicGoal(PookaEntity pooka, double speedIn) {
            super((CreatureEntity)pooka, speedIn);
            this.pooka = pooka;
        }

        public void func_75246_d() {
            super.func_75246_d();
            this.pooka.func_175515_b(this.field_75265_b);
        }
    }

    public static class PookaData
    extends RabbitEntity.RabbitData {
        int aidIdData;
        int aidDurationData;
        int ailmentIdData;
        int ailmentDurationData;
        boolean pacifiedData;

        public PookaData(int type, int aidId, int aidDuration, int ailmentId, int ailmentDuration, boolean pacified) {
            super(type);
            this.aidIdData = aidId;
            this.aidDurationData = aidDuration;
            this.ailmentIdData = ailmentId;
            this.ailmentDurationData = ailmentDuration;
            this.pacifiedData = pacified;
        }
    }
}

